/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.integration.minecraft;

import com.mojang.authlib.GameProfile;
import li.cil.oc.Settings;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.prefab.DriverSidedTileEntity;
import li.cil.oc.integration.ManagedTileEntityEnvironment;
import li.cil.oc.util.BlockPosition;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public final class DriverInventory
extends DriverSidedTileEntity {
    @Override
    public Class<?> getTileEntityClass() {
        return IInventory.class;
    }

    @Override
    public ManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing side) {
        return new Environment(world.func_175625_s(pos), world);
    }

    public static final class Environment
    extends ManagedTileEntityEnvironment<IInventory> {
        private final EntityPlayer fakePlayer;
        private final BlockPosition position;

        public Environment(TileEntity tileEntity, World world) {
            super((IInventory)tileEntity, "inventory");
            this.fakePlayer = FakePlayerFactory.get((WorldServer)((WorldServer)world), (GameProfile)Settings.get().fakePlayerProfile());
            this.position = BlockPosition.apply(tileEntity.func_174877_v(), world);
        }

        @Callback(doc="function():string -- Get the name of this inventory.")
        public Object[] getInventoryName(Context context, Arguments args) {
            if (this.notPermitted()) {
                return new Object[]{null, "permission denied"};
            }
            return new Object[]{((IInventory)this.tileEntity).func_70005_c_()};
        }

        @Callback(doc="function():number -- Get the number of slots in this inventory.")
        public Object[] getInventorySize(Context context, Arguments args) {
            if (this.notPermitted()) {
                return new Object[]{null, "permission denied"};
            }
            return new Object[]{((IInventory)this.tileEntity).func_70302_i_()};
        }

        @Callback(doc="function(slot:number):number -- Get the stack size of the item stack in the specified slot.")
        public Object[] getSlotStackSize(Context context, Arguments args) {
            if (this.notPermitted()) {
                return new Object[]{null, "permission denied"};
            }
            int slot = this.checkSlot(args, 0);
            ItemStack stack = ((IInventory)this.tileEntity).func_70301_a(slot);
            if (!stack.func_190926_b()) {
                return new Object[]{stack.func_190916_E()};
            }
            return new Object[]{0};
        }

        @Callback(doc="function(slot:number):number -- Get the maximum stack size of the item stack in the specified slot.")
        public Object[] getSlotMaxStackSize(Context context, Arguments args) {
            if (this.notPermitted()) {
                return new Object[]{null, "permission denied"};
            }
            int slot = this.checkSlot(args, 0);
            ItemStack stack = ((IInventory)this.tileEntity).func_70301_a(slot);
            if (!stack.func_190926_b()) {
                return new Object[]{Math.min(((IInventory)this.tileEntity).func_70297_j_(), stack.func_77976_d())};
            }
            return new Object[]{((IInventory)this.tileEntity).func_70297_j_()};
        }

        @Callback(doc="function(slotA:number, slotB:number):boolean -- Compare the two item stacks in the specified slots for equality.")
        public Object[] compareStacks(Context context, Arguments args) {
            int slotB;
            if (this.notPermitted()) {
                return new Object[]{null, "permission denied"};
            }
            int slotA = this.checkSlot(args, 0);
            if (slotA == (slotB = this.checkSlot(args, 1))) {
                return new Object[]{true};
            }
            ItemStack stackA = ((IInventory)this.tileEntity).func_70301_a(slotA);
            ItemStack stackB = ((IInventory)this.tileEntity).func_70301_a(slotB);
            if (stackA.func_190926_b() && stackB.func_190926_b()) {
                return new Object[]{true};
            }
            if (!stackA.func_190926_b() && !stackB.func_190926_b()) {
                return new Object[]{this.itemEquals(stackA, stackB)};
            }
            return new Object[]{false};
        }

        @Callback(doc="function(slotA:number, slotB:number[, count:number=math.huge]):boolean -- Move up to the specified number of items from the first specified slot to the second.")
        public Object[] transferStack(Context context, Arguments args) {
            if (this.notPermitted()) {
                return new Object[]{null, "permission denied"};
            }
            int slotA = this.checkSlot(args, 0);
            int slotB = this.checkSlot(args, 1);
            int count = Math.max(0, Math.min(args.count() > 2 && args.checkAny(2) != null ? args.checkInteger(2) : 64, ((IInventory)this.tileEntity).func_70297_j_()));
            if (slotA == slotB || count == 0) {
                return new Object[]{true};
            }
            ItemStack stackA = ((IInventory)this.tileEntity).func_70301_a(slotA);
            ItemStack stackB = ((IInventory)this.tileEntity).func_70301_a(slotB);
            if (stackA.func_190926_b()) {
                return new Object[]{false};
            }
            if (stackB.func_190926_b()) {
                ((IInventory)this.tileEntity).func_70299_a(slotB, ((IInventory)this.tileEntity).func_70298_a(slotA, count));
                return new Object[]{true};
            }
            if (this.itemEquals(stackA, stackB)) {
                int space = Math.min(((IInventory)this.tileEntity).func_70297_j_(), stackB.func_77976_d()) - stackB.func_190916_E();
                int amount = Math.min(count, Math.min(space, stackA.func_190916_E()));
                if (amount > 0) {
                    stackA.func_190920_e(stackA.func_190916_E() - amount);
                    stackB.func_190920_e(stackB.func_190916_E() + amount);
                    if (stackA.func_190916_E() == 0) {
                        ((IInventory)this.tileEntity).func_70299_a(slotA, ItemStack.field_190927_a);
                    }
                    ((IInventory)this.tileEntity).func_70296_d();
                    return new Object[]{true};
                }
            } else if (count >= stackA.func_190916_E()) {
                ((IInventory)this.tileEntity).func_70299_a(slotB, stackA);
                ((IInventory)this.tileEntity).func_70299_a(slotA, stackB);
                return new Object[]{true};
            }
            return new Object[]{false};
        }

        @Callback(doc="function(slot:number):table -- Get a description of the item stack in the specified slot.")
        public Object[] getStackInSlot(Context context, Arguments args) {
            if (Settings.get().allowItemStackInspection()) {
                if (this.notPermitted()) {
                    return new Object[]{null, "permission denied"};
                }
                return new Object[]{((IInventory)this.tileEntity).func_70301_a(this.checkSlot(args, 0))};
            }
            return new Object[]{null, "not enabled in config"};
        }

        @Callback(doc="function():table -- Get a list of descriptions for all item stacks in this inventory.")
        public Object[] getAllStacks(Context context, Arguments args) {
            if (Settings.get().allowItemStackInspection()) {
                if (this.notPermitted()) {
                    return new Object[]{null, "permission denied"};
                }
                ItemStack[] allStacks = new ItemStack[((IInventory)this.tileEntity).func_70302_i_()];
                for (int i = 0; i < ((IInventory)this.tileEntity).func_70302_i_(); ++i) {
                    allStacks[i] = ((IInventory)this.tileEntity).func_70301_a(i);
                }
                return new Object[]{allStacks};
            }
            return new Object[]{null, "not enabled in config"};
        }

        private int checkSlot(Arguments args, int number) {
            int slot = args.checkInteger(number) - 1;
            if (slot < 0 || slot >= ((IInventory)this.tileEntity).func_70302_i_()) {
                throw new IllegalArgumentException("slot index out of bounds");
            }
            return slot;
        }

        private boolean itemEquals(ItemStack stackA, ItemStack stackB) {
            return stackA.func_77973_b().equals(stackB.func_77973_b()) && !stackA.func_77981_g() || stackA.func_77952_i() == stackB.func_77952_i();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean notPermitted() {
            EntityPlayer entityPlayer = this.fakePlayer;
            synchronized (entityPlayer) {
                this.fakePlayer.func_70107_b(this.position.toVec3().field_72450_a, this.position.toVec3().field_72448_b, this.position.toVec3().field_72449_c);
                PlayerInteractEvent.RightClickBlock event = new PlayerInteractEvent.RightClickBlock(this.fakePlayer, EnumHand.MAIN_HAND, this.position.toBlockPos(), EnumFacing.DOWN, null);
                MinecraftForge.EVENT_BUS.post((Event)event);
                return !event.isCanceled() && event.getUseBlock() != Event.Result.DENY && !((IInventory)this.tileEntity).func_70300_a(this.fakePlayer);
            }
        }
    }
}

