/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.mrcrayfish.furniture.advancement.Triggers;
import com.mrcrayfish.furniture.blocks.BlockFurnitureTile;
import com.mrcrayfish.furniture.init.FurnitureItems;
import com.mrcrayfish.furniture.tileentity.TileEntityBlender;
import com.mrcrayfish.furniture.util.TileEntityUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBlender
extends BlockFurnitureTile {
    public static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
    public static final AxisAlignedBB COLLISION_BOX = new AxisAlignedBB(0.28125, 0.0, 0.28125, 0.71875, 0.9375, 0.71875);

    public BlockBlender(Material material) {
        super(material);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185853_f);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            Triggers.trigger(Triggers.PLACE_APPLIANCE, (EntityPlayer)placer);
        }
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityBlender) {
            TileEntityBlender tileEntityBlender = (TileEntityBlender)tileEntity;
            if (tileEntityBlender.drinkCount == 0) {
                if (!(heldItem.func_190926_b() || tileEntityBlender.isFull() || tileEntityBlender.isBlending())) {
                    tileEntityBlender.addIngredient(heldItem.func_77946_l());
                    TileEntityUtil.markBlockForUpdate(worldIn, pos);
                    playerIn.func_184611_a(hand, ItemStack.field_190927_a);
                    return true;
                }
                if (!tileEntityBlender.isBlending()) {
                    if (playerIn.func_70093_af()) {
                        if (tileEntityBlender.hasValidIngredients()) {
                            tileEntityBlender.startBlending();
                            TileEntityUtil.markBlockForUpdate(worldIn, pos);
                            worldIn.func_175666_e(pos, (Block)this);
                        }
                    } else {
                        tileEntityBlender.removeIngredient();
                    }
                }
            } else if (!heldItem.func_190926_b() && tileEntityBlender.hasDrink()) {
                if (heldItem.func_77973_b() == FurnitureItems.CUP) {
                    if (heldItem.func_190916_E() == 0 | heldItem.func_190916_E() == 1) {
                        playerIn.func_184611_a(hand, tileEntityBlender.getDrink());
                    } else {
                        playerIn.field_71071_by.func_70441_a(tileEntityBlender.getDrink());
                        heldItem.func_190918_g(1);
                    }
                    playerIn.func_184185_a(SoundEvents.field_187615_H, 1.0f, 1.5f);
                    --tileEntityBlender.drinkCount;
                    TileEntityUtil.markBlockForUpdate(worldIn, pos);
                }
                return true;
            }
        }
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean p_185477_7_) {
        BlockFurnitureTile.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)COLLISION_BOX);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityBlender();
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Override
    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        if (world.func_175625_s(pos) instanceof TileEntityBlender) {
            TileEntityBlender blender = (TileEntityBlender)world.func_175625_s(pos);
            return blender.isBlending() ? 1 : 0;
        }
        return 0;
    }
}

