/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks.tv;

import com.google.common.collect.Maps;
import com.mrcrayfish.furniture.blocks.tv.Channel;
import com.mrcrayfish.furniture.init.FurnitureSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.audio.ISound;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;

public class Channels {
    public static final Map<BlockPos, ISound> SOUND_POSITIONS = Maps.newHashMap();
    private static List<Channel> channels = new ArrayList<Channel>();

    public static int getChannelCount() {
        return channels.size();
    }

    public static Channel getChannel(int channel) {
        return channels.get(channel);
    }

    public static Channel getChannel(String name) {
        return channels.stream().filter(channel -> channel.getChannelName().equals(name)).findFirst().orElse(null);
    }

    private static void registerChannel(String name, SoundEvent event) {
        channels.add(new Channel("channel_" + name, event));
    }

    public static void registerChannels() {
        Channels.registerChannel("news", FurnitureSounds.channel_news);
        Channels.registerChannel("cooking", FurnitureSounds.channel_cooking);
        Channels.registerChannel("sam_tabor", FurnitureSounds.channel_sam_tabor);
        Channels.registerChannel("heman", FurnitureSounds.channel_heman);
        Channels.registerChannel("switch", FurnitureSounds.channel_switch);
    }
}

