/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.registry;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;
import tinker_io.registry.FluidRegister;
import tinker_io.registry.ItemRegistry;
import tinker_io.registry.OreCrusherRecipeRegister;

public class MeltingRecipeRegister {
    public static final List<MeltingRecipe> customMeltingRecipes = Lists.newLinkedList();

    public static void register() {
        MeltingRecipeRegister.registerPureMetal();
    }

    private static void registerPureMetal() {
        OreCrusherRecipeRegister.oreCrusherRecipes.forEach(recipe -> {
            if (recipe.getItemStackOutput().func_77969_a(new ItemStack((Item)ItemRegistry.crushedOre)) && recipe.getOreDictInput() != null) {
                FluidStack fluidStack = new FluidStack((Fluid)FluidRegister.pureMetal, 144, new NBTTagCompound());
                fluidStack.tag.func_74778_a("oreDict", recipe.getOreDictInput());
                MeltingRecipeRegister.registerMeltingWithNBT(recipe.getItemStackOutput(), fluidStack, 300);
            }
        });
    }

    public static void registerMeltingWithNBT(ItemStack inputItem, FluidStack outputFluidStack, int meltingTime) {
        MeltingRecipe recipe = new MeltingRecipe(RecipeMatch.ItemCombination.ofNBT((ItemStack)inputItem, (int)outputFluidStack.amount), outputFluidStack, meltingTime);
        TinkerRegistry.registerMelting((MeltingRecipe)recipe);
        customMeltingRecipes.add(recipe);
    }

    public static void registerMelting(Item item, Fluid fluid, int outputAmount, int meltingTime) {
        TinkerRegistry.registerMelting((MeltingRecipe)new MeltingRecipe(RecipeMatch.of((Item)item, (int)outputAmount), fluid, meltingTime));
    }
}

