/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.registry;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import tinker_io.helper.CrushedOreHelper;
import tinker_io.helper.OreCrusherRecipe;
import tinker_io.helper.OreDictionaryHelper;

public class OreCrusherRecipeRegister {
    public static List<OreCrusherRecipe> oreCrusherRecipes = Lists.newLinkedList();
    public static List<String> oreCrusherBanList = Lists.newLinkedList();

    public static void init() {
        OreCrusherRecipeRegister.banRecipe();
        OreCrusherRecipeRegister.loadFromOreDict();
        OreCrusherRecipeRegister.loadOtherRecipe();
    }

    public static void banRecipe() {
        OreCrusherRecipeRegister.addBanOreDict("oreDiamond");
        OreCrusherRecipeRegister.addBanOreDict("oreEmerald");
        OreCrusherRecipeRegister.addBanOreDict("oreRedstone");
        OreCrusherRecipeRegister.addBanOreDict("oreQuartz");
        OreCrusherRecipeRegister.addBanOreDict("oreCoal");
        OreCrusherRecipeRegister.addBanOreDict("oreLapis");
        OreCrusherRecipeRegister.addBanOreDict("oreApatite");
        OreCrusherRecipeRegister.addBanOreDict("oreBlazium");
        OreCrusherRecipeRegister.addBanOreDict("oreBurnium");
        OreCrusherRecipeRegister.addBanOreDict("oreEndimium");
        OreCrusherRecipeRegister.addBanOreDict("oreJade");
        OreCrusherRecipeRegister.addBanOreDict("oreLanite");
        OreCrusherRecipeRegister.addBanOreDict("oreMeurodite");
        OreCrusherRecipeRegister.addBanOreDict("oreOnyx");
        OreCrusherRecipeRegister.addBanOreDict("oreQuartz");
        OreCrusherRecipeRegister.addBanOreDict("oreRadiantQuartz");
        OreCrusherRecipeRegister.addBanOreDict("oreRuby");
        OreCrusherRecipeRegister.addBanOreDict("oreSalt");
        OreCrusherRecipeRegister.addBanOreDict("oreSapphire");
        OreCrusherRecipeRegister.addBanOreDict("oreSoul");
        OreCrusherRecipeRegister.addBanOreDict("oreSunstone");
        OreCrusherRecipeRegister.addBanOreDict("oreCrystal");
        OreCrusherRecipeRegister.addBanOreDict("oreZimphnode");
        OreCrusherRecipeRegister.addBanOreDict("oreSalt");
        OreCrusherRecipeRegister.addBanOreDict("oreKnightslime");
        OreCrusherRecipeRegister.addBanOreDict("orePigiron");
        OreCrusherRecipeRegister.addBanOreDict("oreManyullyn");
    }

    private static void loadFromOreDict() {
        String[] oreDicts;
        for (String oreDict : oreDicts = OreDictionary.getOreNames()) {
            if (oreCrusherBanList.contains(oreDict) || oreDict.length() < 3 || !oreDict.substring(0, 3).equals("ore") || OreDictionaryHelper.getItemStacksFromOreDict(oreDict).size() <= 0) continue;
            ItemStack itemStack = CrushedOreHelper.getCrushedOre(oreDict, 1);
            oreCrusherRecipes.add(new OreCrusherRecipe(oreDict, itemStack));
        }
    }

    private static void addBanOreDict(String oreDict) {
        oreCrusherBanList.add(oreDict);
    }

    private static void loadOtherRecipe() {
        OreCrusherRecipeRegister.addOreCrusherRecipe("oreCobalt");
        OreCrusherRecipeRegister.addOreCrusherRecipe("oreArdite");
    }

    public static void addOreCrusherRecipe(String oreDict) {
        OreCrusherRecipe recipe = new OreCrusherRecipe(oreDict, CrushedOreHelper.getCrushedOre(oreDict, 1));
        OreCrusherRecipeRegister.addOreCrusherRecipe(recipe);
    }

    public static void addOreCrusherRecipe(OreCrusherRecipe oreCrusherRecipe) {
        oreCrusherRecipes.add(oreCrusherRecipe);
    }

    public static OreCrusherRecipe find(ItemStack oreIn) {
        for (OreCrusherRecipe recipe : oreCrusherRecipes) {
            if (!recipe.match(oreIn)) continue;
            return recipe;
        }
        return OreCrusherRecipe.EMPTY;
    }
}

