/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.block.machine;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import tauri.dev.jsg.block.JSGAbstractCustomItemBlock;
import tauri.dev.jsg.creativetabs.JSGCreativeTabsHandler;
import tauri.dev.jsg.power.stargate.StargateAbstractEnergyStorage;
import tauri.dev.jsg.power.stargate.StargateItemEnergyStorage;
import tauri.dev.jsg.util.ItemHandlerHelper;
import tauri.dev.jsg.util.main.JSGProps;

public abstract class JSGMachineBlock
extends JSGAbstractCustomItemBlock {
    public JSGMachineBlock(String blockName) {
        super(Material.field_151573_f);
        this.setRegistryName("jsg:" + blockName);
        this.func_149663_c("jsg." + blockName);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149647_a(JSGCreativeTabsHandler.JSG_MACHINES_CREATIVE_TAB);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)JSGProps.FACING_HORIZONTAL, (Comparable)EnumFacing.NORTH));
        this.func_149713_g(0);
        this.func_149711_c(2.5f);
        this.func_149752_b(35.0f);
        this.setHarvestLevel("pickaxe", 3);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{JSGProps.FACING_HORIZONTAL});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)JSGProps.FACING_HORIZONTAL)).func_176736_b();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)JSGProps.FACING_HORIZONTAL, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public boolean func_180639_a(World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && !player.func_70093_af()) {
            this.showGui(player, hand, world, pos);
        }
        return !player.func_70093_af();
    }

    protected abstract void showGui(EntityPlayer var1, EnumHand var2, World var3, BlockPos var4);

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        StargateAbstractEnergyStorage capacitorEnergyStorage = (StargateAbstractEnergyStorage)((Object)world.func_175625_s(pos).getCapability(CapabilityEnergy.ENERGY, null));
        ItemStack stack = new ItemStack((Block)this);
        ((StargateItemEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)).setEnergyStored(capacitorEnergyStorage.getEnergyStored());
        return Arrays.asList(stack);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        world.func_175698_g(pos);
    }

    public void func_180633_a(World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, EntityLivingBase placer, @Nonnull ItemStack stack) {
        EnumFacing facing = placer.func_174811_aO().func_176734_d();
        state = state.func_177226_a((IProperty)JSGProps.FACING_HORIZONTAL, (Comparable)facing);
        world.func_175656_a(pos, state);
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        StargateAbstractEnergyStorage tileEnergyStorage = (StargateAbstractEnergyStorage)((Object)world.func_175625_s(pos).getCapability(CapabilityEnergy.ENERGY, null));
        tileEnergyStorage.setEnergyStored(energyStorage.getEnergyStored());
    }

    public void func_180663_b(World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) != null) {
            ItemHandlerHelper.dropInventoryItems(world, pos, (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null));
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean hasTileEntity(@Nonnull IBlockState state) {
        return true;
    }

    public abstract TileEntity createTileEntity(@Nonnull World var1, @Nonnull IBlockState var2);

    @Nonnull
    public EnumBlockRenderType func_149645_b(@Nonnull IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_149730_j(@Nonnull IBlockState state) {
        return false;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

