/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.block.stargate;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.block.stargate.StargateAbstractMemberBlock;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.stargate.merging.StargateAbstractMergeHelper;
import tauri.dev.jsg.stargate.merging.StargateOrlinMergeHelper;
import tauri.dev.jsg.tileentity.stargate.StargateAbstractBaseTile;
import tauri.dev.jsg.tileentity.stargate.StargateOrlinMemberTile;
import tauri.dev.jsg.util.main.JSGProps;

public final class StargateOrlinMemberBlock
extends StargateAbstractMemberBlock {
    private static final AxisAlignedBB BOTTOM = new AxisAlignedBB(0.4, 0.0, 0.25, 0.75, 0.5, 0.6);
    private static final AxisAlignedBB TOP = new AxisAlignedBB(0.4, 0.5, 0.25, 0.75, 1.0, 0.6);
    private static final AxisAlignedBB SOUTH = new AxisAlignedBB(0.4, 0.0, 0.0, 0.75, 1.0, 0.5);
    private static final AxisAlignedBB WEST = new AxisAlignedBB(0.5, 0.5, 0.25, 1.0, 1.0, 0.6);
    private static final AxisAlignedBB NORTH = new AxisAlignedBB(0.4, 0.5, 0.5, 0.75, 1.0, 1.0);
    private static final AxisAlignedBB EAST = new AxisAlignedBB(0.0, 0.5, 0.25, 0.5, 1.0, 0.6);

    public StargateOrlinMemberBlock() {
        super("stargate_orlin_member_block");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)JSGProps.RENDER_BLOCK, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)JSGProps.FACING_VERTICAL, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)JSGProps.ORLIN_VARIANT, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)JSGProps.ORLIN_BROKEN, (Comparable)Boolean.valueOf(false)));
        this.func_149713_g(0);
        this.func_149752_b(16.0f);
    }

    @Override
    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        worldIn.func_72885_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 5.0f, true, true).func_77278_a();
    }

    @Override
    protected StargateAbstractMergeHelper getMergeHelper() {
        return StargateOrlinMergeHelper.INSTANCE;
    }

    public void func_190948_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        NBTTagCompound compound;
        if (stack.func_77942_o() && (compound = stack.func_77978_p()).func_74764_b("openCount")) {
            tooltip.add(JSG.proxy.localize("tile.jsg.stargate_orlin_base_block.open_count", compound.func_74762_e("openCount"), JSGConfig.Stargate.mechanics.stargateOrlinMaxOpenCount));
        }
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        ItemStack stack = new ItemStack((Block)this);
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("openCount", 0);
        stack.func_77982_d(compound);
        items.add((Object)stack);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{JSGProps.RENDER_BLOCK, JSGProps.FACING_VERTICAL, JSGProps.ORLIN_VARIANT, JSGProps.ORLIN_BROKEN});
    }

    public int func_176201_c(IBlockState state) {
        return ((Boolean)state.func_177229_b((IProperty)JSGProps.RENDER_BLOCK) != false ? 8 : 0) | ((EnumFacing)state.func_177229_b((IProperty)JSGProps.ORLIN_VARIANT)).func_176745_a() | ((Boolean)state.func_177229_b((IProperty)JSGProps.ORLIN_BROKEN) != false ? 6 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)JSGProps.RENDER_BLOCK, (Comparable)Boolean.valueOf((meta & 8) != 0)).func_177226_a((IProperty)JSGProps.ORLIN_VARIANT, (Comparable)EnumFacing.func_82600_a((int)(meta & 7))).func_177226_a((IProperty)JSGProps.ORLIN_BROKEN, (Comparable)Boolean.valueOf((meta & 6) != 0));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        EnumFacing facing = placer.func_174811_aO().func_176734_d();
        StargateOrlinMemberTile memberTile = (StargateOrlinMemberTile)world.func_175625_s(pos);
        if (!world.field_72995_K) {
            boolean broken = false;
            NBTTagCompound compound = stack.func_77978_p();
            if (compound != null && compound.func_74764_b("openCount") && compound.func_74762_e("openCount") >= JSGConfig.Stargate.mechanics.stargateOrlinMaxOpenCount) {
                broken = true;
            }
            state = state.func_177226_a((IProperty)JSGProps.RENDER_BLOCK, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)JSGProps.ORLIN_VARIANT, (Comparable)facing).func_177226_a((IProperty)JSGProps.ORLIN_BROKEN, (Comparable)Boolean.valueOf(broken));
            world.func_180501_a(pos, state, 0);
            memberTile.initializeFromItemStack(stack);
            StargateAbstractBaseTile gateTile = this.getMergeHelper().findBaseTile((IBlockAccess)world, pos, facing, EnumFacing.SOUTH);
            if (gateTile != null) {
                gateTile.updateMergeState(this.getMergeHelper().checkBlocks((IBlockAccess)world, gateTile.func_174877_v(), (EnumFacing)world.func_180495_p(gateTile.func_174877_v()).func_177229_b((IProperty)JSGProps.FACING_HORIZONTAL), EnumFacing.SOUTH), facing, EnumFacing.SOUTH);
            }
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        StargateOrlinMemberTile memberTile = (StargateOrlinMemberTile)world.func_175625_s(pos);
        memberTile.addDrops((List<ItemStack>)drops);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess access, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)JSGProps.RENDER_BLOCK) != false ? new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0) : new AxisAlignedBB(0.4, 0.0, 0.25, 0.75, 1.0, 0.6);
    }

    private void add(BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, AxisAlignedBB bb) {
        AxisAlignedBB bb2 = bb.func_186670_a(pos);
        if (entityBox.func_72326_a(bb2)) {
            collidingBoxes.add(bb2);
        }
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)JSGProps.ORLIN_VARIANT);
        if (((Boolean)state.func_177229_b((IProperty)JSGProps.RENDER_BLOCK)).booleanValue()) {
            this.add(pos, entityBox, collidingBoxes, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
        } else {
            if (facing != EnumFacing.UP && facing != EnumFacing.DOWN) {
                this.add(pos, entityBox, collidingBoxes, BOTTOM);
            }
            switch (facing) {
                case UP: {
                    this.add(pos, entityBox, collidingBoxes, TOP);
                    break;
                }
                case EAST: {
                    this.add(pos, entityBox, collidingBoxes, EAST);
                    break;
                }
                case NORTH: {
                    this.add(pos, entityBox, collidingBoxes, NORTH);
                    break;
                }
                case SOUTH: {
                    this.add(pos, entityBox, collidingBoxes, SOUTH);
                    break;
                }
                case WEST: {
                    this.add(pos, entityBox, collidingBoxes, WEST);
                    break;
                }
            }
        }
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new StargateOrlinMemberTile();
    }

    @Override
    public Class<? extends TileEntity> getTileEntityClass() {
        return StargateOrlinMemberTile.class;
    }
}

