/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.block.transportrings;

import javax.annotation.Nonnull;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.block.JSGBlock;
import tauri.dev.jsg.creativetabs.JSGCreativeTabsHandler;
import tauri.dev.jsg.gui.GuiIdEnum;
import tauri.dev.jsg.tileentity.transportrings.TransportRingsAbstractTile;
import tauri.dev.jsg.util.ItemHandlerHelper;

public abstract class TransportRingsAbstractBlock
extends JSGBlock {
    public TransportRingsAbstractBlock(String name) {
        super(Material.field_151573_f);
        this.setRegistryName("jsg:" + name);
        this.func_149663_c("jsg." + name);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(JSGCreativeTabsHandler.JSG_RINGS_CREATIVE_TAB);
        this.func_149713_g(0);
        this.func_149711_c(3.0f);
        this.setHarvestLevel("pickaxe", 3);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TransportRingsAbstractTile ringsTile = (TransportRingsAbstractTile)world.func_175625_s(pos);
        if (!(world.field_72995_K || player.func_70093_af() || ringsTile == null || ringsTile.tryInsertUpgrade(player, hand))) {
            player.openGui((Object)JSG.instance, GuiIdEnum.GUI_RINGS.id, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public void func_180633_a(World world, @Nonnull BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TransportRingsAbstractTile ringsTile = (TransportRingsAbstractTile)world.func_175625_s(pos);
        if (!world.field_72995_K && ringsTile != null) {
            ringsTile.updateLinkStatus();
        }
    }

    public void func_180663_b(World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TransportRingsAbstractTile ringsTile;
        if (!world.field_72995_K && (ringsTile = (TransportRingsAbstractTile)world.func_175625_s(pos)) != null) {
            if (ringsTile.isLinked()) {
                ringsTile.getLinkedControllerTile(world).setLinkedRings(null, -1);
            }
            ringsTile.removeAllRings();
            ringsTile.onBreak();
            ItemHandlerHelper.dropInventoryItems(world, pos, (IItemHandler)ringsTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null));
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean hasTileEntity(@Nonnull IBlockState state) {
        return true;
    }

    public abstract TransportRingsAbstractTile createTileEntity(@Nonnull World var1, @Nonnull IBlockState var2);
}

