/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import tauri.dev.jsg.power.stargate.StargateItemEnergyStorage;

public class ItemCapabilityProvider
implements ICapabilityProvider {
    protected StargateItemEnergyStorage energyStorage;

    public ItemCapabilityProvider(ItemStack stack, @Nullable NBTTagCompound nbt, int maxEnergy) {
        this(stack, nbt, maxEnergy, false);
    }

    public ItemCapabilityProvider(ItemStack stack, @Nullable NBTTagCompound nbt, int maxEnergy, final boolean creative) {
        this.energyStorage = new StargateItemEnergyStorage(stack, maxEnergy){

            @Override
            public void setEnergyStored(int energy) {
                super.setEnergyStored(creative ? this.maxEnergyStored : energy);
            }

            @Override
            public int getEnergyStored() {
                if (creative) {
                    return this.maxEnergyStored;
                }
                return super.getEnergyStored();
            }

            @Override
            public int extractEnergy(int max, boolean simulate) {
                if (creative) {
                    this.setEnergyStored(this.maxEnergyStored);
                    return max;
                }
                return super.extractEnergy(max, simulate);
            }

            @Override
            public int receiveEnergy(int max, boolean simulate) {
                if (creative) {
                    this.setEnergyStored(this.maxEnergyStored);
                    return max;
                }
                return super.receiveEnergy(max, simulate);
            }

            @Override
            public boolean canReceive() {
                if (creative) {
                    return false;
                }
                return super.canReceive();
            }
        };
        if (nbt != null && nbt.func_150297_b("Parent", 10)) {
            this.backwardsCompat(nbt.func_74775_l("Parent"));
        }
    }

    private void backwardsCompat(NBTTagCompound nbt) {
        if (nbt.func_150297_b("energy", 3)) {
            this.energyStorage.setEnergyStored(nbt.func_74762_e("energy"));
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityEnergy.ENERGY ? CapabilityEnergy.ENERGY.cast((Object)this.energyStorage) : null);
    }
}

