/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.event;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.gui.GuiSendCode;
import tauri.dev.jsg.gui.PageRenameGui;
import tauri.dev.jsg.gui.entry.NotebookEntryChangeGui;
import tauri.dev.jsg.gui.entry.OCEntryChangeGui;
import tauri.dev.jsg.gui.entry.UniverseEntryChangeGui;
import tauri.dev.jsg.item.JSGItems;
import tauri.dev.jsg.item.linkable.dialer.UniverseDialerActionEnum;
import tauri.dev.jsg.item.linkable.dialer.UniverseDialerActionPacketToServer;
import tauri.dev.jsg.item.linkable.dialer.UniverseDialerItem;
import tauri.dev.jsg.item.linkable.gdo.GDOActionEnum;
import tauri.dev.jsg.item.linkable.gdo.GDOActionPacketToServer;
import tauri.dev.jsg.item.linkable.gdo.GDOMode;
import tauri.dev.jsg.item.notebook.NotebookActionEnum;
import tauri.dev.jsg.item.notebook.NotebookActionPacketToServer;
import tauri.dev.jsg.packet.JSGPacketHandler;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class InputHandlerClient {
    private static final KeyBinding MODE_SCROLL = new KeyBinding("config.jsg.mode_scroll", 29, "JSG");
    private static final KeyBinding ADDRESS_SCROLL = new KeyBinding("config.jsg.address_scroll", 42, "JSG");
    private static final KeyBinding MODE_UP = new KeyBinding("config.jsg.mode_up", 0, "JSG");
    private static final KeyBinding MODE_DOWN = new KeyBinding("config.jsg.mode_down", 0, "JSG");
    private static final KeyBinding ADDRESS_UP = new KeyBinding("config.jsg.address_up", 0, "JSG");
    private static final KeyBinding ADDRESS_DOWN = new KeyBinding("config.jsg.address_down", 0, "JSG");
    private static final KeyBinding ADDRESS_EDIT = new KeyBinding("config.jsg.address_edit", 210, "JSG");
    private static final Method METHOD_UNPRESS = ObfuscationReflectionHelper.findMethod(KeyBinding.class, (String)"func_74505_d", Void.TYPE, (Class[])new Class[0]);
    private static final KeyBinding[] KEY_BINDINGS = new KeyBinding[]{MODE_SCROLL, ADDRESS_SCROLL, MODE_UP, MODE_DOWN, ADDRESS_UP, ADDRESS_DOWN, ADDRESS_EDIT};

    public static void registerKeybindings() {
        for (KeyBinding keyb : KEY_BINDINGS) {
            ClientRegistry.registerKeyBinding((KeyBinding)keyb);
        }
    }

    @Nullable
    public static EnumHand getHand(Item item) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        EnumHand hand = null;
        if (player == null) {
            return null;
        }
        if (player.func_184614_ca().func_77973_b() == item) {
            hand = EnumHand.MAIN_HAND;
        } else if (player.func_184592_cb().func_77973_b() == item) {
            hand = EnumHand.OFF_HAND;
        }
        return hand;
    }

    @Nullable
    public static ItemStack getItemStack(EntityPlayer player, Item item) {
        EnumHand hand = InputHandlerClient.getHand(item);
        if (hand != null) {
            return player.func_184586_b(hand);
        }
        return null;
    }

    public static boolean checkForItem(Item item) {
        return InputHandlerClient.getHand(item) != null;
    }

    @SubscribeEvent
    public static void onMouseEvent(MouseEvent event) {
        boolean next;
        if (event.getDwheel() == 0) {
            ItemStack itemStack;
            if (InputHandlerClient.checkForItem(JSGItems.GDO) && Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151470_d() && (itemStack = InputHandlerClient.getItemStack((EntityPlayer)Minecraft.func_71410_x().field_71439_g, JSGItems.GDO)) != null && itemStack.func_77942_o() && Objects.requireNonNull(itemStack.func_77978_p()).func_74764_b("linkedGate") && GDOMode.valueOf(itemStack.func_77978_p().func_74771_c("mode")) == GDOMode.CODE_SENDER) {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiSendCode(InputHandlerClient.getHand(JSGItems.GDO)));
            }
            return;
        }
        boolean bl = next = event.getDwheel() < 0;
        if (InputHandlerClient.checkForItem(JSGItems.UNIVERSE_DIALER)) {
            EnumHand hand = InputHandlerClient.getHand(JSGItems.UNIVERSE_DIALER);
            UniverseDialerActionEnum action = null;
            if (hand != null && Minecraft.func_71410_x().field_71439_g.func_184586_b(hand).func_77952_i() != UniverseDialerItem.UniverseDialerVariants.BROKEN.meta) {
                if (MODE_SCROLL.func_151470_d()) {
                    action = UniverseDialerActionEnum.MODE_CHANGE;
                } else if (ADDRESS_SCROLL.func_151470_d()) {
                    action = UniverseDialerActionEnum.ADDRESS_CHANGE;
                }
                if (action != null) {
                    event.setCanceled(true);
                    JSGPacketHandler.INSTANCE.sendToServer((IMessage)new UniverseDialerActionPacketToServer(action, hand, next));
                }
            }
        } else if (InputHandlerClient.checkForItem(JSGItems.GDO)) {
            EnumHand hand = InputHandlerClient.getHand(JSGItems.GDO);
            GDOActionEnum action = null;
            if (MODE_SCROLL.func_151470_d()) {
                action = GDOActionEnum.MODE_CHANGE;
            } else if (ADDRESS_SCROLL.func_151470_d()) {
                action = GDOActionEnum.ADDRESS_CHANGE;
            }
            if (action != null) {
                event.setCanceled(true);
                JSGPacketHandler.INSTANCE.sendToServer((IMessage)new GDOActionPacketToServer(action, hand, next));
            }
        } else if (InputHandlerClient.checkForItem(JSGItems.NOTEBOOK_ITEM)) {
            EnumHand hand = InputHandlerClient.getHand(JSGItems.NOTEBOOK_ITEM);
            NotebookActionEnum action = null;
            if (ADDRESS_SCROLL.func_151470_d()) {
                action = NotebookActionEnum.ADDRESS_CHANGE;
            }
            if (action != null) {
                event.setCanceled(true);
                JSGPacketHandler.INSTANCE.sendToServer((IMessage)new NotebookActionPacketToServer(action, hand, next));
            }
        }
    }

    @SubscribeEvent
    public static void onKeyboardEvent(TickEvent.ClientTickEvent event) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        boolean next;
        Enum action;
        EnumHand hand;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (InputHandlerClient.checkForItem(JSGItems.UNIVERSE_DIALER)) {
            hand = InputHandlerClient.getHand(JSGItems.UNIVERSE_DIALER);
            action = null;
            next = false;
            if (MODE_UP.func_151468_f()) {
                action = UniverseDialerActionEnum.MODE_CHANGE;
            } else if (MODE_DOWN.func_151468_f()) {
                action = UniverseDialerActionEnum.MODE_CHANGE;
                next = true;
            } else if (ADDRESS_UP.func_151468_f()) {
                action = UniverseDialerActionEnum.ADDRESS_CHANGE;
            } else if (ADDRESS_DOWN.func_151468_f()) {
                action = UniverseDialerActionEnum.ADDRESS_CHANGE;
                next = true;
            }
            if (action != null) {
                JSGPacketHandler.INSTANCE.sendToServer((IMessage)new UniverseDialerActionPacketToServer((UniverseDialerActionEnum)action, hand, next));
            }
        } else if (InputHandlerClient.checkForItem(JSGItems.GDO)) {
            hand = InputHandlerClient.getHand(JSGItems.GDO);
            action = null;
            next = false;
            if (MODE_UP.func_151468_f()) {
                action = GDOActionEnum.MODE_CHANGE;
            } else if (MODE_DOWN.func_151468_f()) {
                action = GDOActionEnum.MODE_CHANGE;
                next = true;
            } else if (ADDRESS_UP.func_151468_f()) {
                action = GDOActionEnum.ADDRESS_CHANGE;
            } else if (ADDRESS_DOWN.func_151468_f()) {
                action = GDOActionEnum.ADDRESS_CHANGE;
                next = true;
            }
            if (action != null) {
                JSGPacketHandler.INSTANCE.sendToServer((IMessage)new GDOActionPacketToServer((GDOActionEnum)action, hand, next));
            }
        } else if (InputHandlerClient.checkForItem(JSGItems.NOTEBOOK_ITEM)) {
            hand = InputHandlerClient.getHand(JSGItems.NOTEBOOK_ITEM);
            action = null;
            next = false;
            if (ADDRESS_UP.func_151468_f()) {
                action = NotebookActionEnum.ADDRESS_CHANGE;
            } else if (ADDRESS_DOWN.func_151468_f()) {
                action = NotebookActionEnum.ADDRESS_CHANGE;
                next = true;
            }
            if (action != null) {
                JSGPacketHandler.INSTANCE.sendToServer((IMessage)new NotebookActionPacketToServer((NotebookActionEnum)action, hand, next));
            }
        }
        if (ADDRESS_EDIT.func_151468_f()) {
            InputHandlerClient.tryOpenAddressGui((EntityPlayer)player);
        }
        for (KeyBinding keyBinding : KEY_BINDINGS) {
            if (keyBinding == MODE_SCROLL || keyBinding == ADDRESS_SCROLL) continue;
            METHOD_UNPRESS.invoke((Object)keyBinding, new Object[0]);
        }
    }

    private static void tryOpenAddressGui(EntityPlayer player) {
        EnumHand hand = InputHandlerClient.getHand(JSGItems.PAGE_NOTEBOOK_ITEM);
        if (hand != null) {
            ItemStack stack = player.func_184586_b(hand);
            if (stack.func_77960_j() == 1) {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new PageRenameGui(hand, stack));
            }
            return;
        }
        hand = InputHandlerClient.getHand(JSGItems.NOTEBOOK_ITEM);
        if (hand != null) {
            if (player.func_70093_af()) {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new PageRenameGui(hand, player.func_184586_b(hand)));
            } else {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new NotebookEntryChangeGui(hand, player.func_184586_b(hand).func_77978_p()));
            }
            return;
        }
        hand = InputHandlerClient.getHand(JSGItems.UNIVERSE_DIALER);
        if (hand != null) {
            if (player.func_70093_af()) {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new PageRenameGui(hand, player.func_184586_b(hand)));
            } else {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new UniverseEntryChangeGui(hand, player.func_184586_b(hand).func_77978_p(), player.field_70170_p));
            }
            return;
        }
        hand = InputHandlerClient.getHand(JSGItems.GDO);
        if (hand != null) {
            if (player.func_70093_af()) {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new PageRenameGui(hand, player.func_184586_b(hand)));
            } else if (JSG.ocWrapper.isModLoaded()) {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new OCEntryChangeGui(hand, player.func_184586_b(hand).func_77978_p(), null));
            }
        }
    }
}

