/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.gui.container.capacitor;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import tauri.dev.jsg.gui.util.ContainerHelper;
import tauri.dev.jsg.packet.JSGPacketHandler;
import tauri.dev.jsg.packet.StateUpdatePacketToClient;
import tauri.dev.jsg.power.stargate.StargateAbstractEnergyStorage;
import tauri.dev.jsg.state.StateTypeEnum;
import tauri.dev.jsg.tileentity.energy.CapacitorTile;

public class CapacitorContainer
extends Container {
    public CapacitorTile capTile;
    public Slot slot;
    private final BlockPos pos;
    private int lastEnergyStored;
    private int energyTransferedLastTick;

    public CapacitorContainer(IInventory playerInventory, World world, int x, int y, int z) {
        this.pos = new BlockPos(x, y, z);
        this.capTile = (CapacitorTile)world.func_175625_s(this.pos);
        IItemHandler itemHandler = (IItemHandler)Objects.requireNonNull(this.capTile).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        this.slot = new SlotItemHandler(itemHandler, 0, 80, 35);
        this.func_75146_a(this.slot);
        for (Slot slot : ContainerHelper.generatePlayerSlots(playerInventory, 81)) {
            this.func_75146_a(slot);
        }
    }

    public boolean func_75145_c(@Nonnull EntityPlayer player) {
        return true;
    }

    @Nonnull
    public ItemStack func_82846_b(@Nonnull EntityPlayer playerIn, int index) {
        ItemStack stack = this.func_75139_a(index).func_75211_c();
        if (index < 1) {
            if (!this.func_75135_a(stack, 1, this.field_75151_b.size(), false)) {
                return ItemStack.field_190927_a;
            }
        } else {
            if (stack.hasCapability(CapabilityEnergy.ENERGY, null) && !this.slot.func_75216_d()) {
                ItemStack stack1 = stack.func_77946_l();
                stack1.func_190920_e(1);
                this.slot.func_75215_d(stack1);
                stack.func_190918_g(1);
                return ItemStack.field_190927_a;
            }
            return ItemStack.field_190927_a;
        }
        this.func_75141_a(index, ItemStack.field_190927_a);
        return stack;
    }

    public void func_75142_b() {
        super.func_75142_b();
        StargateAbstractEnergyStorage energyStorage = (StargateAbstractEnergyStorage)((Object)this.capTile.getCapability(CapabilityEnergy.ENERGY, null));
        if (this.lastEnergyStored != Objects.requireNonNull(energyStorage).getEnergyStored() || this.energyTransferedLastTick != this.capTile.getEnergyTransferedLastTick()) {
            for (IContainerListener listener : this.field_75149_d) {
                if (!(listener instanceof EntityPlayerMP)) continue;
                JSGPacketHandler.INSTANCE.sendTo((IMessage)new StateUpdatePacketToClient(this.pos, StateTypeEnum.GUI_UPDATE, this.capTile.getState(StateTypeEnum.GUI_UPDATE)), (EntityPlayerMP)listener);
            }
            this.lastEnergyStored = energyStorage.getEnergyStored();
            this.energyTransferedLastTick = this.capTile.getEnergyTransferedLastTick();
        }
    }
}

