/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.gui.container.machine.pcbfabricator;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import tauri.dev.jsg.gui.util.ContainerHelper;
import tauri.dev.jsg.item.JSGItems;
import tauri.dev.jsg.packet.JSGPacketHandler;
import tauri.dev.jsg.packet.StateUpdatePacketToClient;
import tauri.dev.jsg.power.stargate.StargateAbstractEnergyStorage;
import tauri.dev.jsg.state.StateTypeEnum;
import tauri.dev.jsg.tileentity.machine.PCBFabricatorTile;

public class PCBFabricatorContainer
extends Container {
    public PCBFabricatorTile tile;
    public FluidTank tank;
    public ArrayList<Slot> slots = new ArrayList();
    private final BlockPos pos;
    private int lastEnergyStored;
    private int lastFluidStored;
    private int energyTransferedLastTick;
    private long machineStart = 0L;
    private long machineEnd = 0L;

    public boolean func_75145_c(@Nonnull EntityPlayer playerIn) {
        return true;
    }

    public PCBFabricatorContainer(IInventory playerInventory, World world, int x, int y, int z) {
        this.pos = new BlockPos(x, y, z);
        this.tile = (PCBFabricatorTile)world.func_175625_s(this.pos);
        if (this.tile != null) {
            IItemHandler itemHandler = (IItemHandler)this.tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            this.tank = (FluidTank)this.tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
            int i = 0;
            for (int y1 = 0; y1 < 3; ++y1) {
                for (int x1 = 0; x1 < 3; ++x1) {
                    this.slots.add((Slot)new SlotItemHandler(itemHandler, i, 16 + 18 * x1, 16 + 18 * y1));
                    ++i;
                }
            }
            this.slots.add((Slot)new SlotItemHandler(itemHandler, 9, 132, 33));
            for (Slot slot : this.slots) {
                this.func_75146_a(slot);
            }
            for (Slot slot : ContainerHelper.generatePlayerSlots(playerInventory, 94)) {
                this.func_75146_a(slot);
            }
        }
    }

    @Nonnull
    public ItemStack func_82846_b(@Nonnull EntityPlayer playerIn, int slotId) {
        ItemStack returnStack = ItemStack.field_190927_a;
        Slot slot = this.func_75139_a(slotId);
        if (slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            returnStack = stack.func_77946_l();
            if (slotId == 0 && stack.func_77973_b() != JSGItems.CRYSTAL_SEED) {
                return ItemStack.field_190927_a;
            }
            if (slotId < 10 ? !this.func_75135_a(stack, 10, this.field_75151_b.size(), true) : !this.func_75135_a(stack, 0, 10, true)) {
                return ItemStack.field_190927_a;
            }
            if (stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return returnStack;
    }

    public void func_75142_b() {
        super.func_75142_b();
        StargateAbstractEnergyStorage energyStorage = (StargateAbstractEnergyStorage)((Object)this.tile.getCapability(CapabilityEnergy.ENERGY, null));
        if (this.machineStart != this.tile.getMachineStart() || this.machineEnd != this.tile.getMachineEnd() || energyStorage != null && (this.lastEnergyStored != energyStorage.getEnergyStored() || this.energyTransferedLastTick != this.tile.getEnergyTransferedLastTick()) || this.lastFluidStored != this.tank.getFluidAmount()) {
            for (IContainerListener listener : this.field_75149_d) {
                if (!(listener instanceof EntityPlayerMP)) continue;
                JSGPacketHandler.INSTANCE.sendTo((IMessage)new StateUpdatePacketToClient(this.pos, StateTypeEnum.GUI_UPDATE, this.tile.getState(StateTypeEnum.GUI_UPDATE)), (EntityPlayerMP)listener);
            }
            if (energyStorage == null) {
                return;
            }
            this.lastEnergyStored = energyStorage.getEnergyStored();
            this.energyTransferedLastTick = this.tile.getEnergyTransferedLastTick();
            this.machineStart = this.tile.getMachineStart();
            this.machineEnd = this.tile.getMachineEnd();
            this.lastFluidStored = this.tank.getFluidAmount();
        }
    }
}

