/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.gui.container.machine.pcbfabricator;

import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.energy.CapabilityEnergy;
import tauri.dev.jsg.gui.container.machine.pcbfabricator.PCBFabricatorContainer;
import tauri.dev.jsg.gui.element.FluidTankElement;
import tauri.dev.jsg.power.stargate.StargateAbstractEnergyStorage;

public class PCBFabricatorContainerGui
extends GuiContainer {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("jsg", "textures/gui/container_pcb_fabricator.png");
    private final PCBFabricatorContainer container;
    private final FluidTankElement tank;

    public PCBFabricatorContainerGui(PCBFabricatorContainer container) {
        super((Container)container);
        this.container = container;
        this.field_146999_f = 175;
        this.field_147000_g = 175;
        this.tank = new FluidTankElement(this, this.field_147003_i + 80, this.field_147009_r + 15, 16, 54, container.tank);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        PCBFabricatorContainerGui.func_146110_a((int)this.field_147003_i, (int)this.field_147009_r, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (float)256.0f, (float)256.0f);
        long start = this.container.tile.getMachineStart();
        long end = this.container.tile.getMachineEnd();
        double progress = start == -1L || end == -1L || start == end ? 0.0 : (double)(this.container.tile.func_145831_w().func_82737_E() - start) / (double)(end - start);
        PCBFabricatorContainerGui.func_146110_a((int)(this.field_147003_i + 73), (int)(this.field_147009_r + 33), (float)176.0f, (float)0.0f, (int)((int)(40.0 * progress)), (int)15, (float)256.0f, (float)256.0f);
        StargateAbstractEnergyStorage energyStorage = (StargateAbstractEnergyStorage)((Object)this.container.tile.getCapability(CapabilityEnergy.ENERGY, null));
        int width = Math.round((float)energyStorage.getEnergyStored() / (float)energyStorage.getMaxEnergyStored() * 156.0f);
        this.func_73733_a(this.field_147003_i + 10, this.field_147009_r + 73, this.field_147003_i + 10 + width, this.field_147009_r + 73 + 6, -3397592, -9234922);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"tile.jsg.pcb_fabricator_block.name", (Object[])new Object[0]), 7, 6, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
        StargateAbstractEnergyStorage energyStorage = (StargateAbstractEnergyStorage)((Object)this.container.tile.getCapability(CapabilityEnergy.ENERGY, null));
        int energyStored = energyStorage.getEnergyStored();
        int maxEnergyStored = energyStorage.getMaxEnergyStored();
        String energyPercent = String.format("%.2f", Float.valueOf((float)energyStored / (float)maxEnergyStored * 100.0f)) + " %";
        this.field_146289_q.func_78276_b(energyPercent, 170 - this.field_146289_q.func_78256_a(energyPercent), this.field_147000_g - 96 + 2, 0x404040);
        this.tank.renderTank();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        this.func_73729_b(79, 14, 176, 32, 16, 54);
        GlStateManager.func_179084_k();
        this.tank.renderTooltip(mouseX, mouseY);
        int transferred = this.container.tile.getEnergyTransferedLastTick();
        TextFormatting transferredFormatting = TextFormatting.GRAY;
        String transferredSign = "";
        if (transferred > 0) {
            transferredFormatting = TextFormatting.GREEN;
            transferredSign = "+";
        } else if (transferred < 0) {
            transferredFormatting = TextFormatting.RED;
        }
        if (this.func_146978_c(10, 73, 156, 6, mouseX, mouseY)) {
            List<String> power = Arrays.asList(I18n.func_135052_a((String)"gui.stargate.energyBuffer", (Object[])new Object[0]), TextFormatting.GRAY + String.format("%,d / %,d RF", energyStorage.getEnergyStored(), energyStorage.getMaxEnergyStored()), transferredFormatting + transferredSign + String.format("%,d RF/t", transferred));
            this.func_146283_a(power, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }
}

