/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.gui.container.stargate;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import tauri.dev.jsg.gui.container.OpenTabHolderInterface;
import tauri.dev.jsg.gui.util.ContainerHelper;
import tauri.dev.jsg.item.energy.CapacitorItemBlock;
import tauri.dev.jsg.packet.JSGPacketHandler;
import tauri.dev.jsg.packet.StateUpdatePacketToClient;
import tauri.dev.jsg.power.stargate.StargateClassicEnergyStorage;
import tauri.dev.jsg.stargate.EnumIrisMode;
import tauri.dev.jsg.state.StateTypeEnum;
import tauri.dev.jsg.tileentity.stargate.StargateClassicBaseTile;

public class StargateContainer
extends Container
implements OpenTabHolderInterface {
    public StargateClassicBaseTile gateTile;
    public boolean isOperator;
    private final BlockPos pos;
    private int lastEnergyStored;
    private int energyTransferedLastTick;
    private float lastEnergySecondsToClose;
    private int lastProgress;
    private int openTabId = -1;
    private EnumIrisMode irisMode;
    private int irisCode;
    public long openedSince;
    private double gateTemp;
    private double irisTemp;

    public StargateContainer(IInventory playerInventory, World world, int x, int y, int z, boolean isOperator) {
        int col;
        this.isOperator = isOperator;
        this.pos = new BlockPos(x, y, z);
        this.gateTile = (StargateClassicBaseTile)world.func_175625_s(this.pos);
        IItemHandler itemHandler = (IItemHandler)Objects.requireNonNull(this.gateTile).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        for (col = 0; col < 4; ++col) {
            this.func_75146_a((Slot)new SlotItemHandler(itemHandler, col, 9 + 18 * col, 27));
        }
        for (col = 0; col < 3; ++col) {
            final int capacitorIndex = col;
            this.func_75146_a((Slot)new SlotItemHandler(itemHandler, col + 4, 115 + 18 * col, 27){

                public boolean func_111238_b() {
                    return capacitorIndex + 1 <= StargateContainer.this.gateTile.getSupportedCapacitors() || this.func_75216_d();
                }
            });
        }
        for (int i = 0; i < 3; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler(itemHandler, i + 7, -22, 89 + 22 * i));
        }
        this.func_75146_a((Slot)new SlotItemHandler(itemHandler, 10, 0, 0));
        this.func_75146_a((Slot)new SlotItemHandler(itemHandler, 11, 81, 27));
        for (Slot slot : ContainerHelper.generatePlayerSlots(playerInventory, 91)) {
            this.func_75146_a(slot);
        }
    }

    @Override
    public int getOpenTabId() {
        return this.openTabId;
    }

    @Override
    public void setOpenTabId(int tabId) {
        this.openTabId = tabId;
    }

    public boolean func_75145_c(@Nonnull EntityPlayer playerIn) {
        return true;
    }

    public void func_75137_b(int id, int data) {
        this.gateTile.setPageProgress(data);
    }

    @Nonnull
    public ItemStack func_82846_b(@Nonnull EntityPlayer player, int index) {
        ItemStack stack = this.func_75139_a(index).func_75211_c();
        if (index < 12) {
            if (!this.func_75135_a(stack, 12, this.field_75151_b.size(), false)) {
                return ItemStack.field_190927_a;
            }
        } else {
            if (stack.func_77973_b() instanceof CapacitorItemBlock) {
                for (int i = 4; i < 7; ++i) {
                    if (this.func_75139_a(i).func_75216_d() || !this.func_75139_a(i).func_75214_a(stack)) continue;
                    ItemStack stack1 = stack.func_77946_l();
                    stack1.func_190920_e(1);
                    this.func_75141_a(i, stack1);
                    stack.func_190918_g(1);
                    return stack;
                }
            } else if (StargateClassicBaseTile.StargateUpgradeEnum.contains(stack.func_77973_b()) && !this.gateTile.hasUpgrade(stack.func_77973_b())) {
                for (int i = 0; i < 4; ++i) {
                    if (this.func_75139_a(i).func_75216_d()) continue;
                    ItemStack stack1 = stack.func_77946_l();
                    stack1.func_190920_e(1);
                    this.func_75141_a(i, stack1);
                    stack.func_190918_g(1);
                    return ItemStack.field_190927_a;
                }
            } else if (this.openTabId >= 0 && this.openTabId <= 2 && this.func_75139_a(7 + this.openTabId).func_75214_a(stack)) {
                if (!this.func_75139_a(7 + this.openTabId).func_75216_d()) {
                    ItemStack stack1 = stack.func_77946_l();
                    stack1.func_190920_e(1);
                    this.func_75141_a(7 + this.openTabId, stack1);
                    stack.func_190918_g(1);
                    return ItemStack.field_190927_a;
                }
            } else if (this.openTabId == 3 && this.func_75139_a(10).func_75214_a(stack)) {
                if (!this.func_75139_a(10).func_75216_d()) {
                    ItemStack stack1 = stack.func_77946_l();
                    stack1.func_190920_e(1);
                    this.func_75141_a(10, stack1);
                    stack.func_190918_g(1);
                    return ItemStack.field_190927_a;
                }
            } else if (StargateClassicBaseTile.StargateIrisUpgradeEnum.contains(stack.func_77973_b()) && !this.gateTile.hasUpgrade(stack.func_77973_b()) && !this.func_75139_a(11).func_75216_d()) {
                ItemStack stack1 = stack.func_77946_l();
                stack1.func_190920_e(1);
                this.func_75141_a(11, stack1);
                stack.func_190918_g(1);
                return ItemStack.field_190927_a;
            }
            return ItemStack.field_190927_a;
        }
        this.func_75141_a(index, ItemStack.field_190927_a);
        return stack;
    }

    public void func_75142_b() {
        super.func_75142_b();
        StargateClassicEnergyStorage energyStorage = (StargateClassicEnergyStorage)((Object)this.gateTile.getCapability(CapabilityEnergy.ENERGY, null));
        if (this.lastEnergyStored != Objects.requireNonNull(energyStorage).getEnergyStoredInternally() || this.lastEnergySecondsToClose != this.gateTile.getEnergySecondsToClose() || this.energyTransferedLastTick != this.gateTile.getEnergyTransferedLastTick() || this.irisMode != this.gateTile.getIrisMode() || this.irisCode != this.gateTile.getIrisCode() || this.openedSince != this.gateTile.openedSince || Math.abs(this.gateTemp - this.gateTile.gateHeat) > 5.0 || this.gateTemp == -1.0 && this.gateTile.gateHeat != -1.0 || Math.abs(this.irisTemp - this.gateTile.irisHeat) > 5.0 || this.irisTemp == -1.0 && this.gateTile.irisHeat != -1.0) {
            for (IContainerListener listener : this.field_75149_d) {
                if (!(listener instanceof EntityPlayerMP)) continue;
                JSGPacketHandler.INSTANCE.sendTo((IMessage)new StateUpdatePacketToClient(this.pos, StateTypeEnum.GUI_UPDATE, this.gateTile.getState(StateTypeEnum.GUI_UPDATE)), (EntityPlayerMP)listener);
            }
            this.lastEnergyStored = energyStorage.getEnergyStoredInternally();
            this.energyTransferedLastTick = this.gateTile.getEnergyTransferedLastTick();
            this.lastEnergySecondsToClose = this.gateTile.getEnergySecondsToClose();
            this.openedSince = this.gateTile.openedSince;
            this.irisMode = this.gateTile.getIrisMode();
            this.irisCode = this.gateTile.getIrisCode();
            this.gateTemp = this.gateTile.gateHeat;
            this.irisTemp = this.gateTile.irisHeat;
        }
        if (this.lastProgress != this.gateTile.getPageProgress()) {
            for (IContainerListener listener : this.field_75149_d) {
                listener.func_71112_a((Container)this, 0, (int)this.gateTile.getPageProgress());
            }
            this.lastProgress = this.gateTile.getPageProgress();
        }
    }

    public void func_75132_a(@Nonnull IContainerListener listener) {
        super.func_75132_a(listener);
        if (listener instanceof EntityPlayerMP) {
            JSGPacketHandler.INSTANCE.sendTo((IMessage)new StateUpdatePacketToClient(this.pos, StateTypeEnum.GUI_STATE, this.gateTile.getState(StateTypeEnum.GUI_STATE)), (EntityPlayerMP)listener);
        }
    }
}

