/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import tauri.dev.jsg.creativetabs.JSGCreativeTab;

public class ItemHelper {
    public static Item createGenericItem(String name, JSGCreativeTab tab) {
        Item item = new Item();
        item.setRegistryName("jsg:" + name);
        item.func_77655_b("jsg." + name);
        if (tab != null) {
            item.func_77637_a((CreativeTabs)tab);
        }
        return item;
    }

    public static Item createDurabilityItem(String name, JSGCreativeTab tab, final int maxDamage, final boolean shouldStayInCrafting) {
        Item item = new Item(){

            public void setDamage(@Nonnull ItemStack stack, int damage) {
                if (damage >= maxDamage) {
                    stack.func_190920_e(0);
                    return;
                }
                NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
                if (nbt != null) {
                    nbt.func_74768_a("damage", damage);
                }
                stack.func_77982_d(nbt);
            }

            public boolean func_77645_m() {
                return true;
            }

            public int getMaxDamage(@Nonnull ItemStack stack) {
                return maxDamage;
            }

            public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
                tooltip.add(String.format("%.2f", (double)(maxDamage - this.getDamage(stack)) / (double)maxDamage * 100.0) + "%");
            }

            public int getDamage(ItemStack stack) {
                NBTTagCompound nbt;
                if (stack.func_77942_o() && (nbt = stack.func_77978_p()) != null) {
                    if (nbt.func_74764_b("damage")) {
                        return nbt.func_74762_e("damage");
                    }
                    nbt.func_74768_a("damage", 0);
                    stack.func_77982_d(nbt);
                }
                return 0;
            }

            public boolean showDurabilityBar(@Nonnull ItemStack stack) {
                return this.getDamage(stack) != 0;
            }

            public double getDurabilityForDisplay(@Nonnull ItemStack stack) {
                return (double)this.getDamage(stack) / (double)maxDamage;
            }

            @Nonnull
            public Item func_77656_e(int maxDamageIn) {
                throw new UnsupportedOperationException();
            }

            public void func_77622_d(ItemStack stack, @Nonnull World worldIn, @Nonnull EntityPlayer playerIn) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74768_a("damage", 0);
                stack.func_77982_d(nbt);
            }

            public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
                if (this.func_194125_a(tab)) {
                    items.add((Object)this.func_190903_i());
                }
            }

            @Nonnull
            public ItemStack func_190903_i() {
                ItemStack itemStack = new ItemStack((Item)this);
                this.setDamage(itemStack, 0);
                return itemStack;
            }

            public boolean canApplyAtEnchantingTable(@Nonnull ItemStack stack, @Nonnull Enchantment enchantment) {
                return enchantment.func_77320_a().equals("enchantment.unbreaking");
            }

            public int func_77619_b() {
                return 3;
            }

            public boolean hasContainerItem(@Nonnull ItemStack stack) {
                return shouldStayInCrafting;
            }

            @Nonnull
            public ItemStack getContainerItem(ItemStack itemStack) {
                ItemStack it = itemStack.func_77946_l();
                it.func_77964_b(itemStack.func_77952_i() + 1);
                return !shouldStayInCrafting ? super.getContainerItem(itemStack) : it;
            }
        };
        item.setRegistryName("jsg:" + name);
        item.func_77655_b("jsg." + name);
        if (tab != null) {
            item.func_77637_a((CreativeTabs)tab);
        }
        return item;
    }
}

