/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.item.stargate;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.creativetabs.JSGCreativeTabsHandler;

public class IrisItem
extends Item {
    public final int MAX_DAMAGE;

    public IrisItem(String name, int durability) {
        this.MAX_DAMAGE = durability;
        this.setRegistryName("jsg:" + name);
        this.func_77655_b("jsg." + name);
        this.func_77637_a(JSGCreativeTabsHandler.JSG_ITEMS_CREATIVE_TAB);
    }

    public void setDamage(@Nonnull ItemStack stack, int damage) {
        if (damage >= this.MAX_DAMAGE) {
            stack.func_190920_e(0);
            return;
        }
        NBTTagCompound nbt = null;
        if (stack.func_77942_o()) {
            nbt = stack.func_77978_p();
        }
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        nbt.func_74768_a("damage", damage);
        stack.func_77982_d(nbt);
    }

    public boolean func_77645_m() {
        return true;
    }

    public int getMaxDamage(@Nonnull ItemStack stack) {
        return this.MAX_DAMAGE;
    }

    public int getDamage(ItemStack stack) {
        NBTTagCompound nbt;
        if (stack.func_77942_o() && (nbt = stack.func_77978_p()) != null) {
            if (nbt.func_74764_b("damage")) {
                return nbt.func_74762_e("damage");
            }
            nbt.func_74768_a("damage", 0);
            stack.func_77982_d(nbt);
        }
        return 0;
    }

    public boolean showDurabilityBar(@Nonnull ItemStack stack) {
        return this.getDamage(stack) != 0;
    }

    public double getDurabilityForDisplay(@Nonnull ItemStack stack) {
        return (double)this.getDamage(stack) / (double)this.MAX_DAMAGE;
    }

    @Nonnull
    public Item func_77656_e(int maxDamageIn) {
        throw new UnsupportedOperationException("Tried to set durability of IRIS. Use config for that!");
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        float percent = (float)(this.MAX_DAMAGE - this.getDamage(stack)) / (float)this.MAX_DAMAGE * 100.0f;
        tooltip.add(I18n.func_135052_a((String)"item.jsg.iris.tooltip.integrity", (Object[])new Object[0]) + String.format(" %.2f", Float.valueOf(percent)) + " %");
        tooltip.add(I18n.func_135052_a((String)"item.jsg.iris.tooltip.durability", (Object[])new Object[0]) + String.format(" %,d / %,d", this.MAX_DAMAGE - this.getDamage(stack), this.MAX_DAMAGE));
    }

    public void func_77622_d(ItemStack stack, @Nonnull World worldIn, @Nonnull EntityPlayer playerIn) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("damage", 0);
        stack.func_77982_d(nbt);
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)this.func_190903_i());
        }
    }

    @Nonnull
    public ItemStack func_190903_i() {
        ItemStack itemStack = new ItemStack((Item)this);
        this.setDamage(itemStack, 0);
        return itemStack;
    }

    public boolean canApplyAtEnchantingTable(@Nonnull ItemStack stack, @Nonnull Enchantment enchantment) {
        if (JSGConfig.Stargate.iris.unbreakingChance == 0) {
            return false;
        }
        return enchantment.func_77320_a().equals("enchantment.unbreaking");
    }

    public int func_77619_b() {
        return 10;
    }
}

