/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.raycaster.util;

import java.util.Arrays;
import java.util.List;
import tauri.dev.vector.Vector2f;

public class Ray {
    public float a;
    public float b;
    public List<Vector2f> vertices;
    public int verticalOffset = 0;

    public Ray(List<Vector2f> verts) {
        this.vertices = verts;
        this.setLinear();
    }

    public Ray(Vector2f vert, Vector2f vert2) {
        this.vertices = Arrays.asList(vert, vert2);
        this.setLinear();
    }

    public Vector2f getVert(int index) {
        return this.vertices.get(index);
    }

    public Vector2f getVertWithOffset(int index) {
        return this.vertices.get(index + this.verticalOffset);
    }

    public void setVerticalOffset(int offset) {
        this.verticalOffset = this.getVertCount() < 3 ? 0 : offset;
        this.setLinear();
    }

    public Vector2f getIntersect(float a2, float b2) {
        float x = (b2 - this.b) / (this.a - a2);
        float y = x * this.a + this.b;
        return new Vector2f(x, y);
    }

    public String toString() {
        return String.format("y=%fx+%f", Float.valueOf(this.a), Float.valueOf(this.b));
    }

    public int getVertCount() {
        return this.vertices.size();
    }

    private void setLinear() {
        Vector2f func = this.linearFunction(this.vertices.get(0 + this.verticalOffset), this.vertices.get(1 + this.verticalOffset));
        this.a = func.x;
        this.b = func.y;
    }

    private Vector2f linearFunction(Vector2f A, Vector2f B) {
        float a = (B.y - A.y) / (B.x - A.x);
        float b = A.y - a * A.x;
        return new Vector2f(a, b);
    }
}

