/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.renderer.stargate;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import tauri.dev.jsg.loader.ElementEnum;
import tauri.dev.jsg.particle.ParticleBlender;
import tauri.dev.jsg.particle.ParticleBlenderSmoke;
import tauri.dev.jsg.particle.ParticleBlenderSparks;
import tauri.dev.jsg.renderer.stargate.StargateAbstractRenderer;
import tauri.dev.jsg.renderer.stargate.StargateAbstractRendererState;
import tauri.dev.jsg.renderer.stargate.StargateOrlinRendererState;
import tauri.dev.jsg.stargate.merging.StargateAbstractMergeHelper;
import tauri.dev.jsg.tileentity.stargate.StargateAbstractBaseTile;
import tauri.dev.jsg.util.main.JSGProps;

public class StargateOrlinRenderer
extends StargateAbstractRenderer<StargateAbstractRendererState> {
    public static final float GATE_SCALE = 0.43f;
    private static final List<ParticleBlender> GATE_PARTICLES = Arrays.asList(new ParticleBlenderSmoke(-2.71127f, 0.188794f, 5.76731f, 1, 10, -0.1f, 0.0f, false, motion -> {
        motion.z = (double)-0.03f + Math.random() * (double)0.06f;
    }), new ParticleBlenderSmoke(2.69834f, 0.210467f, 1.65171f, 1, 10, 0.1f, 0.0f, false, motion -> {
        motion.z = (double)-0.03f + Math.random() * (double)0.06f;
    }), new ParticleBlenderSmoke(-2.81152f, 0.007747f, 4.34894f, 1, 10, true, motion -> {
        motion.z = (double)0.03f + Math.random() * (double)0.05f;
    }), new ParticleBlenderSmoke(0.880709f, -0.045567f, 6.63663f, 2, 20, true, motion -> {
        motion.x = (double)-0.03f + Math.random() * (double)0.06f;
        motion.z = (double)0.03f + Math.random() * (double)0.01f;
    }), new ParticleBlenderSmoke(-1.2769f, -0.025613f, 1.15695f, 5, 50, false, motion -> {
        motion.x = (double)-0.03f + Math.random() * (double)0.06f;
        motion.z = (double)0.03f + Math.random() * (double)0.01f;
    }), new ParticleBlenderSmoke(1.2769f, -0.025613f, 1.15695f, 5, 50, false, motion -> {
        motion.x = (double)-0.03f + Math.random() * (double)0.06f;
        motion.z = (double)0.03f + Math.random() * (double)0.01f;
    }), new ParticleBlenderSmoke(2.27963f, 0.453827f, 5.722f, 5, 50, 0.0f, -0.01f, true, motion -> {
        motion.x = (double)-0.03f + Math.random() * (double)0.06f;
        motion.z = (double)-0.03f + Math.random() * (double)-0.01f;
    }), new ParticleBlenderSmoke(-2.36438f, 0.644607f, 5.53441f, 5, 50, 0.0f, -0.01f, true, motion -> {
        motion.x = (double)-0.03f + Math.random() * (double)0.06f;
        motion.z = (double)-0.03f + Math.random() * (double)-0.01f;
    }), new ParticleBlenderSmoke(-1.26211f, 0.45161f, 1.12577f, 5, 50, 0.0f, -0.01f, true, motion -> {
        motion.x = (double)-0.03f + Math.random() * (double)0.06f;
        motion.z = (double)-0.03f + Math.random() * (double)-0.01f;
    }));
    private static final ParticleBlender.RandomizeInterface SPARK_RANDOMIZER = motion -> {
        motion.x = 0.02 - Math.random() / 25.0;
        motion.z = 0.2 + Math.random() / 10.0;
    };
    private static final List<ParticleBlender> SPARK_PARTICLES = Arrays.asList(new ParticleBlenderSparks(2.3029f, -0.025317f, 5.64195f, 1, 1, false, SPARK_RANDOMIZER), new ParticleBlenderSparks(2.86498f, -0.020389f, 3.16358f, 1, 1, false, SPARK_RANDOMIZER), new ParticleBlenderSparks(1.27032f, -0.0208f, 1.17375f, 1, 1, false, SPARK_RANDOMIZER), new ParticleBlenderSparks(-1.27909f, -0.026023f, 1.15467f, 1, 1, false, SPARK_RANDOMIZER), new ParticleBlenderSparks(-2.86149f, -0.022729f, 3.15241f, 1, 1, false, SPARK_RANDOMIZER), new ParticleBlenderSparks(-2.32702f, -0.014086f, 5.54528f, 1, 1, false, SPARK_RANDOMIZER), new ParticleBlenderSparks(-5.7E-5f, -0.024829f, 6.74985f, 1, 1, false, SPARK_RANDOMIZER));

    @Override
    protected void renderGate(StargateAbstractBaseTile te, StargateAbstractRendererState rendererState, double partialTicks) {
        ElementEnum.ORLIN_GATE.bindTextureAndRender(rendererState.getBiomeOverlay());
    }

    @Override
    protected Map<BlockPos, IBlockState> getMemberBlockStates(StargateAbstractMergeHelper mergeHelper, EnumFacing facing, EnumFacing facingVertical) {
        HashMap<BlockPos, IBlockState> map = new HashMap<BlockPos, IBlockState>();
        for (BlockPos pos : mergeHelper.getRingBlocks()) {
            map.put(pos, mergeHelper.getMemberBlock().func_176223_P().func_177226_a((IProperty)JSGProps.ORLIN_VARIANT, (Comparable)facing));
        }
        return map;
    }

    @Override
    protected void applyLightMap(StargateAbstractRendererState rendererState, double partialTicks) {
    }

    @Override
    protected void applyTransformations(StargateAbstractRendererState rendererState) {
        GlStateManager.func_179137_b((double)0.5, (double)0.0, (double)0.5);
        GlStateManager.func_179152_a((float)0.43f, (float)0.43f, (float)0.43f);
    }

    @Override
    protected void renderKawoosh(StargateAbstractRendererState rendererState, double partialTicks) {
        GlStateManager.func_179109_b((float)0.0f, (float)3.80873f, (float)-0.204347f);
        GlStateManager.func_179152_a((float)0.7f, (float)0.7f, (float)0.7f);
        super.renderKawoosh(rendererState, partialTicks);
    }

    public static void spawnParticles(World world, StargateAbstractRendererState rendererState) {
        for (ParticleBlender particle : GATE_PARTICLES) {
            particle.spawn(world, rendererState.pos, rendererState.horizontalRotation, !rendererState.doEventHorizonRender);
        }
        long animTime = (world.func_82737_E() - ((StargateOrlinRendererState)rendererState).sparkStart) / 6L + 1L;
        if (animTime < 4L && animTime != 0L && world.func_82737_E() % animTime == 0L) {
            SPARK_PARTICLES.get(((StargateOrlinRendererState)rendererState).sparkIndex).spawn(world, rendererState.pos, rendererState.horizontalRotation, false);
        }
    }
}

