/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.stargate.teleportation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import javax.vecmath.Vector2f;
import net.minecraft.block.properties.IProperty;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import tauri.dev.jsg.advancements.JSGAdvancements;
import tauri.dev.jsg.api.event.StargateTeleportEntityEvent;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.item.stargate.IrisItem;
import tauri.dev.jsg.packet.JSGPacketHandler;
import tauri.dev.jsg.packet.stargate.StargateMotionToClient;
import tauri.dev.jsg.sound.JSGSoundHelper;
import tauri.dev.jsg.sound.SoundEventEnum;
import tauri.dev.jsg.stargate.network.StargatePos;
import tauri.dev.jsg.stargate.teleportation.TeleportHelper;
import tauri.dev.jsg.stargate.teleportation.TeleportPacket;
import tauri.dev.jsg.tileentity.stargate.StargateAbstractBaseTile;
import tauri.dev.jsg.tileentity.stargate.StargateClassicBaseTile;
import tauri.dev.jsg.util.JSGAdvancementsUtil;
import tauri.dev.jsg.util.JSGAxisAlignedBB;
import tauri.dev.jsg.util.main.JSGDamageSources;
import tauri.dev.jsg.util.main.JSGProps;

public class EventHorizon {
    private final World world;
    private final BlockPos pos;
    private final BlockPos gateCenter;
    private final JSGAxisAlignedBB localBox;
    private final JSGAxisAlignedBB globalBox;
    public static Random randomGenerator = new Random();
    private final Map<Integer, TeleportPacket> scheduledTeleportMap = new HashMap<Integer, TeleportPacket>();
    private final Map<Integer, Integer> timeoutMap = new HashMap<Integer, Integer>();

    public EventHorizon(World world, BlockPos pos, BlockPos gateCenter, EnumFacing facing, EnumFacing verticalFacing, JSGAxisAlignedBB localBox) {
        this.world = world;
        this.pos = pos;
        this.gateCenter = gateCenter;
        this.localBox = localBox.rotate(verticalFacing).rotate(facing).offset(0.5, 0.0, 0.5);
        this.globalBox = this.localBox.offset(pos);
    }

    public void reset() {
        this.scheduledTeleportMap.clear();
    }

    public JSGAxisAlignedBB getLocalBox() {
        return this.localBox;
    }

    public void scheduleTeleportation(StargatePos targetGate, boolean teleport) {
        if (targetGate == null) {
            return;
        }
        boolean closedIris = false;
        if (this.world.func_175625_s(this.pos) instanceof StargateClassicBaseTile && ((StargateClassicBaseTile)Objects.requireNonNull(this.world.func_175625_s(this.pos))).isIrisClosed()) {
            teleport = false;
            closedIris = true;
        }
        List entities = this.world.func_72872_a(Entity.class, (AxisAlignedBB)this.globalBox);
        if (teleport) {
            this.timeoutMap.replaceAll((i, v) -> this.timeoutMap.get(i) - 1);
            this.timeoutMap.entrySet().removeIf(entry -> (Integer)entry.getValue() < 0);
        }
        StargateAbstractBaseTile gateTile = (StargateAbstractBaseTile)this.world.func_175625_s(this.pos);
        for (Entity entity : entities) {
            int entityId = entity.func_145782_y();
            if (this.scheduledTeleportMap.containsKey(entityId) || this.timeoutMap.containsKey(entityId) || entity.func_184218_aH()) continue;
            EnumFacing sourceFacing = (EnumFacing)this.world.func_180495_p(this.pos).func_177229_b((IProperty)JSGProps.FACING_HORIZONTAL);
            EnumFacing targetFacing = (EnumFacing)targetGate.getBlockState().func_177229_b((IProperty)JSGProps.FACING_HORIZONTAL);
            float rotation = (float)Math.toRadians(EnumFacing.func_176733_a((double)(targetFacing.func_185119_l() - sourceFacing.func_185119_l())).func_176734_d().func_185119_l());
            TeleportPacket packet = new TeleportPacket(entity, this.pos, targetGate, rotation);
            if (teleport && entity instanceof EntityPlayerMP) {
                this.scheduledTeleportMap.put(entityId, packet);
                JSGPacketHandler.INSTANCE.sendTo((IMessage)new StargateMotionToClient(this.pos), (EntityPlayerMP)entity);
                continue;
            }
            Vector2f motion = new Vector2f((float)entity.field_70159_w, (float)entity.field_70179_y);
            boolean front = TeleportHelper.frontSide(sourceFacing, motion);
            if (!closedIris && teleport && front) {
                for (Entity passenger : entity.func_184188_bt()) {
                    this.timeoutMap.put(passenger.func_145782_y(), 40);
                }
                this.timeoutMap.put(entityId, 40);
                this.scheduledTeleportMap.put(entityId, packet.setMotion(motion));
                this.teleportEntity(entityId);
                continue;
            }
            if (gateTile != null && gateTile.entitiesPassedLast.containsKey(entityId) || closedIris || teleport || !front || !JSGConfig.Stargate.eventHorizon.wrongSideKilling) continue;
            this.wrongSideKill(entity);
        }
    }

    private void irisKill(Entity e) {
        e.func_70097_a(JSGDamageSources.DAMAGE_EVENT_IRIS_CREATIVE, Float.MAX_VALUE);
    }

    public void horizonKill(Entity e) {
        if (e instanceof EntityPlayerMP) {
            JSGAdvancements.KAWOOSH_CREMATION.trigger((EntityPlayerMP)e);
        }
        e.func_70097_a(JSGDamageSources.DAMAGE_EVENT_HORIZON, Float.MAX_VALUE);
    }

    public void wrongSideKill(Entity e) {
        e.func_70097_a(JSGDamageSources.DAMAGE_WRONG_SIDE, Float.MAX_VALUE);
    }

    public void unstableEhKill(Entity e) {
        e.func_70097_a(JSGDamageSources.UNSTABLE_EH_KILL, Float.MAX_VALUE);
    }

    public void teleportEntity(int entityId) {
        TeleportPacket packet = this.scheduledTeleportMap.get(entityId);
        StargateAbstractBaseTile baseTile = (StargateAbstractBaseTile)this.world.func_175625_s(this.pos);
        if (!new StargateTeleportEntityEvent(baseTile, packet.getTargetGatePos().getTileEntity(), packet.getEntity()).post()) {
            StargatePos targetGatePos = packet.getTargetGatePos();
            JSGSoundHelper.playSoundEvent(this.world, this.gateCenter, SoundEventEnum.WORMHOLE_GO);
            if (targetGatePos.getTileEntity() instanceof StargateClassicBaseTile && ((StargateClassicBaseTile)targetGatePos.getTileEntity()).isIrisClosed()) {
                if (packet.getEntity() instanceof IProjectile) {
                    Entity projectile = packet.getEntity();
                    projectile.field_70159_w = 0.0;
                    projectile.field_70181_x = 0.0;
                    projectile.field_70179_y = 0.0;
                    projectile.func_70106_y();
                } else {
                    if (JSGConfig.Stargate.iris.killAtDestination) {
                        packet.teleport(false);
                    }
                    if (JSGConfig.Stargate.iris.allowCreative && packet.getEntity() instanceof EntityPlayer && ((EntityPlayer)packet.getEntity()).field_71075_bZ.field_75098_d) {
                        if (!JSGConfig.Stargate.iris.killAtDestination) {
                            packet.teleport();
                        }
                    } else {
                        if (!packet.getEntity().func_184188_bt().isEmpty()) {
                            for (Entity passenger : packet.getEntity().func_184188_bt()) {
                                this.irisKill(passenger);
                            }
                        }
                        this.irisKill(packet.getEntity());
                        packet.getEntity().func_70106_y();
                    }
                }
                StargateClassicBaseTile classicTargetGate = (StargateClassicBaseTile)targetGatePos.getTileEntity();
                if (classicTargetGate.isPhysicalIris()) {
                    JSGSoundHelper.playSoundEvent(packet.getTargetGatePos().getWorld(), classicTargetGate.getGateCenterPos(), SoundEventEnum.IRIS_HIT);
                } else if (classicTargetGate.isShieldIris()) {
                    JSGSoundHelper.playSoundEvent(packet.getTargetGatePos().getWorld(), classicTargetGate.getGateCenterPos(), SoundEventEnum.SHIELD_HIT);
                }
                JSGAdvancementsUtil.tryTriggerRangedAdvancement(classicTargetGate, JSGAdvancementsUtil.EnumAdvancementType.IRIS_IMPACT);
                ItemStack irisItem = classicTargetGate.getItemHandler().getStackInSlot(11);
                if (irisItem.func_77973_b() instanceof IrisItem && irisItem.func_77984_f()) {
                    int chance = EnchantmentHelper.func_82781_a((ItemStack)irisItem).containsKey(Enchantments.field_185307_s) ? JSGConfig.Stargate.iris.unbreakingChance * EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)irisItem) : 0;
                    int random = randomGenerator.nextInt(100);
                    if (random > chance) {
                        irisItem.func_77973_b().setDamage(irisItem, irisItem.func_77973_b().getDamage(irisItem) + 1);
                    }
                    if (irisItem.func_190916_E() == 0) {
                        classicTargetGate.updateIrisType();
                    }
                    classicTargetGate.tryHeatUp(true, 2.0);
                } else {
                    IEnergyStorage energyStorage = (IEnergyStorage)classicTargetGate.getCapability(CapabilityEnergy.ENERGY, null);
                    if (energyStorage != null) {
                        energyStorage.extractEnergy(500, false);
                    }
                }
                classicTargetGate.sendSignal(null, "stargate_event_iris_hit", "Something just hit the IRIS!");
            } else if (baseTile != null && baseTile.isCurrentlyUnstable) {
                if (Math.random() < (double)JSGConfig.Stargate.eventHorizon.ehDeathChance) {
                    this.unstableEhKill(packet.getEntity());
                } else {
                    packet.teleport();
                    if (packet.getEntity() instanceof EntityPlayerMP) {
                        JSGAdvancements.UNSTABLE_SURVIVE.trigger((EntityPlayerMP)packet.getEntity());
                    }
                }
            } else {
                packet.teleport();
            }
        }
        this.scheduledTeleportMap.remove(entityId);
    }

    public void removeEntity(int entityId) {
        this.scheduledTeleportMap.remove(entityId);
    }

    public void setMotion(int entityId, Vector2f motionVector) {
        this.scheduledTeleportMap.get(entityId).setMotion(motionVector);
    }
}

