/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.tileentity.machine;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import tauri.dev.jsg.gui.container.machine.assembler.AssemblerContainerGuiUpdate;
import tauri.dev.jsg.item.JSGItems;
import tauri.dev.jsg.machine.AbstractMachineRecipe;
import tauri.dev.jsg.machine.assembler.AssemblerRecipe;
import tauri.dev.jsg.machine.assembler.AssemblerRecipes;
import tauri.dev.jsg.power.stargate.StargateAbstractEnergyStorage;
import tauri.dev.jsg.renderer.machine.AbstractMachineRendererState;
import tauri.dev.jsg.renderer.machine.AssemblerRendererState;
import tauri.dev.jsg.sound.JSGSoundHelper;
import tauri.dev.jsg.sound.SoundEventEnum;
import tauri.dev.jsg.sound.SoundPositionedEnum;
import tauri.dev.jsg.state.State;
import tauri.dev.jsg.state.StateTypeEnum;
import tauri.dev.jsg.tileentity.machine.AbstractMachineTile;
import tauri.dev.jsg.util.JSGItemStackHandler;

public class AssemblerTile
extends AbstractMachineTile {
    public AssemblerRendererState rendererState = new AssemblerRendererState();
    public static final int CONTAINER_SIZE = 12;
    protected final JSGItemStackHandler itemStackHandler = new JSGItemStackHandler(12){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (slot == 11) {
                return false;
            }
            if (slot == 0) {
                return JSGItems.isInItemsArray(stack.func_77973_b(), AssemblerTile.getAllowedSchematics());
            }
            return true;
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            if (slot == 0) {
                return 1;
            }
            return super.getStackLimit(slot, stack);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            AssemblerTile.this.func_70296_d();
            AssemblerTile.this.sendState(StateTypeEnum.RENDERER_UPDATE, AssemblerTile.this.getState(StateTypeEnum.RENDERER_UPDATE));
        }
    };
    protected final StargateAbstractEnergyStorage energyStorage = new StargateAbstractEnergyStorage(9000000, 20000){

        @Override
        protected void onEnergyChanged() {
            AssemblerTile.this.func_70296_d();
        }
    };

    public static Item[] getAllowedSchematics() {
        return new Item[]{JSGItems.SCHEMATIC_MILKYWAY, JSGItems.SCHEMATIC_PEGASUS, JSGItems.SCHEMATIC_UNIVERSE, JSGItems.SCHEMATIC_TR_GOAULD, JSGItems.SCHEMATIC_TR_ORI, JSGItems.SCHEMATIC_TR_ANCIENT};
    }

    @Override
    public StargateAbstractEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    @Override
    public JSGItemStackHandler getJSGItemHandler() {
        return this.itemStackHandler;
    }

    @Override
    protected void playLoopSound(boolean stop) {
        JSGSoundHelper.playPositionedSound(this.field_145850_b, this.field_174879_c, SoundPositionedEnum.BEAMER_LOOP, !stop);
    }

    @Override
    protected void playSound(boolean start) {
        if (!start) {
            JSGSoundHelper.playSoundEvent(this.field_145850_b, this.field_174879_c, SoundEventEnum.BEAMER_STOP);
        } else {
            JSGSoundHelper.playSoundEvent(this.field_145850_b, this.field_174879_c, SoundEventEnum.BEAMER_START);
        }
    }

    @Override
    public AbstractMachineRecipe getRecipeIfPossible() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 1; i < 10; ++i) {
            stacks.add(this.itemStackHandler.getStackInSlot(i));
        }
        Item scheme = this.itemStackHandler.getStackInSlot(0).func_77973_b();
        ItemStack subStack = this.itemStackHandler.getStackInSlot(10);
        for (AssemblerRecipe recipe : AssemblerRecipes.RECIPES) {
            if (this.itemStackHandler.insertItem(11, recipe.getResult(), true).equals(recipe.getResult()) || !recipe.isOk(this.energyStorage.getEnergyStored(), scheme, stacks, subStack)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    protected void workIsDone() {
        if (!this.isWorking) {
            return;
        }
        AssemblerRecipe currentRecipe = (AssemblerRecipe)this.currentRecipe;
        this.itemStackHandler.insertItem(11, currentRecipe.getResult(), false);
        for (int i = 1; i < 10; ++i) {
            int amount = 0;
            if (currentRecipe.getPattern().size() > i - 1 && currentRecipe.getPattern().get(i - 1) != null) {
                amount = currentRecipe.getPattern().get(i - 1).func_190916_E();
            }
            this.itemStackHandler.extractItem(i, amount, false);
        }
        if (currentRecipe.removeSubItem()) {
            this.itemStackHandler.extractItem(10, currentRecipe.getSubItemStack().func_190916_E(), false);
        } else if (currentRecipe.removeDurabilitySubItem() && this.itemStackHandler.getStackInSlot(10).func_77973_b().func_77645_m()) {
            this.itemStackHandler.getStackInSlot(10).func_77964_b(this.itemStackHandler.getStackInSlot(10).func_77952_i() + 1);
        }
        super.workIsDone();
    }

    @Override
    public State getState(StateTypeEnum stateType) {
        switch (stateType) {
            case GUI_UPDATE: {
                return new AssemblerContainerGuiUpdate(this.energyStorage.getEnergyStored(), this.energyTransferedLastTick, this.machineStart, this.machineEnd);
            }
            case RENDERER_UPDATE: {
                ItemStack stack = this.currentRecipe != null ? ((AssemblerRecipe)this.currentRecipe).getResult() : this.itemStackHandler.getStackInSlot(11);
                return new AssemblerRendererState(this.workStateChanged, this.machineProgress, this.isWorking, stack);
            }
        }
        return null;
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        switch (stateType) {
            case GUI_UPDATE: {
                return new AssemblerContainerGuiUpdate();
            }
            case RENDERER_UPDATE: {
                return new AssemblerRendererState();
            }
        }
        return null;
    }

    @Override
    public void setState(StateTypeEnum stateType, State state) {
        switch (stateType) {
            case GUI_UPDATE: {
                AssemblerContainerGuiUpdate guiUpdate = (AssemblerContainerGuiUpdate)state;
                this.energyStorage.setEnergyStored(guiUpdate.energyStored);
                this.energyTransferedLastTick = guiUpdate.energyTransferedLastTick;
                this.machineStart = guiUpdate.machineStart;
                this.machineEnd = guiUpdate.machineEnd;
                this.func_70296_d();
                break;
            }
            case RENDERER_UPDATE: {
                this.rendererState = (AssemblerRendererState)state;
                this.machineProgress = this.rendererState.machineProgress;
                this.isWorking = this.rendererState.isWorking;
                this.func_70296_d();
            }
        }
    }

    @Override
    public AbstractMachineRendererState getRendererState() {
        return this.rendererState;
    }
}

