/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.tileentity.machine;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import tauri.dev.jsg.gui.container.machine.orewashing.OreWashingContainerGuiUpdate;
import tauri.dev.jsg.machine.AbstractMachineRecipe;
import tauri.dev.jsg.machine.orewashing.OreWashingRecipe;
import tauri.dev.jsg.machine.orewashing.OreWashingRecipes;
import tauri.dev.jsg.power.stargate.StargateAbstractEnergyStorage;
import tauri.dev.jsg.renderer.machine.AbstractMachineRendererState;
import tauri.dev.jsg.renderer.machine.OreWashingRendererState;
import tauri.dev.jsg.sound.JSGSoundHelper;
import tauri.dev.jsg.sound.SoundEventEnum;
import tauri.dev.jsg.sound.SoundPositionedEnum;
import tauri.dev.jsg.state.State;
import tauri.dev.jsg.state.StateTypeEnum;
import tauri.dev.jsg.tileentity.machine.AbstractMachineTile;
import tauri.dev.jsg.util.JSGItemStackHandler;

public class OreWashingTile
extends AbstractMachineTile {
    public OreWashingRendererState rendererState = new OreWashingRendererState();
    public static final int CONTAINER_SIZE = 2;
    protected final JSGItemStackHandler itemStackHandler = new JSGItemStackHandler(2){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return slot != 1;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            OreWashingTile.this.func_70296_d();
            OreWashingTile.this.sendState(StateTypeEnum.RENDERER_UPDATE, OreWashingTile.this.getState(StateTypeEnum.RENDERER_UPDATE));
        }
    };
    protected final StargateAbstractEnergyStorage energyStorage = new StargateAbstractEnergyStorage(9000000, 20000){

        @Override
        protected void onEnergyChanged() {
            OreWashingTile.this.func_70296_d();
        }
    };
    protected final FluidTank fluidHandler = new FluidTank(15000){

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid != null;
        }

        protected void onContentsChanged() {
            OreWashingTile.this.func_70296_d();
            OreWashingTile.this.sendState(StateTypeEnum.RENDERER_UPDATE, OreWashingTile.this.getState(StateTypeEnum.RENDERER_UPDATE));
        }
    };

    @Override
    public StargateAbstractEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    @Override
    public JSGItemStackHandler getJSGItemHandler() {
        return this.itemStackHandler;
    }

    @Override
    protected void playLoopSound(boolean stop) {
        JSGSoundHelper.playPositionedSound(this.field_145850_b, this.field_174879_c, SoundPositionedEnum.BEAMER_LOOP, !stop);
    }

    @Override
    protected void playSound(boolean start) {
        if (!start) {
            JSGSoundHelper.playSoundEvent(this.field_145850_b, this.field_174879_c, SoundEventEnum.BEAMER_STOP);
        } else {
            JSGSoundHelper.playSoundEvent(this.field_145850_b, this.field_174879_c, SoundEventEnum.BEAMER_START);
        }
    }

    @Override
    public AbstractMachineRecipe getRecipeIfPossible() {
        for (OreWashingRecipe recipe : OreWashingRecipes.RECIPES) {
            if (this.itemStackHandler.insertItem(1, recipe.getResult(), true).equals(recipe.getResult()) || this.fluidHandler.getFluid() == null || !recipe.isOk(this.energyStorage.getEnergyStored(), new FluidStack(this.fluidHandler.getFluid(), this.fluidHandler.getFluidAmount()), this.itemStackHandler.getStackInSlot(0))) continue;
            return recipe;
        }
        return null;
    }

    @Override
    protected void workIsDone() {
        if (!this.isWorking) {
            return;
        }
        OreWashingRecipe recipe = (OreWashingRecipe)this.currentRecipe;
        this.itemStackHandler.insertItem(1, recipe.getResult(), false);
        this.itemStackHandler.extractItem(0, recipe.getItemNeeded().func_190916_E(), false);
        this.fluidHandler.drainInternal(recipe.getSubFluidStack().amount, true);
        super.workIsDone();
    }

    @Override
    public State getState(StateTypeEnum stateType) {
        switch (stateType) {
            case GUI_UPDATE: {
                return new OreWashingContainerGuiUpdate(this.energyStorage.getEnergyStored(), this.fluidHandler.getFluid() != null ? new FluidStack(this.fluidHandler.getFluid(), this.fluidHandler.getFluidAmount()) : null, this.energyTransferedLastTick, this.machineStart, this.machineEnd);
            }
            case RENDERER_UPDATE: {
                ItemStack stack = this.currentRecipe != null ? ((OreWashingRecipe)this.currentRecipe).getResult() : this.itemStackHandler.getStackInSlot(1);
                return new OreWashingRendererState(this.workStateChanged, this.machineProgress, this.isWorking, stack);
            }
        }
        return null;
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        switch (stateType) {
            case GUI_UPDATE: {
                return new OreWashingContainerGuiUpdate();
            }
            case RENDERER_UPDATE: {
                return new OreWashingRendererState();
            }
        }
        return null;
    }

    @Override
    public void setState(StateTypeEnum stateType, State state) {
        switch (stateType) {
            case GUI_UPDATE: {
                OreWashingContainerGuiUpdate guiUpdate = (OreWashingContainerGuiUpdate)state;
                this.energyStorage.setEnergyStored(guiUpdate.energyStored);
                this.energyTransferedLastTick = guiUpdate.energyTransferedLastTick;
                this.machineStart = guiUpdate.machineStart;
                this.machineEnd = guiUpdate.machineEnd;
                this.fluidHandler.setFluid(guiUpdate.fluidStack);
                this.func_70296_d();
                break;
            }
            case RENDERER_UPDATE: {
                this.rendererState = (OreWashingRendererState)state;
                this.machineProgress = this.rendererState.machineProgress;
                this.isWorking = this.rendererState.isWorking;
                this.func_70296_d();
            }
        }
    }

    @Override
    public AbstractMachineRendererState getRendererState() {
        return this.rendererState;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.fluidHandler);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound fluidHandlerCompound = new NBTTagCompound();
        this.fluidHandler.writeToNBT(fluidHandlerCompound);
        compound.func_74782_a("fluidHandler", (NBTBase)fluidHandlerCompound);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.fluidHandler.readFromNBT(compound.func_74775_l("fluidHandler"));
        super.func_145839_a(compound);
    }
}

