/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.tileentity.stargate;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.DimensionType;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.block.JSGBlocks;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.config.stargate.StargateDimensionConfig;
import tauri.dev.jsg.packet.JSGPacketHandler;
import tauri.dev.jsg.packet.StateUpdatePacketToClient;
import tauri.dev.jsg.power.stargate.StargateAbstractEnergyStorage;
import tauri.dev.jsg.power.stargate.StargateEnergyRequired;
import tauri.dev.jsg.renderer.biomes.BiomeOverlayEnum;
import tauri.dev.jsg.renderer.stargate.StargateAbstractRendererState;
import tauri.dev.jsg.renderer.stargate.StargateOrlinRendererState;
import tauri.dev.jsg.sound.JSGSoundHelper;
import tauri.dev.jsg.sound.SoundEventEnum;
import tauri.dev.jsg.sound.SoundPositionedEnum;
import tauri.dev.jsg.sound.StargateSoundEventEnum;
import tauri.dev.jsg.sound.StargateSoundPositionedEnum;
import tauri.dev.jsg.stargate.EnumScheduledTask;
import tauri.dev.jsg.stargate.EnumStargateState;
import tauri.dev.jsg.stargate.StargateClosedReasonEnum;
import tauri.dev.jsg.stargate.StargateOpenResult;
import tauri.dev.jsg.stargate.merging.StargateAbstractMergeHelper;
import tauri.dev.jsg.stargate.merging.StargateOrlinMergeHelper;
import tauri.dev.jsg.stargate.network.StargateAddress;
import tauri.dev.jsg.stargate.network.StargateNetwork;
import tauri.dev.jsg.stargate.network.StargatePos;
import tauri.dev.jsg.stargate.network.SymbolMilkyWayEnum;
import tauri.dev.jsg.stargate.network.SymbolTypeEnum;
import tauri.dev.jsg.state.State;
import tauri.dev.jsg.state.StateTypeEnum;
import tauri.dev.jsg.state.stargate.StargateOrlinSparkState;
import tauri.dev.jsg.tileentity.stargate.StargateAbstractBaseTile;
import tauri.dev.jsg.tileentity.util.ScheduledTask;
import tauri.dev.jsg.util.JSGAxisAlignedBB;
import tauri.dev.jsg.util.main.JSGProps;

public class StargateOrlinBaseTile
extends StargateAbstractBaseTile {
    private int openCount = 0;
    public static final EnumSet<BiomeOverlayEnum> SUPPORTED_OVERLAYS = EnumSet.of(BiomeOverlayEnum.NORMAL, BiomeOverlayEnum.FROST, BiomeOverlayEnum.MOSSY);
    private boolean isPowered;
    private int sparkIndex;
    private final StargateAbstractEnergyStorage energyStorate = new StargateAbstractEnergyStorage();
    public static final JSGAxisAlignedBB RENDER_BOX = new JSGAxisAlignedBB(-1.5, 0.0, -0.6, 1.5, 3.0, 1.5);

    @Override
    public void setLinkedDHD(BlockPos dhdPos, int linkId) {
    }

    public boolean isBroken() {
        if (this.openCount == JSGConfig.Stargate.mechanics.stargateOrlinMaxOpenCount) {
            return true;
        }
        return StargateOrlinMergeHelper.INSTANCE.getMaxOpenCount(this.field_145850_b, this.field_174879_c, this.facing) == JSGConfig.Stargate.mechanics.stargateOrlinMaxOpenCount;
    }

    public void addDrops(List<ItemStack> drops) {
        if (this.openCount == JSGConfig.Stargate.mechanics.stargateOrlinMaxOpenCount) {
            Random rand = new Random();
            drops.add(new ItemStack(Items.field_151042_j, 2 + rand.nextInt(3)));
        } else {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("openCount", this.openCount);
            ItemStack stack = new ItemStack(Item.func_150898_a((Block)JSGBlocks.STARGATE_ORLIN_BASE_BLOCK));
            stack.func_77982_d(compound);
            drops.add(stack);
        }
    }

    public void initializeFromItemStack(ItemStack stack) {
        NBTTagCompound compound;
        if (stack.func_77942_o() && (compound = stack.func_77978_p()).func_74764_b("openCount")) {
            this.openCount = compound.func_74762_e("openCount");
        }
    }

    @Override
    public SymbolTypeEnum getSymbolType() {
        return SymbolTypeEnum.MILKYWAY;
    }

    @Override
    public void dialingFailed(StargateOpenResult result) {
        super.dialingFailed(result);
        this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_FAILED_SOUND, 30));
    }

    @Override
    protected void addFailedTaskAndPlaySound() {
        this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_FAIL, 83));
        this.playSoundEvent(StargateSoundEventEnum.DIAL_FAILED);
    }

    @Override
    public void openGate(StargatePos targetGatePos, boolean isInitiating) {
        if (this.field_145850_b.field_73011_w.func_186058_p() == DimensionType.OVERWORLD) {
            StargateNetwork.get(this.field_145850_b).setLastActivatedOrlins((StargateAddress)this.gateAddressMap.get(SymbolTypeEnum.MILKYWAY));
        }
        super.openGate(targetGatePos, isInitiating);
    }

    @Override
    protected void disconnectGate() {
        super.disconnectGate();
        ++this.openCount;
        StargateOrlinMergeHelper.INSTANCE.incrementMembersOpenCount(this.field_145850_b, this.field_174879_c, this.facing);
        if (this.isBroken()) {
            this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_ORLIN_BROKE_SOUND, 5));
        }
    }

    @Override
    public boolean canAcceptConnectionFrom(StargatePos targetGatePos) {
        return super.canAcceptConnectionFrom(targetGatePos) && targetGatePos.dimensionID == DimensionType.NETHER.func_186068_a() && !this.isBroken();
    }

    public void updateNetherAddress() {
        this.dialedAddress.clear();
        if (!(this.network.hasNetherGate() && this.network.isStargateInNetwork(this.network.getNetherGate()) && this.network.getStargate(this.network.getNetherGate()) != null || this.field_145850_b.field_72995_K || this.field_145850_b.field_73011_w.func_186058_p() != DimensionType.OVERWORLD)) {
            JSG.info("Orlin gate requested building of new nether gate... Build started...");
            StargateNetwork.generateNetherGate(this.network, this.field_145850_b, this.field_174879_c);
        }
        if (this.network.hasNetherGate()) {
            this.dialedAddress.addAll(this.network.getNetherGate().subList(0, StargateDimensionConfig.netherOverworld8thSymbol() ? 7 : 6));
            this.dialedAddress.addSymbol(SymbolMilkyWayEnum.ORIGIN);
        }
        this.func_70296_d();
        JSG.debug("Orlin's dialed address: " + this.dialedAddress);
    }

    public StargateEnergyRequired getEnergyRequiredToDial() {
        return this.getEnergyRequiredToDial(this.network.getStargate(this.dialedAddress));
    }

    public int getEnergyStored() {
        return this.getEnergyStorage().getEnergyStored();
    }

    @Override
    public BlockPos getGateCenterPos() {
        return this.field_174879_c.func_177967_a(EnumFacing.UP, 1);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            if (!((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)JSGProps.RENDER_BLOCK)).booleanValue() && this.rendererStateClient != null) {
                JSG.proxy.orlinRendererSpawnParticles(this.field_145850_b, this.getRendererStateClient());
            }
            if (this.field_145850_b.func_82737_E() % 40L == 0L && this.rendererStateClient != null) {
                this.rendererStateClient.setBiomeOverlay(BiomeOverlayEnum.updateBiomeOverlay(this.field_145850_b, this.getMergeHelper().getTopBlock().func_177971_a((Vec3i)this.field_174879_c), this.getSupportedOverlays()));
            }
        }
    }

    @Override
    public EnumSet<BiomeOverlayEnum> getSupportedOverlays() {
        return SUPPORTED_OVERLAYS;
    }

    public void redstonePowerUpdate(boolean power) {
        if (!this.isMerged()) {
            return;
        }
        if (this.isPowered && !power || !this.isPowered && power) {
            this.isPowered = power;
            if (this.isPowered && this.stargateState.idle() && !this.isBroken()) {
                this.beginOpening();
            } else if (!this.isPowered && this.stargateState.initiating()) {
                this.attemptClose(StargateClosedReasonEnum.REQUESTED);
            }
            this.func_70296_d();
        }
    }

    public void beginOpening() {
        if (this.field_145850_b.field_73011_w.func_186058_p() != DimensionType.OVERWORLD) {
            JSGSoundHelper.playSoundEvent(this.field_145850_b, this.getGateCenterPos(), SoundEventEnum.GATE_ORLIN_FAIL);
            return;
        }
        this.updateNetherAddress();
        if (this.isBroken()) {
            return;
        }
        switch (this.checkAddressAndEnergy(this.dialedAddress)) {
            case OK: {
                this.stargateState = EnumStargateState.DIALING;
                this.startSparks();
                JSGSoundHelper.playSoundEvent(this.field_145850_b, this.getGateCenterPos(), SoundEventEnum.GATE_ORLIN_DIAL);
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_ORLIN_OPEN));
                return;
            }
            case ADDRESS_MALFORMED: {
                if (!this.field_145850_b.field_72995_K && this.field_145850_b.field_73011_w.func_186058_p() == DimensionType.OVERWORLD) {
                    StargateNetwork.generateNetherGate(this.network, this.field_145850_b, this.field_174879_c);
                    JSG.info("Orlin gate requested building of new nether gate... Build started...");
                }
                this.beginOpening();
                break;
            }
            case NOT_ENOUGH_POWER: {
                break;
            }
        }
    }

    @Override
    public StargateAbstractMergeHelper getMergeHelper() {
        return StargateOrlinMergeHelper.INSTANCE;
    }

    @Override
    protected JSGAxisAlignedBB getHorizonKillingBox(boolean server) {
        return new JSGAxisAlignedBB(-0.5, 1.0, -0.5, 0.5, 2.0, 1.5);
    }

    @Override
    protected int getHorizonSegmentCount(boolean server) {
        return 2;
    }

    @Override
    protected List<JSGAxisAlignedBB> getGateVaporizingBoxes(boolean server) {
        return Arrays.asList(new JSGAxisAlignedBB(-0.5, 1.0, -0.5, 0.5, 2.0, 0.5));
    }

    @Override
    protected JSGAxisAlignedBB getHorizonTeleportBox(boolean server) {
        return new JSGAxisAlignedBB(-1.0, 0.6, -0.15, 1.0, 2.7, -0.05);
    }

    @Override
    protected StargateAbstractRendererState createRendererStateClient() {
        return new StargateOrlinRendererState();
    }

    @Override
    public StargateOrlinRendererState getRendererStateClient() {
        return (StargateOrlinRendererState)super.getRendererStateClient();
    }

    @Override
    protected SoundPositionedEnum getPositionedSound(StargateSoundPositionedEnum soundEnum) {
        return null;
    }

    @Override
    protected SoundEventEnum getSoundEvent(StargateSoundEventEnum soundEnum) {
        switch (soundEnum) {
            case OPEN: {
                return SoundEventEnum.GATE_MILKYWAY_OPEN;
            }
            case CLOSE: {
                return SoundEventEnum.GATE_MILKYWAY_CLOSE;
            }
            case DIAL_FAILED: {
                return SoundEventEnum.GATE_ORLIN_FAIL;
            }
            case GATE_BROKE: {
                return SoundEventEnum.GATE_ORLIN_BROKE;
            }
        }
        return null;
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        switch (stateType) {
            case SPARK_STATE: {
                return new StargateOrlinSparkState();
            }
        }
        return super.createState(stateType);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setState(StateTypeEnum stateType, State state) {
        switch (stateType) {
            case SPARK_STATE: {
                if (this.getRendererStateClient() == null) break;
                StargateOrlinSparkState sparkState = (StargateOrlinSparkState)state;
                this.getRendererStateClient().sparkFrom(sparkState.sparkIndex, sparkState.spartStart);
                break;
            }
            default: {
                super.setState(stateType, state);
            }
        }
    }

    public void startSparks() {
        this.sparkIndex = 0;
        this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_ORLIN_SPARK, 5));
    }

    @Override
    public void executeTask(EnumScheduledTask scheduledTask, NBTTagCompound customData) {
        switch (scheduledTask) {
            case STARGATE_ORLIN_OPEN: {
                StargatePos targetGatePos = this.network.getStargate(this.dialedAddress);
                if (this.hasEnergyToDial(targetGatePos)) {
                    targetGatePos.getTileEntity().incomingWormhole(this.dialedAddress.size());
                }
                this.attemptOpenAndFail();
                break;
            }
            case STARGATE_ORLIN_SPARK: {
                JSGPacketHandler.INSTANCE.sendToAllTracking((IMessage)new StateUpdatePacketToClient(this.field_174879_c, StateTypeEnum.SPARK_STATE, new StargateOrlinSparkState(this.sparkIndex, this.field_145850_b.func_82737_E())), this.targetPoint);
                if (this.sparkIndex < 6 && this.sparkIndex != -1) {
                    this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_ORLIN_SPARK, 24));
                }
                ++this.sparkIndex;
                break;
            }
            case STARGATE_FAILED_SOUND: {
                this.playSoundEvent(StargateSoundEventEnum.DIAL_FAILED);
                break;
            }
            case STARGATE_ORLIN_BROKE_SOUND: {
                this.playSoundEvent(StargateSoundEventEnum.GATE_BROKE);
                break;
            }
            default: {
                super.executeTask(scheduledTask, customData);
            }
        }
    }

    @Override
    protected StargateAbstractEnergyStorage getEnergyStorage() {
        return this.energyStorate;
    }

    @Override
    protected StargateEnergyRequired getEnergyRequiredToDial(StargatePos targetGatePos) {
        return super.getEnergyRequiredToDial(targetGatePos).mul(JSGConfig.Stargate.power.stargateOrlinEnergyMul).cap(JSGConfig.Stargate.power.stargateEnergyStorage / 4 - 1000000);
    }

    @Override
    protected JSGAxisAlignedBB getRenderBoundingBoxRaw() {
        return RENDER_BOX;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74757_a("isPowered", this.isPowered);
        compound.func_74768_a("openCount", this.openCount);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.isPowered = compound.func_74767_n("isPowered");
        this.openCount = compound.func_74762_e("openCount");
        super.func_145839_a(compound);
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] getGateType(Context context, Arguments args) {
        return new Object[]{this.isMerged() ? "ORLIN" : null};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function() -- Tries to open the gate")
    public Object[] engageGate(Context context, Arguments args) {
        if (!this.isMerged()) {
            return new Object[]{null, "stargate_failure_not_merged", "Stargate is not merged"};
        }
        if (this.stargateState.idle()) {
            if (!this.isBroken()) {
                this.beginOpening();
                return new Object[]{null, "stargate_engage"};
            }
            return new Object[]{null, "stargate_failure_opening", "Stargate is broken"};
        }
        return new Object[]{null, "stargate_failure_busy", "Stargate is busy", this.stargateState.toString()};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function() -- Tries to close the gate")
    public Object[] disengageGate(Context context, Arguments args) {
        if (!this.isMerged()) {
            return new Object[]{null, "stargate_failure_not_merged", "Stargate is not merged"};
        }
        if (this.stargateState.engaged()) {
            if (this.getStargateState().initiating()) {
                this.attemptClose(StargateClosedReasonEnum.REQUESTED);
                return new Object[]{"stargate_disengage"};
            }
            return new Object[]{null, "stargate_failure_wrong_end", "Unable to close the gate on this end"};
        }
        return new Object[]{null, "stargate_failure_not_open", "The gate is closed"};
    }
}

