/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.util;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tauri.dev.jsg.block.JSGBlock;

public class BlockHelpers {
    public static boolean isBlockDirectlyUnderSky(IBlockAccess world, BlockPos pos) {
        while (pos.func_177956_o() < 255) {
            pos = pos.func_177984_a();
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (world.func_175623_d(pos) || block == Blocks.field_150362_t || block == Blocks.field_150361_u) continue;
            return false;
        }
        return true;
    }

    public static BlockPos getHighest(List<BlockPos> list) {
        int maxy = -1;
        BlockPos top = null;
        for (BlockPos pos : list) {
            if (pos.func_177956_o() <= maxy) continue;
            maxy = pos.func_177956_o();
            top = pos;
        }
        return top;
    }

    public static JSGBlock createSimpleBlock(String id, Material material, CreativeTabs tab) {
        JSGBlock block = new JSGBlock(material);
        block.setRegistryName("jsg", id);
        block.func_149663_c("jsg." + id);
        block.func_149647_a(tab);
        return block;
    }

    public static JSGBlock createSimpleBlock(String id, Material material, CreativeTabs tab, final Item itemDrop, final int quantity, final int quantityExtra, final int efficiencyCoefficient) {
        JSGBlock block = new JSGBlock(material){

            public void getDrops(NonNullList<ItemStack> drops, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int fortune) {
                Random random = world instanceof World ? ((World)world).field_73012_v : RANDOM;
                drops.add((Object)new ItemStack(itemDrop, quantity + random.nextInt(quantityExtra) + fortune * random.nextInt(efficiencyCoefficient)));
            }
        };
        block.setRegistryName("jsg", id);
        block.func_149663_c("jsg." + id);
        block.func_149647_a(tab);
        return block;
    }
}

