/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.worldgen.structures;

import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.block.JSGBlocks;
import tauri.dev.jsg.capability.CapabilityEnergyZPM;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.config.stargate.StargateSizeEnum;
import tauri.dev.jsg.fluid.JSGFluids;
import tauri.dev.jsg.item.JSGItems;
import tauri.dev.jsg.power.stargate.StargateClassicEnergyStorage;
import tauri.dev.jsg.power.zpm.IEnergyStorageZPM;
import tauri.dev.jsg.power.zpm.ZPMItemEnergyStorage;
import tauri.dev.jsg.stargate.network.StargateAddress;
import tauri.dev.jsg.stargate.network.StargatePos;
import tauri.dev.jsg.stargate.network.SymbolTypeEnum;
import tauri.dev.jsg.tileentity.dialhomedevice.DHDAbstractTile;
import tauri.dev.jsg.tileentity.stargate.StargateAbstractBaseTile;
import tauri.dev.jsg.tileentity.stargate.StargateClassicBaseTile;
import tauri.dev.jsg.tileentity.transportrings.TransportRingsAbstractTile;
import tauri.dev.jsg.util.FacingHelper;
import tauri.dev.jsg.util.LinkingHelper;
import tauri.dev.jsg.worldgen.structures.JSGStructuresGenerator;
import tauri.dev.jsg.worldgen.util.EnumGenerationHeight;
import tauri.dev.jsg.worldgen.util.GeneratedStargate;
import tauri.dev.jsg.worldgen.util.JSGWorldTopBlock;

public class JSGStructure
extends WorldGenerator {
    protected final PlacementSettings defaultSettings = new PlacementSettings().func_186226_b(false).func_186220_a(Rotation.NONE).func_186222_a(false);
    public String structureName;
    public int yNegativeOffset;
    public int dimensionToSpawn;
    boolean isStargateStructure;
    boolean isRingsStructure;
    SymbolTypeEnum symbolType;
    boolean findOptimalRotation;
    boolean isMilkyWayGate;
    boolean isPegasusGate;
    boolean isUniverseGate;
    public int structureSizeX;
    public int structureSizeZ;
    public int airUp;
    public final ITemplateProcessor templateProcessor;
    public final Rotation rotationToNorth;
    public double terrainFlatPercents;
    public double topBlockMatchPercent;
    public EnumGenerationHeight genHeight;

    public JSGStructure(String structureName, int yNegativeOffset, boolean isStargateStructure, boolean isRingsStructure, SymbolTypeEnum symbolType, int structureSizeX, int structureSizeZ, int airUp, int dimensionToSpawn, boolean findOptimalRotation, @Nullable ITemplateProcessor templateProcessor, Rotation rotationToNorth, double terrainFlatPercents, double topBlockMatchPercent, @Nonnull EnumGenerationHeight genHeight) {
        this.structureName = structureName + (isStargateStructure ? (JSGConfig.Stargate.stargateSize == StargateSizeEnum.LARGE ? "_large" : "_small") : "");
        this.yNegativeOffset = yNegativeOffset;
        this.isStargateStructure = isStargateStructure;
        this.isRingsStructure = isRingsStructure;
        this.symbolType = symbolType;
        this.structureSizeX = structureSizeX;
        this.structureSizeZ = structureSizeZ;
        this.dimensionToSpawn = dimensionToSpawn;
        this.findOptimalRotation = findOptimalRotation;
        this.templateProcessor = templateProcessor;
        this.rotationToNorth = rotationToNorth;
        this.terrainFlatPercents = terrainFlatPercents;
        this.topBlockMatchPercent = topBlockMatchPercent;
        this.genHeight = genHeight;
        this.airUp = airUp;
        this.isMilkyWayGate = symbolType == SymbolTypeEnum.MILKYWAY;
        this.isPegasusGate = symbolType == SymbolTypeEnum.PEGASUS;
        this.isUniverseGate = symbolType == SymbolTypeEnum.UNIVERSE;
    }

    public boolean func_180709_b(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull BlockPos position) {
        return true;
    }

    @Nullable
    public GeneratedStargate generateStructure(World executedInWorld, BlockPos pos, Random random, @Nullable WorldServer worldToSpawn) {
        return this.generateStructure(executedInWorld, pos, random, worldToSpawn, null);
    }

    public GeneratedStargate generateStructure(World executedInWorld, BlockPos pos, Random random, @Nullable WorldServer worldToSpawn, @Nullable Rotation rotationOverride) {
        pos = pos.func_177979_c(this.yNegativeOffset);
        MinecraftServer mcServer = executedInWorld.func_73046_m();
        JSG.info("Structure " + this.structureName + " generation started!");
        if (mcServer == null) {
            return null;
        }
        worldToSpawn = worldToSpawn == null ? mcServer.func_71218_a(this.dimensionToSpawn) : worldToSpawn;
        worldToSpawn.func_72863_F().func_186028_c(pos.func_177958_n() / 16, pos.func_177952_p() / 16);
        TemplateManager manager = worldToSpawn.func_184163_y();
        ResourceLocation resourceLocation = new ResourceLocation("jsg", this.structureName);
        Template template = manager.func_186237_a(mcServer, resourceLocation);
        IBlockState state = worldToSpawn.func_180495_p(pos);
        Biome biome = worldToSpawn.func_180494_b(pos);
        worldToSpawn.func_184138_a(pos, state, state, 3);
        EnumFacing facing = this.findOptimalRotation ? JSGStructuresGenerator.findOptimalRotation((World)worldToSpawn, pos) : EnumFacing.SOUTH;
        Rotation rotation = FacingHelper.getRotation(facing);
        rotation = rotation.func_185830_a(this.rotationToNorth);
        if (rotationOverride != null) {
            rotation = rotationOverride;
        }
        template.func_189960_a((World)worldToSpawn, pos, this.templateProcessor, this.defaultSettings.func_186220_a(rotation), 3);
        Map dataBlocks = template.func_186258_a(pos, this.defaultSettings);
        BlockPos gatePos = null;
        BlockPos dhdPos = null;
        StargateAbstractBaseTile gateTile = null;
        ArrayList<TransportRingsAbstractTile> ringsTiles = new ArrayList<TransportRingsAbstractTile>();
        boolean hasUpgrade = this.dimensionToSpawn != executedInWorld.field_73011_w.getDimension();
        JSG.info("Structure " + this.structureName + " generated at " + pos + " in world " + worldToSpawn);
        for (BlockPos dataPos : dataBlocks.keySet()) {
            String name;
            switch (name = (String)dataBlocks.get(dataPos)) {
                case "base": {
                    IEnergyStorage gateEnergy;
                    worldToSpawn.func_175698_g(dataPos);
                    gatePos = dataPos.func_177979_c(3);
                    gateTile = (StargateClassicBaseTile)worldToSpawn.func_175625_s(gatePos);
                    if (gateTile == null) break;
                    IItemHandler gateContainer = (IItemHandler)((StargateClassicBaseTile)gateTile).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                    if (!(gateContainer == null || this.isUniverseGate && JSGConfig.Stargate.power.universeCapacitors <= 0)) {
                        IEnergyStorage storage;
                        ItemStack capacitor = new ItemStack((Block)JSGBlocks.CAPACITOR_BLOCK);
                        if (this.isUniverseGate && (storage = (IEnergyStorage)capacitor.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
                            storage.receiveEnergy((int)((double)storage.getMaxEnergyStored() * 0.5), false);
                        }
                        gateContainer.insertItem(4, capacitor, false);
                        if (this.isMilkyWayGate) {
                            gateContainer.insertItem(0, new ItemStack(JSGItems.CRYSTAL_GLYPH_MILKYWAY), false);
                        }
                        if (this.isPegasusGate) {
                            gateContainer.insertItem(0, new ItemStack(JSGItems.CRYSTAL_GLYPH_PEGASUS), false);
                        }
                        if (this.isUniverseGate) {
                            gateContainer.insertItem(0, new ItemStack(JSGItems.CRYSTAL_GLYPH_UNIVERSE), false);
                        }
                        if (hasUpgrade) {
                            gateContainer.insertItem(1, new ItemStack(JSGItems.CRYSTAL_GLYPH_STARGATE), false);
                        }
                    }
                    if ((gateEnergy = (IEnergyStorage)((StargateClassicBaseTile)gateTile).getCapability(CapabilityEnergy.ENERGY, null)) != null) {
                        gateEnergy.receiveEnergy((int)((double)((StargateClassicEnergyStorage)gateEnergy).getMaxEnergyStoredInternally() * 0.75), false);
                    }
                    gateTile.getMergeHelper().updateMembersBasePos((IBlockAccess)worldToSpawn, gatePos, facing, EnumFacing.SOUTH);
                    break;
                }
                case "dhd": {
                    worldToSpawn.func_175656_a(dataPos, worldToSpawn.func_180495_p(dataPos.func_177974_f()));
                    dhdPos = dataPos.func_177977_b();
                    JSGWorldTopBlock topBlock = JSGWorldTopBlock.getTopBlock((World)worldToSpawn, dhdPos.func_177958_n(), dhdPos.func_177952_p(), 3, worldToSpawn.field_73011_w.getDimension());
                    if (topBlock != null && topBlock.y != dhdPos.func_177956_o() && Math.abs(topBlock.y - dhdPos.func_177956_o()) < 12) {
                        IBlockState dhd = worldToSpawn.func_180495_p(dhdPos);
                        worldToSpawn.func_180501_a(dhdPos, topBlock.topBlockState, 3);
                        dhdPos = new BlockPos(dhdPos.func_177958_n(), topBlock.y + 1, dhdPos.func_177952_p());
                        worldToSpawn.func_180501_a(dhdPos, dhd, 3);
                    }
                    if ((double)random.nextFloat() < JSGConfig.WorldGen.mystPage.despawnDhdChance) {
                        worldToSpawn.func_175698_g(dhdPos);
                        break;
                    }
                    DHDAbstractTile dhdTile = (DHDAbstractTile)worldToSpawn.func_175625_s(dhdPos);
                    if (dhdTile == null) break;
                    int fluid = JSGConfig.Stargate.power.stargateEnergyStorage / JSGConfig.DialHomeDevice.power.energyPerNaquadah;
                    ItemStack crystal = new ItemStack(this.isPegasusGate ? JSGItems.CRYSTAL_CONTROL_PEGASUS_DHD : JSGItems.CRYSTAL_CONTROL_MILKYWAY_DHD);
                    IItemHandler dhdContainer = (IItemHandler)dhdTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                    IFluidHandler dhdFluidTank = (IFluidHandler)dhdTile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
                    if (dhdContainer != null) {
                        dhdContainer.insertItem(0, crystal, false);
                        if (hasUpgrade) {
                            dhdContainer.insertItem(1, new ItemStack(JSGItems.CRYSTAL_GLYPH_DHD), false);
                        }
                    }
                    if (!(dhdFluidTank instanceof FluidTank)) break;
                    ((FluidTank)dhdFluidTank).fillInternal(new FluidStack((Fluid)JSGFluids.NAQUADAH_MOLTEN_REFINED, fluid), true);
                    break;
                }
                case "rings": 
                case "rings_top": {
                    TransportRingsAbstractTile ringsTile;
                    JSGWorldTopBlock trTopBlock;
                    boolean top = name.equals("rings_top");
                    worldToSpawn.func_175698_g(dataPos);
                    BlockPos ringsPos = dataPos.func_177979_c(2);
                    if (top && (trTopBlock = JSGWorldTopBlock.getTopBlock((World)worldToSpawn, ringsPos.func_177958_n(), ringsPos.func_177952_p(), 3, worldToSpawn.field_73011_w.getDimension())) != null && trTopBlock.y != ringsPos.func_177956_o() && Math.abs(trTopBlock.y - ringsPos.func_177956_o()) < 12) {
                        IBlockState bState = worldToSpawn.func_180495_p(ringsPos);
                        worldToSpawn.func_180501_a(ringsPos, trTopBlock.topBlockState, 3);
                        ringsPos = new BlockPos(ringsPos.func_177958_n(), trTopBlock.y - 1, ringsPos.func_177952_p());
                        worldToSpawn.func_180501_a(ringsPos, bState, 3);
                    }
                    if ((ringsTile = (TransportRingsAbstractTile)worldToSpawn.func_175625_s(ringsPos)) == null) break;
                    IEnergyStorage ringsEnergy = (IEnergyStorage)ringsTile.getCapability(CapabilityEnergy.ENERGY, null);
                    if (ringsEnergy != null) {
                        ringsEnergy.receiveEnergy((int)((double)((StargateClassicEnergyStorage)ringsEnergy).getMaxEnergyStoredInternally() * 0.75), false);
                    }
                    ringsTiles.add(ringsTile);
                    break;
                }
                case "structure": {
                    worldToSpawn.func_175698_g(dataPos);
                    worldToSpawn.func_175698_g(dataPos.func_177977_b());
                    break;
                }
                case "loot_ov": 
                case "loot_nether": 
                case "loot_zpm": 
                case "loot_end": 
                case "loot_obelisk": {
                    BlockPos lootPos = dataPos.func_177977_b();
                    JSGStructure.generateLoot((World)worldToSpawn, lootPos, random, name);
                    worldToSpawn.func_175698_g(dataPos);
                    break;
                }
            }
        }
        if (this.isStargateStructure && gateTile != null) {
            ResourceLocation biomePath;
            if (dhdPos != null) {
                LinkingHelper.updateLinkedGate((World)worldToSpawn, gatePos, dhdPos);
            }
            gateTile.refresh();
            gateTile.getMergeHelper().updateMembersMergeStatus((World)worldToSpawn, gateTile.func_174877_v(), gateTile.getFacing(), gateTile.getFacingVertical(), true);
            gateTile.func_70296_d();
            StargateAddress address = gateTile.getStargateAddress(this.symbolType);
            if (address != null && !gateTile.getNetwork().isStargateInNetwork(address)) {
                gateTile.getNetwork().addStargate(address, new StargatePos(worldToSpawn.field_73011_w.func_186058_p().func_186068_a(), gatePos, address));
            }
            return new GeneratedStargate(address, (biomePath = biome.getRegistryName()) == null ? null : biomePath.func_110623_a(), hasUpgrade, ((StargateClassicBaseTile)gateTile).getOriginId());
        }
        if (this.isRingsStructure && ringsTiles.size() > 0) {
            for (TransportRingsAbstractTile ringsTile : ringsTiles) {
                ringsTile.generateAddress(true);
                ringsTile.updateLinkStatus();
                ringsTile.updatePlatformStatus();
                ringsTile.updateRingsDistance();
                ringsTile.func_70296_d();
                ringsTile.setBarrierBlocks(false, false, true);
            }
        }
        return null;
    }

    private static void generateLoot(World world, BlockPos chestPos, Random random, String lootTableName) {
        TileEntity tile = world.func_175625_s(chestPos);
        if (tile instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)tile;
            chest.func_189404_a(new ResourceLocation("jsg", lootTableName), random.nextLong());
            if (lootTableName.equalsIgnoreCase("loot_obelisk")) {
                chest.func_184281_d(null);
                IItemHandler handler = chest.getSingleChestHandler();
                for (int i = 0; i < handler.getSlots(); ++i) {
                    IEnergyStorageZPM energyStorage;
                    ItemStack stack = handler.getStackInSlot(i);
                    if (stack.func_190926_b() || !((energyStorage = (IEnergyStorageZPM)stack.getCapability(CapabilityEnergyZPM.ENERGY, null)) instanceof ZPMItemEnergyStorage)) continue;
                    ZPMItemEnergyStorage energyCasted = (ZPMItemEnergyStorage)energyStorage;
                    energyCasted.setEnergyStored((long)((double)energyCasted.getMaxEnergyStored() * (Math.random() * (double)0.7f) + (double)0.1f));
                }
            }
        }
    }
}

