/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.adventure.nbt;

import java.util.ArrayList;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import me.lucko.luckperms.lib.adventure.nbt.BinaryTag;
import me.lucko.luckperms.lib.adventure.nbt.ByteArrayBinaryTag;
import me.lucko.luckperms.lib.adventure.nbt.ByteBinaryTag;
import me.lucko.luckperms.lib.adventure.nbt.CharBuffer;
import me.lucko.luckperms.lib.adventure.nbt.CompoundBinaryTag;
import me.lucko.luckperms.lib.adventure.nbt.DoubleBinaryTag;
import me.lucko.luckperms.lib.adventure.nbt.FloatBinaryTag;
import me.lucko.luckperms.lib.adventure.nbt.IntArrayBinaryTag;
import me.lucko.luckperms.lib.adventure.nbt.IntBinaryTag;
import me.lucko.luckperms.lib.adventure.nbt.ListBinaryTag;
import me.lucko.luckperms.lib.adventure.nbt.LongArrayBinaryTag;
import me.lucko.luckperms.lib.adventure.nbt.LongBinaryTag;
import me.lucko.luckperms.lib.adventure.nbt.NumberBinaryTag;
import me.lucko.luckperms.lib.adventure.nbt.ShortBinaryTag;
import me.lucko.luckperms.lib.adventure.nbt.StringBinaryTag;
import me.lucko.luckperms.lib.adventure.nbt.StringTagParseException;
import me.lucko.luckperms.lib.adventure.nbt.Tokens;

final class TagStringReader {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private final CharBuffer buffer;
    private boolean acceptLegacy;

    TagStringReader(CharBuffer buffer) {
        this.buffer = buffer;
    }

    public CompoundBinaryTag compound() throws StringTagParseException {
        this.buffer.expect('{');
        if (this.buffer.takeIf('}')) {
            return CompoundBinaryTag.empty();
        }
        CompoundBinaryTag.Builder builder = CompoundBinaryTag.builder();
        while (this.buffer.hasMore()) {
            builder.put(this.key(), this.tag());
            if (!this.separatorOrCompleteWith('}')) continue;
            return builder.build();
        }
        throw this.buffer.makeError("Unterminated compound tag!");
    }

    public ListBinaryTag list() throws StringTagParseException {
        boolean prefixedIndex;
        ListBinaryTag.Builder<BinaryTag> builder = ListBinaryTag.builder();
        this.buffer.expect('[');
        boolean bl = prefixedIndex = this.acceptLegacy && this.buffer.peek() == '0' && this.buffer.peek(1) == ':';
        if (!prefixedIndex && this.buffer.takeIf(']')) {
            return ListBinaryTag.empty();
        }
        while (this.buffer.hasMore()) {
            if (prefixedIndex) {
                this.buffer.takeUntil(':');
            }
            BinaryTag next = this.tag();
            builder.add(next);
            if (!this.separatorOrCompleteWith(']')) continue;
            return builder.build();
        }
        throw this.buffer.makeError("Reached end of file without end of list tag!");
    }

    public BinaryTag array(char elementType) throws StringTagParseException {
        this.buffer.expect('[').expect(elementType).expect(';');
        elementType = Character.toLowerCase(elementType);
        if (elementType == 'b') {
            return ByteArrayBinaryTag.of(this.byteArray());
        }
        if (elementType == 'i') {
            return IntArrayBinaryTag.of(this.intArray());
        }
        if (elementType == 'l') {
            return LongArrayBinaryTag.of(this.longArray());
        }
        throw this.buffer.makeError("Type " + elementType + " is not a valid element type in an array!");
    }

    private byte[] byteArray() throws StringTagParseException {
        if (this.buffer.takeIf(']')) {
            return EMPTY_BYTE_ARRAY;
        }
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        while (this.buffer.hasMore()) {
            CharSequence value = this.buffer.skipWhitespace().takeUntil('b');
            try {
                bytes.add(Byte.valueOf(value.toString()));
            }
            catch (NumberFormatException ex) {
                throw this.buffer.makeError("All elements of a byte array must be bytes!");
            }
            if (!this.separatorOrCompleteWith(']')) continue;
            byte[] result = new byte[bytes.size()];
            for (int i = 0; i < bytes.size(); ++i) {
                result[i] = (Byte)bytes.get(i);
            }
            return result;
        }
        throw this.buffer.makeError("Reached end of document without array close");
    }

    private int[] intArray() throws StringTagParseException {
        if (this.buffer.takeIf(']')) {
            return EMPTY_INT_ARRAY;
        }
        IntStream.Builder builder = IntStream.builder();
        while (this.buffer.hasMore()) {
            BinaryTag value = this.tag();
            if (!(value instanceof IntBinaryTag)) {
                throw this.buffer.makeError("All elements of an int array must be ints!");
            }
            builder.add(((IntBinaryTag)value).intValue());
            if (!this.separatorOrCompleteWith(']')) continue;
            return builder.build().toArray();
        }
        throw this.buffer.makeError("Reached end of document without array close");
    }

    private long[] longArray() throws StringTagParseException {
        if (this.buffer.takeIf(']')) {
            return EMPTY_LONG_ARRAY;
        }
        LongStream.Builder longs = LongStream.builder();
        while (this.buffer.hasMore()) {
            CharSequence value = this.buffer.skipWhitespace().takeUntil('l');
            try {
                longs.add(Long.parseLong(value.toString()));
            }
            catch (NumberFormatException ex) {
                throw this.buffer.makeError("All elements of a long array must be longs!");
            }
            if (!this.separatorOrCompleteWith(']')) continue;
            return longs.build().toArray();
        }
        throw this.buffer.makeError("Reached end of document without array close");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String key() throws StringTagParseException {
        this.buffer.skipWhitespace();
        char starChar = this.buffer.peek();
        try {
            if (starChar == '\'' || starChar == '\"') {
                String string = TagStringReader.unescape(this.buffer.takeUntil(this.buffer.take()).toString());
                return string;
            }
            StringBuilder builder = new StringBuilder();
            while (this.buffer.hasMore()) {
                char peek = this.buffer.peek();
                if (!Tokens.id(peek)) {
                    if (!this.acceptLegacy) break;
                    if (peek == '\\') {
                        this.buffer.take();
                        continue;
                    }
                    if (peek == ':') break;
                    builder.append(this.buffer.take());
                    continue;
                }
                builder.append(this.buffer.take());
            }
            String string = builder.toString();
            return string;
        }
        finally {
            this.buffer.expect(':');
        }
    }

    public BinaryTag tag() throws StringTagParseException {
        char startToken = this.buffer.skipWhitespace().peek();
        switch (startToken) {
            case '{': {
                return this.compound();
            }
            case '[': {
                if (this.buffer.hasMore(2) && this.buffer.peek(2) == ';') {
                    return this.array(this.buffer.peek(1));
                }
                return this.list();
            }
            case '\"': 
            case '\'': {
                this.buffer.advance();
                return StringBinaryTag.of(TagStringReader.unescape(this.buffer.takeUntil(startToken).toString()));
            }
        }
        return this.scalar();
    }

    private BinaryTag scalar() {
        StringBuilder builder = new StringBuilder();
        boolean possiblyNumeric = true;
        while (this.buffer.hasMore()) {
            char current = this.buffer.peek();
            if (possiblyNumeric && !Tokens.numeric(current) && builder.length() != 0) {
                NumberBinaryTag result = null;
                try {
                    switch (Character.toLowerCase(current)) {
                        case 'b': {
                            result = ByteBinaryTag.of(Byte.parseByte(builder.toString()));
                            break;
                        }
                        case 's': {
                            result = ShortBinaryTag.of(Short.parseShort(builder.toString()));
                            break;
                        }
                        case 'l': {
                            result = LongBinaryTag.of(Long.parseLong(builder.toString()));
                            break;
                        }
                        case 'f': {
                            result = FloatBinaryTag.of(Float.parseFloat(builder.toString()));
                            break;
                        }
                        case 'd': {
                            result = DoubleBinaryTag.of(Double.parseDouble(builder.toString()));
                        }
                    }
                }
                catch (NumberFormatException ex) {
                    possiblyNumeric = false;
                }
                if (result != null) {
                    this.buffer.take();
                    return result;
                }
            }
            if (current == '\\') {
                this.buffer.advance();
                builder.append(this.buffer.take());
                continue;
            }
            if (!Tokens.id(current)) break;
            builder.append(this.buffer.take());
        }
        String built = builder.toString();
        if (possiblyNumeric) {
            try {
                return IntBinaryTag.of(Integer.parseInt(built));
            }
            catch (NumberFormatException ex) {
                try {
                    return DoubleBinaryTag.of(Double.parseDouble(built));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (built.equalsIgnoreCase("true")) {
            return ByteBinaryTag.ONE;
        }
        if (built.equalsIgnoreCase("false")) {
            return ByteBinaryTag.ZERO;
        }
        return StringBinaryTag.of(built);
    }

    private boolean separatorOrCompleteWith(char endCharacter) throws StringTagParseException {
        if (this.buffer.takeIf(endCharacter)) {
            return true;
        }
        this.buffer.expect(',');
        return false;
    }

    private static String unescape(String withEscapes) {
        int escapeIdx = withEscapes.indexOf(92);
        if (escapeIdx == -1) {
            return withEscapes;
        }
        int lastEscape = 0;
        StringBuilder output = new StringBuilder(withEscapes.length());
        do {
            output.append(withEscapes, lastEscape, escapeIdx);
        } while ((escapeIdx = withEscapes.indexOf(92, (lastEscape = escapeIdx + 1) + 1)) != -1);
        output.append(withEscapes.substring(lastEscape));
        return output.toString();
    }

    public void legacy(boolean acceptLegacy) {
        this.acceptLegacy = acceptLegacy;
    }
}

