/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei.gas;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.common.util.LangUtils;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class GasStackRenderer
implements IIngredientRenderer<GasStack> {
    private static final int TEX_WIDTH = 16;
    private static final int TEX_HEIGHT = 16;
    private static final int MIN_FLUID_HEIGHT = 1;
    private final int capacityMb;
    private final TooltipMode tooltipMode;
    private final int width;
    private final int height;
    @Nullable
    private final IDrawable overlay;

    public GasStackRenderer() {
        this(1000, TooltipMode.ITEM_LIST, 16, 16, null);
    }

    public GasStackRenderer(int capacityMb, boolean showCapacity, int width, int height, @Nullable IDrawable overlay) {
        this(capacityMb, showCapacity ? TooltipMode.SHOW_AMOUNT_AND_CAPACITY : TooltipMode.SHOW_AMOUNT, width, height, overlay);
    }

    public GasStackRenderer(int capacityMb, TooltipMode tooltipMode, int width, int height, @Nullable IDrawable overlay) {
        this.capacityMb = capacityMb;
        this.tooltipMode = tooltipMode;
        this.width = width;
        this.height = height;
        this.overlay = overlay;
    }

    private static TextureAtlasSprite getStillGasSprite(Minecraft minecraft, Gas gas) {
        TextureMap textureMapBlocks = minecraft.func_147117_R();
        ResourceLocation gasStill = gas.getIcon();
        TextureAtlasSprite gasStillSprite = null;
        if (gasStill != null) {
            gasStillSprite = textureMapBlocks.getTextureExtry(gasStill.toString());
        }
        if (gasStillSprite == null) {
            gasStillSprite = textureMapBlocks.func_174944_f();
        }
        return gasStillSprite;
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)1.0f);
    }

    private static void drawTextureWithMasking(double xCoord, double yCoord, TextureAtlasSprite textureSprite, int maskTop, int maskRight, double zLevel) {
        double uMin = textureSprite.func_94209_e();
        double uMax = textureSprite.func_94212_f();
        double vMin = textureSprite.func_94206_g();
        double vMax = textureSprite.func_94210_h();
        uMax -= (double)maskRight / 16.0 * (uMax - uMin);
        vMax -= (double)maskTop / 16.0 * (vMax - vMin);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_181662_b(xCoord, yCoord + 16.0, zLevel).func_187315_a(uMin, vMax).func_181675_d();
        vertexBuffer.func_181662_b(xCoord + 16.0 - (double)maskRight, yCoord + 16.0, zLevel).func_187315_a(uMax, vMax).func_181675_d();
        vertexBuffer.func_181662_b(xCoord + 16.0 - (double)maskRight, yCoord + (double)maskTop, zLevel).func_187315_a(uMax, vMin).func_181675_d();
        vertexBuffer.func_181662_b(xCoord, yCoord + (double)maskTop, zLevel).func_187315_a(uMin, vMin).func_181675_d();
        tessellator.func_78381_a();
    }

    public void render(Minecraft minecraft, int xPosition, int yPosition, @Nullable GasStack gasStack) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        this.drawGas(minecraft, xPosition, yPosition, gasStack);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.overlay != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)200.0f);
            this.overlay.draw(minecraft, xPosition, yPosition);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
    }

    private void drawGas(Minecraft minecraft, int xPosition, int yPosition, @Nullable GasStack gasStack) {
        Gas gas;
        Gas gas2 = gas = gasStack == null ? null : gasStack.getGas();
        if (gas == null) {
            return;
        }
        int scaledAmount = gasStack.amount * this.height / this.capacityMb;
        if (gasStack.amount > 0 && scaledAmount < 1) {
            scaledAmount = 1;
        }
        if (scaledAmount > this.height) {
            scaledAmount = this.height;
        }
        this.drawTiledSprite(minecraft, xPosition, yPosition, this.width, this.height, gas.getTint(), scaledAmount, GasStackRenderer.getStillGasSprite(minecraft, gas));
    }

    private void drawTiledSprite(Minecraft minecraft, int xPosition, int yPosition, int tiledWidth, int tiledHeight, int color, int scaledAmount, TextureAtlasSprite sprite) {
        minecraft.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GasStackRenderer.setGLColorFromInt(color);
        int xTileCount = tiledWidth / 16;
        int xRemainder = tiledWidth - xTileCount * 16;
        int yTileCount = scaledAmount / 16;
        int yRemainder = scaledAmount - yTileCount * 16;
        int yStart = yPosition + tiledHeight;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            int width;
            int n = width = xTile == xTileCount ? xRemainder : 16;
            if (width <= 0) continue;
            int x = xPosition + xTile * 16;
            int maskRight = 16 - width;
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int height;
                int n2 = height = yTile == yTileCount ? yRemainder : 16;
                if (height <= 0) continue;
                int y = yStart - (yTile + 1) * 16;
                int maskTop = 16 - height;
                GasStackRenderer.drawTextureWithMasking(x, y, sprite, maskTop, maskRight, 100.0);
            }
        }
    }

    public List<String> getTooltip(Minecraft minecraft, GasStack gasStack, ITooltipFlag tooltipFlag) {
        ArrayList<String> tooltip = new ArrayList<String>();
        Gas gasType = gasStack.getGas();
        if (gasType == null) {
            return tooltip;
        }
        String gasName = gasType.getLocalizedName();
        tooltip.add(gasName);
        if (this.tooltipMode == TooltipMode.SHOW_AMOUNT_AND_CAPACITY) {
            String amount = LangUtils.localizeWithFormat("jei.tooltip.liquid.amount.with.capacity", gasStack.amount, this.capacityMb);
            tooltip.add(TextFormatting.GRAY + amount);
        } else if (this.tooltipMode == TooltipMode.SHOW_AMOUNT) {
            String amount = LangUtils.localizeWithFormat("jei.tooltip.liquid.amount", gasStack.amount);
            tooltip.add(TextFormatting.GRAY + amount);
        }
        return tooltip;
    }

    public FontRenderer getFontRenderer(Minecraft minecraft, GasStack gasStack) {
        return minecraft.field_71466_p;
    }

    static enum TooltipMode {
        SHOW_AMOUNT,
        SHOW_AMOUNT_AND_CAPACITY,
        ITEM_LIST;

    }
}

