/*
 * Decompiled with CFR 0.152.
 */
package elucent.simplytea;

import elucent.simplytea.block.BlockTeaFence;
import elucent.simplytea.block.BlockTeaFenceGate;
import elucent.simplytea.block.BlockTeaSapling;
import elucent.simplytea.block.BlockTeaTrunk;
import elucent.simplytea.block.IItemBlock;
import elucent.simplytea.core.Config;
import elucent.simplytea.core.IMCHelper;
import elucent.simplytea.core.IModeledObject;
import elucent.simplytea.core.Util;
import elucent.simplytea.core.WorldGenTeaTrees;
import elucent.simplytea.item.ItemBase;
import elucent.simplytea.item.ItemCocoa;
import elucent.simplytea.item.ItemHotTeapot;
import elucent.simplytea.item.ItemTeaCup;
import elucent.simplytea.item.ItemTeaStick;
import elucent.simplytea.item.ItemTeapot;
import elucent.simplytea.item.ItemTooltip;
import elucent.simplytea.potion.PotionCaffeinated;
import elucent.simplytea.potion.PotionEnderfalling;
import elucent.simplytea.potion.PotionRestful;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChorusFlower;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="simplytea", version="1.6", name="Simply Tea!", acceptedMinecraftVersions="[1.12.2]")
public class SimplyTea {
    public static final String MODID = "simplytea";
    public static final String NAME = "Simply Tea!";
    public static final String VERSION = "1.6";
    public static CreativeTabs tab = new CreativeTabs("simplytea"){

        public ItemStack func_78016_d() {
            return new ItemStack(leaf_tea);
        }
    };
    private static List<Item> items = new ArrayList<Item>();
    private static List<Block> blocks = new ArrayList<Block>();
    public static Block tea_sapling;
    public static Block tea_trunk;
    public static Block tea_fence;
    public static Block tea_fence_gate;
    public static Item leaf_tea;
    public static Item black_tea;
    public static Item tea_stick;
    public static Item chorus_petal;
    public static Item teabag;
    public static Item teabag_green;
    public static Item teabag_black;
    public static Item teabag_floral;
    public static Item teabag_chorus;
    public static Item teabag_chamomile;
    public static Item cup;
    public static Item cup_tea_black;
    public static Item cup_tea_green;
    public static Item cup_tea_floral;
    public static Item cup_tea_chai;
    public static Item cup_tea_chorus;
    public static Item cup_tea_chamomile;
    public static Item cup_cocoa;
    public static Item teapot;
    public static Item hot_teapot;
    public static Item frothed_teapot;
    public static Potion restful;
    public static Potion caffeinated;
    public static Potion enderfalling;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        caffeinated = new PotionCaffeinated("caffeinated").setCustomIcon(1, 0);
        restful = new PotionRestful("restful").setCustomIcon(0, 0);
        enderfalling = new PotionEnderfalling("enderfalling").setCustomIcon(2, 0);
        leaf_tea = new ItemTooltip("leaf_tea");
        items.add(leaf_tea);
        black_tea = new ItemTooltip("black_tea");
        items.add(black_tea);
        tea_stick = new ItemTeaStick("tea_stick");
        items.add(tea_stick);
        chorus_petal = new ItemTooltip("chorus_petal");
        items.add(chorus_petal);
        teabag = new ItemBase("teabag", true);
        items.add(teabag);
        teabag_green = new ItemBase("teabag_green", true);
        items.add(teabag_green);
        teabag_black = new ItemBase("teabag_black", true);
        items.add(teabag_black);
        teabag_floral = new ItemBase("teabag_floral", true);
        items.add(teabag_floral);
        teabag_chorus = new ItemBase("teabag_chorus", true);
        items.add(teabag_chorus);
        cup = new ItemBase("cup", true).func_77625_d(16);
        items.add(cup);
        cup_tea_black = new ItemTeaCup("cup_tea_black", Config.tea.black, 1);
        items.add(cup_tea_black);
        cup_tea_green = new ItemTeaCup("cup_tea_green", Config.tea.green, 1);
        items.add(cup_tea_green);
        cup_tea_floral = new ItemTeaCup("cup_tea_floral", Config.tea.floral, 20);
        items.add(cup_tea_floral);
        cup_tea_chai = new ItemTeaCup("cup_tea_chai", Config.tea.chai, 2);
        items.add(cup_tea_chai);
        cup_tea_chorus = new ItemTeaCup("cup_tea_chorus", Config.tea.chorus);
        items.add(cup_tea_chorus);
        cup_cocoa = new ItemCocoa("cup_cocoa");
        items.add(cup_cocoa);
        teapot = new ItemTeapot("teapot");
        items.add(teapot);
        hot_teapot = new ItemHotTeapot("hot_teapot");
        items.add(hot_teapot);
        frothed_teapot = new ItemHotTeapot("frothed_teapot");
        items.add(frothed_teapot);
        if (Loader.isModLoaded((String)"rustic")) {
            teabag_chamomile = new ItemBase("teabag_chamomile", true);
            items.add(teabag_chamomile);
            cup_tea_chamomile = new ItemTeaCup("cup_tea_chamomile", Config.tea.chamomile, 30);
            items.add(cup_tea_chamomile);
        }
        tea_sapling = new BlockTeaSapling("tea_sapling");
        blocks.add(tea_sapling);
        tea_trunk = new BlockTeaTrunk("tea_trunk");
        blocks.add(tea_trunk);
        tea_fence = new BlockTeaFence("tea_fence");
        blocks.add(tea_fence);
        tea_fence_gate = new BlockTeaFenceGate("tea_fence_gate");
        blocks.add(tea_fence_gate);
        if (Config.tree.enable_generation) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenTeaTrees(), (int)100);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Config.parse();
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MODID)) {
            ConfigManager.sync((String)MODID, (Config.Type)Config.Type.INSTANCE);
            Config.parse();
        }
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        for (Block b : blocks) {
            event.getRegistry().register((IForgeRegistryEntry)b);
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        for (Item i : items) {
            event.getRegistry().register((IForgeRegistryEntry)i);
        }
        for (Block b : blocks) {
            if (!(b instanceof IItemBlock)) continue;
            event.getRegistry().register((IForgeRegistryEntry)((IItemBlock)b).getItemBlock());
        }
    }

    @SubscribeEvent
    public void registerPotions(RegistryEvent.Register<Potion> event) {
        IForgeRegistry r = event.getRegistry();
        r.register((IForgeRegistryEntry)caffeinated);
        r.register((IForgeRegistryEntry)restful);
        r.register((IForgeRegistryEntry)enderfalling);
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        GameRegistry.addSmelting((ItemStack)new ItemStack(teapot, 1, 1), (ItemStack)new ItemStack(hot_teapot, 1, 4), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(teapot, 1, 2), (ItemStack)new ItemStack(frothed_teapot, 1, 4), (float)0.1f);
        GameRegistry.addSmelting((Item)leaf_tea, (ItemStack)new ItemStack(black_tea, 1), (float)0.1f);
        if (Loader.isModLoaded((String)"tconstruct")) {
            IMCHelper.addTinkersDrying(new ItemStack(leaf_tea), new ItemStack(black_tea), 300);
        }
        OreDictionary.registerOre((String)"treeSapling", (Block)tea_sapling);
        OreDictionary.registerOre((String)"stickWood", (Item)tea_stick);
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        for (Item i : items) {
            if (!(i instanceof IModeledObject)) continue;
            ((IModeledObject)i).initModel();
        }
        for (Block b : blocks) {
            if (!(b instanceof IModeledObject)) continue;
            ((IModeledObject)b).initModel();
        }
    }

    @SubscribeEvent
    public void playerWakeUp(PlayerWakeUpEvent event) {
        if (!event.shouldSetSpawn() || event.updateWorld()) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (player.func_70644_a(caffeinated)) {
            player.func_184589_d(caffeinated);
            player.func_184589_d(restful);
            return;
        }
        PotionEffect effect = player.func_70660_b(restful);
        if (effect != null) {
            player.func_70691_i((float)((effect.func_76458_c() + 1) * 2));
            player.func_184589_d(restful);
        }
    }

    @SubscribeEvent
    public void entityFall(LivingFallEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.func_70644_a(enderfalling)) {
            PotionEffect effect = entity.func_70660_b(enderfalling);
            event.setDamageMultiplier(event.getDamageMultiplier() * (float)Math.pow(2.0, -effect.func_76458_c() - 3));
        }
    }

    @SubscribeEvent
    public void throwEnderPearl(EnderTeleportEvent event) {
        if (event.getEntityLiving().func_70644_a(enderfalling)) {
            event.setAttackDamage(0.0f);
        }
    }

    @SubscribeEvent
    public void breakChorusFlower(BlockEvent.HarvestDropsEvent event) {
        Block block = event.getState().func_177230_c();
        if (block != Blocks.field_185766_cS || event.getHarvester() != null) {
            return;
        }
        if (!(block instanceof BlockChorusFlower) || ((BlockChorusFlower)block).func_185606_b(event.getWorld(), event.getPos())) {
            return;
        }
        event.getDrops().add(new ItemStack(chorus_petal, Util.randomCount(event.getWorld().field_73012_v, Config.tree.max_petals)));
    }
}

