/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.api.multiblock;

import it.zerono.mods.zerocore.api.multiblock.IMultiblockPart;
import it.zerono.mods.zerocore.api.multiblock.IMultiblockRegistry;
import it.zerono.mods.zerocore.api.multiblock.validation.IMultiblockValidator;
import it.zerono.mods.zerocore.api.multiblock.validation.ValidationError;
import it.zerono.mods.zerocore.internal.ZeroCore;
import it.zerono.mods.zerocore.lib.block.ModTileEntity;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;

public abstract class MultiblockControllerBase
implements IMultiblockValidator {
    public static final short DIMENSION_UNBOUNDED = -1;
    public final World WORLD;
    protected AssemblyState assemblyState;
    protected HashSet<IMultiblockPart> connectedParts;
    private BlockPos referenceCoord;
    private BlockPos minimumCoord;
    private BlockPos maximumCoord;
    private boolean shouldCheckForDisconnections;
    private ValidationError lastValidationError;
    protected boolean debugMode;
    private static final IMultiblockRegistry REGISTRY = ZeroCore.getProxy().initMultiblockRegistry();

    protected MultiblockControllerBase(World world) {
        this.WORLD = world;
        this.connectedParts = new HashSet();
        this.referenceCoord = null;
        this.assemblyState = AssemblyState.Disassembled;
        this.minimumCoord = null;
        this.maximumCoord = null;
        this.shouldCheckForDisconnections = true;
        this.lastValidationError = null;
        this.debugMode = false;
    }

    public void setDebugMode(boolean active) {
        this.debugMode = active;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public abstract void onAttachedPartWithMultiblockData(IMultiblockPart var1, NBTTagCompound var2);

    public boolean hasBlock(BlockPos blockCoord) {
        return this.connectedParts.contains(blockCoord);
    }

    public void attachBlock(IMultiblockPart part) {
        int newZ;
        int newY;
        int newX;
        int partCoord;
        int curZ;
        int curY;
        int curX;
        BlockPos coord = part.getWorldPosition();
        if (!this.connectedParts.add(part)) {
            ZeroCore.getLogger().warn("[%s] Controller %s is double-adding part %d @ %s. This is unusual. If you encounter odd behavior, please tear down the machine and rebuild it.", (Object)(this.WORLD.field_72995_K ? "CLIENT" : "SERVER"), (Object)this.hashCode(), (Object)part.hashCode(), (Object)coord);
        }
        part.onAttached(this);
        this.onBlockAdded(part);
        if (part.hasMultiblockSaveData()) {
            NBTTagCompound savedData = part.getMultiblockSaveData();
            this.onAttachedPartWithMultiblockData(part, savedData);
            part.onMultiblockDataAssimilated();
        }
        if (this.referenceCoord == null) {
            this.referenceCoord = coord;
            part.becomeMultiblockSaveDelegate();
        } else if (coord.compareTo((Vec3i)this.referenceCoord) < 0) {
            TileEntity te = this.getTile();
            if (null != te) {
                ((IMultiblockPart)te).forfeitMultiblockSaveDelegate();
            }
            this.referenceCoord = coord;
            part.becomeMultiblockSaveDelegate();
        } else {
            part.forfeitMultiblockSaveDelegate();
        }
        BlockPos partPos = part.getWorldPosition();
        if (this.minimumCoord != null) {
            curX = this.minimumCoord.func_177958_n();
            curY = this.minimumCoord.func_177956_o();
            curZ = this.minimumCoord.func_177952_p();
            partCoord = partPos.func_177958_n();
            newX = partCoord < curX ? partCoord : curX;
            partCoord = partPos.func_177956_o();
            newY = partCoord < curY ? partCoord : curY;
            partCoord = partPos.func_177952_p();
            int n = newZ = partCoord < curZ ? partCoord : curZ;
            if (newX != curX || newY != curY || newZ != curZ) {
                this.minimumCoord = new BlockPos(newX, newY, newZ);
            }
        }
        if (this.maximumCoord != null) {
            curX = this.maximumCoord.func_177958_n();
            curY = this.maximumCoord.func_177956_o();
            curZ = this.maximumCoord.func_177952_p();
            partCoord = partPos.func_177958_n();
            newX = partCoord > curX ? partCoord : curX;
            partCoord = partPos.func_177956_o();
            newY = partCoord > curY ? partCoord : curY;
            partCoord = partPos.func_177952_p();
            int n = newZ = partCoord > curZ ? partCoord : curZ;
            if (newX != curX || newY != curY || newZ != curZ) {
                this.maximumCoord = new BlockPos(newX, newY, newZ);
            }
        }
        REGISTRY.addDirtyController(this.WORLD, this);
    }

    protected abstract void onBlockAdded(IMultiblockPart var1);

    protected abstract void onBlockRemoved(IMultiblockPart var1);

    protected abstract void onMachineAssembled();

    protected abstract void onMachineRestored();

    protected abstract void onMachinePaused();

    protected abstract void onMachineDisassembled();

    private void onDetachBlock(IMultiblockPart part) {
        part.onDetached(this);
        this.onBlockRemoved(part);
        part.forfeitMultiblockSaveDelegate();
        this.maximumCoord = null;
        this.minimumCoord = null;
        if (this.referenceCoord != null && this.referenceCoord.equals((Object)part.getWorldPosition())) {
            this.referenceCoord = null;
        }
        this.shouldCheckForDisconnections = true;
    }

    public void detachBlock(IMultiblockPart part, boolean chunkUnloading) {
        if (chunkUnloading && this.assemblyState == AssemblyState.Assembled) {
            this.assemblyState = AssemblyState.Paused;
            this.onMachinePaused();
        }
        this.onDetachBlock(part);
        if (!this.connectedParts.remove(part)) {
            BlockPos position = part.getWorldPosition();
            ZeroCore.getLogger().warn("[%s] Double-removing part (%d) @ %d, %d, %d, this is unexpected and may cause problems. If you encounter anomalies, please tear down the reactor and rebuild it.", (Object)(this.WORLD.field_72995_K ? "CLIENT" : "SERVER"), (Object)part.hashCode(), (Object)position.func_177958_n(), (Object)position.func_177956_o(), (Object)position.func_177952_p());
        }
        if (this.connectedParts.isEmpty()) {
            REGISTRY.addDeadController(this.WORLD, this);
            return;
        }
        REGISTRY.addDirtyController(this.WORLD, this);
        if (this.referenceCoord == null) {
            this.selectNewReferenceCoord();
        }
    }

    protected abstract int getMinimumNumberOfBlocksForAssembledMachine();

    protected abstract int getMaximumXSize();

    protected abstract int getMaximumZSize();

    protected abstract int getMaximumYSize();

    protected int getMinimumXSize() {
        return 1;
    }

    protected int getMinimumYSize() {
        return 1;
    }

    protected int getMinimumZSize() {
        return 1;
    }

    @Override
    public ValidationError getLastError() {
        return this.lastValidationError;
    }

    @Override
    public void setLastError(ValidationError error) {
        if (null == error) {
            throw new IllegalArgumentException("The validation error can't be null");
        }
        this.lastValidationError = error;
    }

    @Override
    public void setLastError(String messageFormatStringResourceKey, Object ... messageParameters) {
        this.lastValidationError = new ValidationError(messageFormatStringResourceKey, messageParameters);
    }

    protected abstract boolean isMachineWhole(IMultiblockValidator var1);

    public void checkIfMachineIsWhole() {
        AssemblyState oldState = this.assemblyState;
        this.lastValidationError = null;
        if (this.isMachineWhole(this)) {
            this.assembleMachine(oldState);
        } else if (oldState == AssemblyState.Assembled) {
            this.disassembleMachine();
        }
    }

    private void assembleMachine(AssemblyState oldState) {
        for (IMultiblockPart part : this.connectedParts) {
            part.onPreMachineAssembled(this);
            part.onMachineAssembled(this);
        }
        this.assemblyState = AssemblyState.Assembled;
        if (oldState == AssemblyState.Paused) {
            this.onMachineRestored();
        } else {
            this.onMachineAssembled();
        }
        for (IMultiblockPart part : this.connectedParts) {
            part.onPostMachineAssembled(this);
        }
    }

    private void disassembleMachine() {
        for (IMultiblockPart part : this.connectedParts) {
            part.onPreMachineBroken();
            part.onMachineBroken();
        }
        this.assemblyState = AssemblyState.Disassembled;
        this.onMachineDisassembled();
        for (IMultiblockPart part : this.connectedParts) {
            part.onPostMachineBroken();
        }
    }

    public void assimilate(MultiblockControllerBase other) {
        BlockPos otherReferenceCoord = other.getReferenceCoord();
        if (otherReferenceCoord != null && this.getReferenceCoord().compareTo((Vec3i)otherReferenceCoord) >= 0) {
            throw new IllegalArgumentException("The controller with the lowest minimum-coord value must consume the one with the higher coords");
        }
        HashSet<IMultiblockPart> partsToAcquire = new HashSet<IMultiblockPart>(other.connectedParts);
        other._onAssimilated(this);
        for (IMultiblockPart acquiredPart : partsToAcquire) {
            if (acquiredPart.isPartInvalid()) continue;
            this.connectedParts.add(acquiredPart);
            acquiredPart.onAssimilated(this);
            this.onBlockAdded(acquiredPart);
        }
        this.onAssimilate(other);
        other.onAssimilated(this);
    }

    private void _onAssimilated(MultiblockControllerBase otherController) {
        if (this.referenceCoord != null) {
            TileEntity te;
            if (this.WORLD.func_175667_e(this.referenceCoord) && (te = this.getTile()) instanceof IMultiblockPart) {
                ((IMultiblockPart)te).forfeitMultiblockSaveDelegate();
            }
            this.referenceCoord = null;
        }
        this.connectedParts.clear();
    }

    protected abstract void onAssimilate(MultiblockControllerBase var1);

    protected abstract void onAssimilated(MultiblockControllerBase var1);

    public final void updateMultiblockEntity() {
        if (this.connectedParts.isEmpty()) {
            REGISTRY.addDeadController(this.WORLD, this);
            return;
        }
        if (this.assemblyState != AssemblyState.Assembled) {
            return;
        }
        if (this.WORLD.field_72995_K) {
            this.updateClient();
        } else if (this.updateServer() && this.minimumCoord != null && this.maximumCoord != null && this.WORLD.func_175707_a(this.minimumCoord, this.maximumCoord)) {
            int minChunkX = WorldHelper.getChunkXFromBlock(this.minimumCoord);
            int minChunkZ = WorldHelper.getChunkZFromBlock(this.minimumCoord);
            int maxChunkX = WorldHelper.getChunkXFromBlock(this.maximumCoord);
            int maxChunkZ = WorldHelper.getChunkZFromBlock(this.maximumCoord);
            for (int x = minChunkX; x <= maxChunkX; ++x) {
                for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                    Chunk chunkToSave = this.WORLD.func_72964_e(x, z);
                    chunkToSave.func_76630_e();
                }
            }
        }
    }

    protected abstract boolean updateServer();

    protected abstract void updateClient();

    protected abstract boolean isBlockGoodForFrame(World var1, int var2, int var3, int var4, IMultiblockValidator var5);

    protected abstract boolean isBlockGoodForTop(World var1, int var2, int var3, int var4, IMultiblockValidator var5);

    protected abstract boolean isBlockGoodForBottom(World var1, int var2, int var3, int var4, IMultiblockValidator var5);

    protected abstract boolean isBlockGoodForSides(World var1, int var2, int var3, int var4, IMultiblockValidator var5);

    protected abstract boolean isBlockGoodForInterior(World var1, int var2, int var3, int var4, IMultiblockValidator var5);

    public BlockPos getReferenceCoord() {
        if (this.referenceCoord == null) {
            this.selectNewReferenceCoord();
        }
        return this.referenceCoord;
    }

    public int getNumConnectedBlocks() {
        return this.connectedParts.size();
    }

    protected abstract void syncDataFrom(NBTTagCompound var1, ModTileEntity.SyncReason var2);

    protected abstract void syncDataTo(NBTTagCompound var1, ModTileEntity.SyncReason var2);

    public void recalculateMinMaxCoords() {
        int minZ = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minX = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxX = Integer.MIN_VALUE;
        for (IMultiblockPart part : this.connectedParts) {
            BlockPos partPos = part.getWorldPosition();
            int partCoord = partPos.func_177958_n();
            if (partCoord < minX) {
                minX = partCoord;
            }
            if (partCoord > maxX) {
                maxX = partCoord;
            }
            if ((partCoord = partPos.func_177956_o()) < minY) {
                minY = partCoord;
            }
            if (partCoord > maxY) {
                maxY = partCoord;
            }
            if ((partCoord = partPos.func_177952_p()) < minZ) {
                minZ = partCoord;
            }
            if (partCoord <= maxZ) continue;
            maxZ = partCoord;
        }
        this.minimumCoord = new BlockPos(minX, minY, minZ);
        this.maximumCoord = new BlockPos(maxX, maxY, maxZ);
    }

    public BlockPos getMinimumCoord() {
        if (this.minimumCoord == null) {
            this.recalculateMinMaxCoords();
        }
        return this.minimumCoord;
    }

    public BlockPos getMaximumCoord() {
        if (this.maximumCoord == null) {
            this.recalculateMinMaxCoords();
        }
        return this.maximumCoord;
    }

    public boolean isEmpty() {
        return this.connectedParts.isEmpty();
    }

    public boolean shouldConsume(MultiblockControllerBase otherController) {
        if (!otherController.getClass().equals(this.getClass())) {
            throw new IllegalArgumentException("Attempting to merge two multiblocks with different master classes - this should never happen!");
        }
        if (otherController == this) {
            return false;
        }
        int res = this._shouldConsume(otherController);
        if (res < 0) {
            return true;
        }
        if (res > 0) {
            return false;
        }
        ZeroCore.getLogger().warn("[%s] Encountered two controllers with the same reference coordinate. Auditing connected parts and retrying.", (Object)(this.WORLD.field_72995_K ? "CLIENT" : "SERVER"));
        this.auditParts();
        otherController.auditParts();
        res = this._shouldConsume(otherController);
        if (res < 0) {
            return true;
        }
        if (res > 0) {
            return false;
        }
        ZeroCore.getLogger().error("My Controller (%d): size (%d), parts: %s", (Object)this.hashCode(), (Object)this.connectedParts.size(), (Object)this.getPartsListString());
        ZeroCore.getLogger().error("Other Controller (%d): size (%d), coords: %s", (Object)otherController.hashCode(), (Object)otherController.connectedParts.size(), (Object)otherController.getPartsListString());
        throw new IllegalArgumentException("[" + (this.WORLD.field_72995_K ? "CLIENT" : "SERVER") + "] Two controllers with the same reference coord that somehow both have valid parts - this should never happen!");
    }

    private int _shouldConsume(MultiblockControllerBase otherController) {
        BlockPos myCoord = this.getReferenceCoord();
        BlockPos theirCoord = otherController.getReferenceCoord();
        if (theirCoord == null) {
            return -1;
        }
        return myCoord.compareTo((Vec3i)theirCoord);
    }

    private String getPartsListString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (IMultiblockPart part : this.connectedParts) {
            if (!first) {
                sb.append(", ");
            }
            BlockPos partPos = part.getWorldPosition();
            sb.append(String.format("(%d: %d, %d, %d)", part.hashCode(), partPos.func_177958_n(), partPos.func_177956_o(), partPos.func_177952_p()));
            first = false;
        }
        return sb.toString();
    }

    private void auditParts() {
        HashSet<IMultiblockPart> deadParts = new HashSet<IMultiblockPart>();
        for (IMultiblockPart part : this.connectedParts) {
            if (!part.isPartInvalid() && part == this.getTile(part.getWorldPosition())) continue;
            this.onDetachBlock(part);
            deadParts.add(part);
        }
        this.connectedParts.removeAll(deadParts);
        ZeroCore.getLogger().warn("[%s] Controller found %d dead parts during an audit, %d parts remain attached", (Object)(this.WORLD.field_72995_K ? "CLIENT" : "SERVER"), (Object)deadParts.size(), (Object)this.connectedParts.size());
    }

    public Set<IMultiblockPart> checkForDisconnections() {
        if (!this.shouldCheckForDisconnections) {
            return null;
        }
        if (this.isEmpty()) {
            REGISTRY.addDeadController(this.WORLD, this);
            return null;
        }
        IChunkProvider chunkProvider = this.WORLD.func_72863_F();
        this.referenceCoord = null;
        HashSet<IMultiblockPart> deadParts = new HashSet<IMultiblockPart>();
        IMultiblockPart referencePart = null;
        int originalSize = this.connectedParts.size();
        for (IMultiblockPart part : this.connectedParts) {
            BlockPos position = part.getWorldPosition();
            if (!this.WORLD.func_175667_e(position) || part.isPartInvalid()) {
                deadParts.add(part);
                this.onDetachBlock(part);
                continue;
            }
            if (part != this.getTile(position)) {
                deadParts.add(part);
                this.onDetachBlock(part);
                continue;
            }
            part.setUnvisited();
            part.forfeitMultiblockSaveDelegate();
            if (this.referenceCoord == null) {
                this.referenceCoord = position;
                referencePart = part;
                continue;
            }
            if (position.compareTo((Vec3i)this.referenceCoord) >= 0) continue;
            this.referenceCoord = position;
            referencePart = part;
        }
        this.connectedParts.removeAll(deadParts);
        deadParts.clear();
        if (referencePart == null || this.isEmpty()) {
            this.shouldCheckForDisconnections = false;
            REGISTRY.addDeadController(this.WORLD, this);
            return null;
        }
        referencePart.becomeMultiblockSaveDelegate();
        LinkedList<IMultiblockPart> partsToCheck = new LinkedList<IMultiblockPart>();
        IMultiblockPart[] nearbyParts = null;
        int visitedParts = 0;
        partsToCheck.add(referencePart);
        while (!partsToCheck.isEmpty()) {
            IMultiblockPart part = (IMultiblockPart)partsToCheck.removeFirst();
            part.setVisited();
            ++visitedParts;
            for (IMultiblockPart nearbyPart : nearbyParts = part.getNeighboringParts()) {
                if (nearbyPart.getMultiblockController() != this || nearbyPart.isVisited()) continue;
                nearbyPart.setVisited();
                partsToCheck.add(nearbyPart);
            }
        }
        HashSet<IMultiblockPart> removedParts = new HashSet<IMultiblockPart>();
        for (IMultiblockPart orphanCandidate : this.connectedParts) {
            if (orphanCandidate.isVisited()) continue;
            deadParts.add(orphanCandidate);
            orphanCandidate.onOrphaned(this, originalSize, visitedParts);
            this.onDetachBlock(orphanCandidate);
            removedParts.add(orphanCandidate);
        }
        this.connectedParts.removeAll(deadParts);
        deadParts.clear();
        if (this.referenceCoord == null) {
            this.selectNewReferenceCoord();
        }
        this.shouldCheckForDisconnections = false;
        return removedParts;
    }

    public Set<IMultiblockPart> detachAllBlocks() {
        if (this.WORLD == null) {
            return new HashSet<IMultiblockPart>();
        }
        IChunkProvider chunkProvider = this.WORLD.func_72863_F();
        for (IMultiblockPart part : this.connectedParts) {
            if (!this.WORLD.func_175667_e(part.getWorldPosition())) continue;
            this.onDetachBlock(part);
        }
        HashSet<IMultiblockPart> detachedParts = this.connectedParts;
        this.connectedParts = new HashSet();
        return detachedParts;
    }

    public boolean isAssembled() {
        return this.assemblyState == AssemblyState.Assembled;
    }

    public boolean isDisassembled() {
        return this.assemblyState == AssemblyState.Disassembled;
    }

    public boolean isPaused() {
        return this.assemblyState == AssemblyState.Paused;
    }

    private void selectNewReferenceCoord() {
        IChunkProvider chunkProvider = this.WORLD.func_72863_F();
        IMultiblockPart theChosenOne = null;
        this.referenceCoord = null;
        for (IMultiblockPart part : this.connectedParts) {
            BlockPos position = part.getWorldPosition();
            if (part.isPartInvalid() || !this.WORLD.func_175667_e(position) || this.referenceCoord != null && this.referenceCoord.compareTo((Vec3i)position) <= 0) continue;
            this.referenceCoord = position;
            theChosenOne = part;
        }
        if (theChosenOne != null) {
            theChosenOne.becomeMultiblockSaveDelegate();
        }
    }

    protected void markReferenceCoordForUpdate() {
        BlockPos rc = this.getReferenceCoord();
        if (this.WORLD != null && rc != null) {
            WorldHelper.notifyBlockUpdate(this.WORLD, rc, null, null);
        }
    }

    protected void markReferenceCoordDirty() {
        if (this.WORLD == null || this.WORLD.field_72995_K) {
            return;
        }
        BlockPos referenceCoord = this.getReferenceCoord();
        if (referenceCoord == null) {
            return;
        }
        TileEntity saveTe = this.getTile(referenceCoord);
        this.WORLD.func_175646_b(referenceCoord, saveTe);
    }

    protected void markMultiblockForRenderUpdate() {
        this.WORLD.func_175704_b(this.getMinimumCoord(), this.getMaximumCoord());
    }

    protected boolean doesPartBelong(IMultiblockPart part) {
        return this == part.getMultiblockController() || this.connectedParts.contains(part);
    }

    public void forceStructureUpdate(World world) {
    }

    @Nullable
    protected TileEntity getTile() {
        return WorldHelper.getTile((IBlockAccess)this.WORLD, this.referenceCoord);
    }

    @Nullable
    protected TileEntity getTile(@Nonnull BlockPos position) {
        return WorldHelper.getTile((IBlockAccess)this.WORLD, position);
    }

    protected static enum AssemblyState {
        Disassembled,
        Assembled,
        Paused;

    }
}

