/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.managers;

import com.google.inject.Singleton;
import io.github.aquerr.eaglefactions.api.entities.Claim;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.entities.FactionMemberType;
import io.github.aquerr.eaglefactions.api.entities.FactionPermType;
import io.github.aquerr.eaglefactions.api.managers.PermsManager;
import java.util.UUID;

@Singleton
public class PermsManagerImpl
implements PermsManager {
    @Override
    public boolean canBreakBlock(UUID playerUUID, Faction playerFaction, Faction chunkFaction, Claim claim) {
        return this.checkPermission(playerUUID, playerFaction, chunkFaction, FactionPermType.DESTROY, claim);
    }

    @Override
    public boolean canPlaceBlock(UUID playerUUID, Faction playerFaction, Faction chunkFaction, Claim claim) {
        return this.checkPermission(playerUUID, playerFaction, chunkFaction, FactionPermType.PLACE, claim);
    }

    @Override
    public boolean canInteract(UUID playerUUID, Faction playerFaction, Faction chunkFaction, Claim claim) {
        return this.checkPermission(playerUUID, playerFaction, chunkFaction, FactionPermType.USE, claim);
    }

    @Override
    public boolean canClaim(UUID playerUUID, Faction playerFaction) {
        return this.checkPermission(playerUUID, playerFaction, FactionPermType.CLAIM);
    }

    @Override
    public boolean canAttack(UUID playerUUID, Faction playerFaction) {
        return this.checkPermission(playerUUID, playerFaction, FactionPermType.CLAIM);
    }

    @Override
    public boolean canInvite(UUID playerUUID, Faction playerFaction) {
        return this.checkPermission(playerUUID, playerFaction, FactionPermType.INVITE);
    }

    private boolean checkPermission(UUID playerUUID, Faction playerFaction, FactionPermType flagTypes) {
        FactionMemberType memberType = playerFaction.getPlayerMemberType(playerUUID);
        if (memberType == FactionMemberType.LEADER) {
            return true;
        }
        return playerFaction.getPerms().get((Object)memberType).get((Object)flagTypes);
    }

    private boolean checkPermission(UUID playerUUID, Faction playerFaction, Faction chunkFaction, FactionPermType flagType, Claim claim) {
        if (playerFaction.getName().equals(chunkFaction.getName())) {
            FactionMemberType memberType = chunkFaction.getPlayerMemberType(playerUUID);
            if (memberType == FactionMemberType.LEADER) {
                return true;
            }
            if (memberType == FactionMemberType.NONE) {
                return false;
            }
            boolean hasPerm = chunkFaction.getPerms().get((Object)memberType).get((Object)flagType);
            if (hasPerm) {
                if (memberType == FactionMemberType.OFFICER) {
                    return true;
                }
                boolean isAccessibleByFaction = claim.isAccessibleByFaction();
                if (isAccessibleByFaction) {
                    return true;
                }
                return claim.hasAccess(playerUUID);
            }
            return false;
        }
        if (playerFaction.getAlliances().contains(chunkFaction.getName())) {
            boolean hasPerms = chunkFaction.getPerms().get((Object)FactionMemberType.ALLY).get((Object)flagType);
            return hasPerms && claim.isAccessibleByFaction();
        }
        if (playerFaction.getTruces().contains(chunkFaction.getName())) {
            return false;
        }
        return false;
    }
}

