/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjc.core;

import com.gmail.trentech.pjc.Main;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ConcurrentHashMap;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.format.TextColors;

public class ConfigManager {
    private Path path;
    private CommentedConfigurationNode config;
    private ConfigurationLoader<CommentedConfigurationNode> loader;
    private static ConcurrentHashMap<String, ConcurrentHashMap<String, ConfigManager>> configManagers = new ConcurrentHashMap();

    private ConfigManager(PluginContainer plugin, String configName) {
        try {
            this.path = Sponge.getGame().getConfigManager().getPluginConfig((Object)plugin).getDirectory().resolve(configName + ".conf");
            if (!Files.exists(this.path, new LinkOption[0])) {
                Files.createFile(this.path, new FileAttribute[0]);
                Main.instance().getLog().info("Creating new " + this.path.getFileName() + " file for " + plugin.getName());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.load();
    }

    public static ConfigManager init(PluginContainer plugin) {
        return ConfigManager.init(plugin, plugin.getId());
    }

    public static ConfigManager init(PluginContainer plugin, String configName) {
        ConfigManager configManager = new ConfigManager(plugin, configName);
        CommentedConfigurationNode config = configManager.getConfig();
        if (configName.equalsIgnoreCase(Main.getPlugin().getId())) {
            if (config.getNode(new Object[]{"theme", "pagination", "title"}).isVirtual()) {
                config.getNode(new Object[]{"theme", "pagination", "title", "color"}).setValue((Object)TextColors.GREEN.getName().toUpperCase()).setComment("One of the following: AQUA,BLACK,BLUE,DARK_AQUA,DARK_BLUE,DARK_GRAY,DARK_GREEN,DARK_PURPLE,DARK_RED,GOLD,GRAY,GREEN,LIGHT_PURPLE,RED,WHITE,YELLOW");
                config.getNode(new Object[]{"theme", "pagination", "title", "style"}).setValue((Object)"UNDERLINE").setComment("One or more(Comma seperated) of the following: BOLD,ITALIC,UNDERLINE,STRIKETHROUGH,OBFUSCATED");
            }
            if (config.getNode(new Object[]{"theme", "pagination", "padding"}).isVirtual()) {
                config.getNode(new Object[]{"theme", "pagination", "padding", "color"}).setValue((Object)TextColors.DARK_GREEN.getName()).setComment("One of the following: AQUA,BLACK,BLUE,DARK_AQUA,DARK_BLUE,DARK_GRAY,DARK_GREEN,DARK_PURPLE,DARK_RED,GOLD,GRAY,GREEN,LIGHT_PURPLE,RED,WHITE,YELLOW");
                config.getNode(new Object[]{"theme", "pagination", "padding", "style"}).setValue((Object)"STRIKETHROUGH,BOLD").setComment("One or more(Comma seperated) of the following: BOLD,ITALIC,UNDERLINE,STRIKETHROUGH,OBFUSCATED");
                config.getNode(new Object[]{"theme", "pagination", "padding", "text"}).setValue((Object)"=").setComment("Characters the padding will be made of");
            }
            if (config.getNode(new Object[]{"theme", "list"}).isVirtual()) {
                config.getNode(new Object[]{"theme", "list", "color"}).setValue((Object)TextColors.GREEN.getName().toUpperCase()).setComment("One of the following: AQUA,BLACK,BLUE,DARK_AQUA,DARK_BLUE,DARK_GRAY,DARK_GREEN,DARK_PURPLE,DARK_RED,GOLD,GRAY,GREEN,LIGHT_PURPLE,RED,WHITE,YELLOW");
                config.getNode(new Object[]{"theme", "list", "style"}).setValue((Object)"ITALIC").setComment("One or more(Comma seperated) of the following: 'BOLD,ITALIC,UNDERLINE,STRIKETHROUGH,OBFUSCATED'");
            }
            if (config.getNode(new Object[]{"theme", "content"}).isVirtual()) {
                config.getNode(new Object[]{"theme", "content", "color"}).setValue((Object)TextColors.WHITE.getName().toUpperCase()).setComment("One of the following: AQUA,BLACK,BLUE,DARK_AQUA,DARK_BLUE,DARK_GRAY,DARK_GREEN,DARK_PURPLE,DARK_RED,GOLD,GRAY,GREEN,LIGHT_PURPLE,RED,WHITE,YELLOW");
                config.getNode(new Object[]{"theme", "content", "style"}).setValue((Object)"NONE").setComment("One or more(Comma seperated) of the following: 'BOLD,ITALIC,UNDERLINE,STRIKETHROUGH,OBFUSCATED'");
            }
            if (config.getNode(new Object[]{"theme", "headers"}).isVirtual()) {
                config.getNode(new Object[]{"theme", "headers", "color"}).setValue((Object)TextColors.GREEN.getName().toUpperCase()).setComment("One of the following: AQUA,BLACK,BLUE,DARK_AQUA,DARK_BLUE,DARK_GRAY,DARK_GREEN,DARK_PURPLE,DARK_RED,GOLD,GRAY,GREEN,LIGHT_PURPLE,RED,WHITE,YELLOW");
                config.getNode(new Object[]{"theme", "headers", "style"}).setValue((Object)"BOLD").setComment("One or more(Comma seperated) of the following: 'BOLD,ITALIC,UNDERLINE,STRIKETHROUGH,OBFUSCATED'");
            }
            if (config.getNode(new Object[]{"theme", "keys"}).isVirtual()) {
                config.getNode(new Object[]{"theme", "keys", "color"}).setValue((Object)TextColors.GREEN.getName().toUpperCase()).setComment("One of the following: AQUA,BLACK,BLUE,DARK_AQUA,DARK_BLUE,DARK_GRAY,DARK_GREEN,DARK_PURPLE,DARK_RED,GOLD,GRAY,GREEN,LIGHT_PURPLE,RED,WHITE,YELLOW");
                config.getNode(new Object[]{"theme", "keys", "style"}).setValue((Object)"NONE").setComment("One or more(Comma seperated) of the following: 'BOLD,ITALIC,UNDERLINE,STRIKETHROUGH,OBFUSCATED'");
            }
            if (config.getNode(new Object[]{"theme", "values"}).isVirtual()) {
                config.getNode(new Object[]{"theme", "values", "color"}).setValue((Object)TextColors.WHITE.getName().toUpperCase()).setComment("One of the following: AQUA,BLACK,BLUE,DARK_AQUA,DARK_BLUE,DARK_GRAY,DARK_GREEN,DARK_PURPLE,DARK_RED,GOLD,GRAY,GREEN,LIGHT_PURPLE,RED,WHITE,YELLOW");
                config.getNode(new Object[]{"theme", "values", "style"}).setValue((Object)"NONE").setComment("One or more(Comma seperated) of the following: 'BOLD,ITALIC,UNDERLINE,STRIKETHROUGH,OBFUSCATED'");
            }
            if (config.getNode(new Object[]{"settings", "sql"}).isVirtual()) {
                config.getNode(new Object[]{"settings", "sql"}).setComment("Default database values for all PJP dependant plugins. Can be overridden in specified plugin configs");
                config.getNode(new Object[]{"settings", "sql", "enable"}).setValue((Object)false);
                config.getNode(new Object[]{"settings", "sql", "prefix"}).setValue((Object)"NONE");
                config.getNode(new Object[]{"settings", "sql", "url"}).setValue((Object)"localhost:3306");
                config.getNode(new Object[]{"settings", "sql", "username"}).setValue((Object)"root");
                config.getNode(new Object[]{"settings", "sql", "password"}).setValue((Object)"password");
            }
        }
        configManager.save();
        ConcurrentHashMap<String, ConfigManager> hash = !configManagers.containsKey(plugin.getId()) ? new ConcurrentHashMap<String, ConfigManager>() : configManagers.get(plugin.getId());
        hash.put(configName, configManager);
        configManagers.put(plugin.getId(), hash);
        return configManager;
    }

    public static ConfigManager get(PluginContainer plugin, String configName) {
        if (!configManagers.containsKey(plugin.getId()) || !configManagers.get(plugin.getId()).containsKey(configName)) {
            return ConfigManager.init(plugin, configName);
        }
        return configManagers.get(plugin.getId()).get(configName);
    }

    public static ConfigManager get(PluginContainer plugin) {
        return ConfigManager.get(plugin, plugin.getId());
    }

    public ConfigurationLoader<CommentedConfigurationNode> getLoader() {
        return this.loader;
    }

    public CommentedConfigurationNode getConfig() {
        return this.config;
    }

    public void save() {
        try {
            this.loader.save((ConfigurationNode)this.config);
        }
        catch (IOException e) {
            Main.instance().getLog().error("Failed to save config");
            e.printStackTrace();
        }
    }

    private void load() {
        this.loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(this.path)).build();
        try {
            this.config = (CommentedConfigurationNode)this.loader.load();
        }
        catch (IOException e) {
            Main.instance().getLog().error("Failed to load config");
            e.printStackTrace();
        }
    }
}

