/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjc.help;

import com.gmail.trentech.pjc.Main;
import com.gmail.trentech.pjc.core.ConfigManager;
import com.gmail.trentech.pjc.help.Argument;
import com.gmail.trentech.pjc.help.Usage;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.format.TextStyles;

public class Help
implements Comparable<Help> {
    private final String rawCommand;
    private final String command;
    private final String description;
    private Optional<String> permission = Optional.empty();
    private Optional<Usage> usage = Optional.empty();
    private List<String> examples = new ArrayList<String>();
    private List<Help> children = new ArrayList<Help>();
    private static List<Help> list = new ArrayList<Help>();

    public Help(String rawCommand, String command, String description) {
        this.rawCommand = rawCommand;
        this.command = command;
        this.description = description;
    }

    public String getRawCommand() {
        return this.rawCommand;
    }

    public String getDescription() {
        return this.description;
    }

    public Optional<String> getPermission() {
        return this.permission;
    }

    public Optional<Usage> getUsage() {
        return this.usage;
    }

    public List<String> getExamples() {
        return this.examples;
    }

    public String getCommand() {
        return this.command;
    }

    public List<Help> getChildren() {
        return this.children;
    }

    public Help setPermission(String permission) {
        this.permission = Optional.of(permission);
        return this;
    }

    public Help setUsage(Usage usage) {
        this.usage = Optional.of(usage);
        return this;
    }

    public Help addExample(String example) {
        this.examples.add(example);
        return this;
    }

    public Help addChild(Help help) {
        this.children.add(help);
        return this;
    }

    public Text getUsageText() {
        Text command = Text.of((Object[])new Object[]{"Usage: /", this.getRawCommand()});
        Optional<Usage> optionalUsage = this.getUsage();
        if (optionalUsage.isPresent()) {
            Usage usage = optionalUsage.get();
            for (Argument argument : usage.getArguments()) {
                Optional<String> description = argument.getDescription();
                if (description.isPresent()) {
                    StringBuilder sb = new StringBuilder(description.get());
                    int i = 0;
                    while ((i = sb.indexOf(" ", i + 50)) != -1) {
                        sb.replace(i, i + 1, "\n");
                    }
                    command = Text.join((Text[])new Text[]{command, Text.of((String)" "), Text.builder().onHover((HoverAction)TextActions.showText((Text)Text.of((String)sb.toString()))).append(new Text[]{Text.of((String)argument.getKey())}).build()});
                    continue;
                }
                command = Text.join((Text[])new Text[]{command, Text.of((String)" "), Text.of((String)argument.getKey())});
            }
        }
        return Text.builder().color(TextColors.RED).onClick((ClickAction)TextActions.executeCallback(this.execute())).append(new Text[]{command}).build();
    }

    public void execute(CommandSource src) {
        Optional<Usage> optionalUsage;
        CommentedConfigurationNode config = ConfigManager.get(Main.getPlugin()).getConfig();
        TextColor headersColor = (TextColor)Sponge.getRegistry().getType(TextColor.class, config.getNode(new Object[]{"theme", "headers", "color"}).getString()).get();
        TextColor contentColor = (TextColor)Sponge.getRegistry().getType(TextColor.class, config.getNode(new Object[]{"theme", "content", "color"}).getString()).get();
        TextStyle headersStyle = Help.getStyle(config.getNode(new Object[]{"theme", "headers", "style"}));
        TextStyle contentStyle = Help.getStyle(config.getNode(new Object[]{"theme", "content", "style"}));
        ArrayList<Text> list = new ArrayList<Text>();
        list.add(Text.of((Object[])new Object[]{headersStyle, headersColor, "Description:"}));
        StringBuilder sb = new StringBuilder(" " + this.getDescription());
        if (sb.indexOf(" ", 50) == -1) {
            list.add(Text.of((Object[])new Object[]{contentStyle, contentColor, sb.toString()}));
        } else {
            int i = 0;
            while ((i = sb.indexOf(" ", i + 50)) != -1) {
                list.add(Text.of((Object[])new Object[]{contentStyle, contentColor, sb.substring(0, i)}));
                sb.delete(0, i);
                i = 0;
            }
            list.add(Text.of((Object[])new Object[]{contentStyle, contentColor, sb.toString()}));
        }
        Optional<String> permission = this.getPermission();
        if (permission.isPresent()) {
            if (!src.hasPermission(permission.get())) {
                return;
            }
            list.add(Text.of((Object[])new Object[]{headersStyle, headersColor, "Permission:"}));
            list.add(Text.of((Object[])new Object[]{contentStyle, contentColor, " ", permission.get()}));
        }
        if ((optionalUsage = this.getUsage()).isPresent()) {
            Usage usage = optionalUsage.get();
            list.add(Text.of((Object[])new Object[]{headersStyle, headersColor, "Usage:"}));
            Text command = Text.of((Object[])new Object[]{" /", this.getRawCommand()});
            for (Argument argument : usage.getArguments()) {
                Optional<String> description = argument.getDescription();
                if (description.isPresent()) {
                    sb = new StringBuilder(description.get());
                    int i = 0;
                    while ((i = sb.indexOf(" ", i + 50)) != -1) {
                        sb.replace(i, i + 1, "\n");
                    }
                    if (command.toPlain().length() > 45) {
                        list.add(Text.of((Object[])new Object[]{contentStyle, contentColor, command}));
                        command = Text.join((Text[])new Text[]{Text.of((String)" "), Text.builder().onHover((HoverAction)TextActions.showText((Text)Text.of((String)sb.toString()))).append(new Text[]{Text.of((String)argument.getKey())}).build()});
                        continue;
                    }
                    command = Text.join((Text[])new Text[]{command, Text.of((String)" "), Text.builder().onHover((HoverAction)TextActions.showText((Text)Text.of((String)sb.toString()))).append(new Text[]{Text.of((String)argument.getKey())}).build()});
                    continue;
                }
                if (command.toPlain().length() > 45) {
                    list.add(Text.of((Object[])new Object[]{contentStyle, contentColor, command}));
                    command = Text.join((Text[])new Text[]{Text.of((String)" "), Text.of((String)argument.getKey())});
                    continue;
                }
                command = Text.join((Text[])new Text[]{command, Text.of((String)" "), Text.of((String)argument.getKey())});
            }
            list.add(Text.of((Object[])new Object[]{contentStyle, contentColor, command}));
        }
        TextColor paddingColor = (TextColor)Sponge.getRegistry().getType(TextColor.class, config.getNode(new Object[]{"theme", "pagination", "padding", "color"}).getString()).get();
        TextColor titleColor = (TextColor)Sponge.getRegistry().getType(TextColor.class, config.getNode(new Object[]{"theme", "pagination", "title", "color"}).getString()).get();
        TextStyle paddingStyle = Help.getStyle(config.getNode(new Object[]{"theme", "pagination", "padding", "style"}));
        TextStyle titleStyle = Help.getStyle(config.getNode(new Object[]{"theme", "pagination", "title", "style"}));
        LiteralText paddingText = Text.of((String)config.getNode(new Object[]{"theme", "pagination", "padding", "text"}).getString());
        List<String> examples = this.getExamples();
        if (!examples.isEmpty()) {
            list.add(Text.of((Object[])new Object[]{headersStyle, headersColor, "Example:"}));
            for (String example : examples) {
                list.add(Text.of((Object[])new Object[]{contentStyle, contentColor, " ", example}));
            }
        }
        PaginationList.builder().padding(Text.builder().style(new TextStyle[]{paddingStyle}).color(paddingColor).append(new Text[]{paddingText}).build()).title(Text.builder().color(paddingColor).append(new Text[]{Text.of((Object[])new Object[]{titleStyle, titleColor, this.getCommand().toLowerCase()})}).build()).contents(list).sendTo((MessageReceiver)src);
    }

    private static TextStyle getStyle(ConfigurationNode node) {
        TextStyle style = TextStyles.NONE;
        String[] styles = node.getString().split(",");
        for (int i = 0; i < styles.length; ++i) {
            if (styles[i].equalsIgnoreCase("BOLD")) {
                style = style.and(new TextStyle[]{TextStyles.BOLD});
                continue;
            }
            if (styles[i].equalsIgnoreCase("ITALIC")) {
                style = style.and(new TextStyle[]{TextStyles.ITALIC});
                continue;
            }
            if (styles[i].equalsIgnoreCase("OBFUSCATED")) {
                style = style.and(new TextStyle[]{TextStyles.OBFUSCATED});
                continue;
            }
            if (styles[i].equalsIgnoreCase("UNDERLINE")) {
                style = style.and(new TextStyle[]{TextStyles.UNDERLINE});
                continue;
            }
            if (!styles[i].equalsIgnoreCase("STRIKETHROUGH")) continue;
            style = style.and(new TextStyle[]{TextStyles.STRIKETHROUGH});
        }
        return style;
    }

    public Consumer<CommandSource> execute() {
        return src -> this.execute((CommandSource)src);
    }

    public static void executeList(CommandSource src, List<Help> list) {
        Comparable[] array = list.toArray(new Help[list.size()]);
        Arrays.parallelSort((Comparable[])array);
        CommentedConfigurationNode config = ConfigManager.get(Main.getPlugin()).getConfig();
        TextColor listColor = (TextColor)Sponge.getRegistry().getType(TextColor.class, config.getNode(new Object[]{"theme", "list", "color"}).getString()).get();
        TextStyle listStyle = Help.getStyle(config.getNode(new Object[]{"theme", "list", "style"}));
        ArrayList<Object> pages = new ArrayList<Object>();
        for (Comparable help : array) {
            Optional<String> optionalPermission = ((Help)help).getPermission();
            if (optionalPermission.isPresent()) {
                if (!src.hasPermission(optionalPermission.get())) continue;
                if (!((Help)help).getChildren().isEmpty()) {
                    pages.add(Text.builder().color(listColor).style(new TextStyle[]{listStyle}).onHover((HoverAction)TextActions.showText((Text)Text.of((String)"Click command for list of sub commands "))).onClick((ClickAction)TextActions.executeCallback(Help.executeList(((Help)help).getChildren()))).append(new Text[]{Text.of((String)((Help)help).getRawCommand())}).build());
                    continue;
                }
                pages.add(Text.builder().color(listColor).style(new TextStyle[]{listStyle}).onHover((HoverAction)TextActions.showText((Text)Text.of((String)"Click command for more information "))).onClick((ClickAction)TextActions.executeCallback(((Help)help).execute())).append(new Text[]{Text.of((String)((Help)help).getRawCommand())}).build());
                continue;
            }
            if (!((Help)help).getChildren().isEmpty()) {
                pages.add(Text.builder().color(listColor).style(new TextStyle[]{listStyle}).onHover((HoverAction)TextActions.showText((Text)Text.of((String)"Click command for list of sub commands "))).onClick((ClickAction)TextActions.executeCallback(Help.executeList(((Help)help).getChildren()))).append(new Text[]{Text.of((String)((Help)help).getRawCommand())}).build());
                continue;
            }
            pages.add(Text.builder().color(listColor).style(new TextStyle[]{listStyle}).onHover((HoverAction)TextActions.showText((Text)Text.of((String)"Click command for more information "))).onClick((ClickAction)TextActions.executeCallback(((Help)help).execute())).append(new Text[]{Text.of((String)((Help)help).getRawCommand())}).build());
        }
        if (!pages.isEmpty()) {
            TextColor paddingColor = (TextColor)Sponge.getRegistry().getType(TextColor.class, config.getNode(new Object[]{"theme", "pagination", "padding", "color"}).getString()).get();
            TextColor titleColor = (TextColor)Sponge.getRegistry().getType(TextColor.class, config.getNode(new Object[]{"theme", "pagination", "title", "color"}).getString()).get();
            TextStyle paddingStyle = Help.getStyle(config.getNode(new Object[]{"theme", "pagination", "padding", "style"}));
            TextStyle titleStyle = Help.getStyle(config.getNode(new Object[]{"theme", "pagination", "title", "style"}));
            LiteralText paddingText = Text.of((String)config.getNode(new Object[]{"theme", "pagination", "padding", "text"}).getString());
            if (src instanceof Player) {
                if (pages.size() > 18 && pages.size() % 18 != 0) {
                    while (pages.size() % 18 != 0) {
                        pages.add(Text.of((String)" "));
                    }
                }
                PaginationList.builder().padding(Text.builder().style(new TextStyle[]{paddingStyle}).append(new Text[]{paddingText}).build()).title(Text.builder().color(paddingColor).append(new Text[]{Text.of((Object[])new Object[]{titleStyle, titleColor, "Command List"})}).build()).contents(pages).sendTo((MessageReceiver)src);
            } else {
                for (Text text : pages) {
                    src.sendMessage(text);
                }
            }
        }
    }

    public static Consumer<CommandSource> executeList(List<Help> list) {
        return src -> Help.executeList(src, list);
    }

    public static Optional<Help> get(String rawCommand) {
        for (Help help : Help.all()) {
            if (!help.getRawCommand().equals(rawCommand)) continue;
            return Optional.of(help);
        }
        return Optional.empty();
    }

    public static List<Help> getParents() {
        return list;
    }

    public static List<Help> all() {
        return Help.getAll(Help.getParents());
    }

    private static List<Help> getAll(List<Help> children) {
        ArrayList<Help> list = new ArrayList<Help>();
        list.addAll(children);
        for (Help help : children) {
            List<Help> ch = help.getChildren();
            if (ch.isEmpty()) continue;
            list.addAll(Help.getAll(ch));
        }
        return list;
    }

    public static void register(Help help) {
        for (Help h : Lists.newArrayList(list)) {
            if (!h.getRawCommand().equals(help.getRawCommand())) continue;
            list.remove(h);
            break;
        }
        list.add(help);
    }

    @Override
    public int compareTo(Help help) {
        return this.getRawCommand().compareTo(help.getRawCommand());
    }
}

