/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.configurate.typeserialisers;

import com.google.common.reflect.TypeToken;
import java.util.Locale;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LocaleSerialiser
implements TypeSerializer<Locale> {
    public @Nullable Locale deserialize(@NonNull TypeToken<?> type, @NonNull ConfigurationNode value) {
        Locale l = Locale.forLanguageTag(value.getString("und").replace("_", "-"));
        if (l.toString().isEmpty()) {
            return null;
        }
        return l;
    }

    public void serialize(@NonNull TypeToken<?> type, @Nullable Locale obj, @NonNull ConfigurationNode value) {
        if (obj != null && !obj.toString().isEmpty()) {
            value.setValue((Object)obj.toString());
        }
    }
}

