/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.configurate.typeserialisers;

import com.google.common.reflect.TypeToken;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.module.mail.data.MailMessage;
import io.github.nucleuspowered.nucleus.modules.mail.data.MailData;
import io.github.nucleuspowered.nucleus.util.TypeTokens;
import java.time.Instant;
import java.util.UUID;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.util.Identifiable;

public class MailMessageSerialiser
implements TypeSerializer<MailMessage> {
    public @Nullable MailMessage deserialize(@NonNull TypeToken<?> type, @NonNull ConfigurationNode value) throws ObjectMappingException {
        if (value.isVirtual()) {
            return null;
        }
        try {
            return new MailData((UUID)value.getNode(new Object[]{"uuid"}).getValue(TypeTokens.UUID), Instant.ofEpochMilli(value.getNode(new Object[]{"date"}).getLong()), value.getNode(new Object[]{"message"}).getString());
        }
        catch (IllegalArgumentException e) {
            throw new ObjectMappingException("Could not create a mail message.", (Throwable)e);
        }
    }

    public void serialize(@NonNull TypeToken<?> type, @Nullable MailMessage obj, @NonNull ConfigurationNode value) {
        if (obj != null) {
            value.getNode(new Object[]{"uuid"}).setValue((Object)obj.getSender().map(Identifiable::getUniqueId).orElse(Util.CONSOLE_FAKE_UUID));
            value.getNode(new Object[]{"date"}).setValue((Object)obj.getDate().toEpochMilli());
            value.getNode(new Object[]{"message"}).setValue((Object)obj.getMessage());
        }
    }
}

