/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.commandspy.commands;

import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.userprefs.NucleusKeysProvider;
import io.github.nucleuspowered.nucleus.services.interfaces.IUserPreferenceService;
import java.util.UUID;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Command(aliases={"commandspy"}, basePermission={"nucleus.commandspy.base"}, commandDescriptionKey="commandspy")
@NonnullByDefault
public class CommandSpyCommand
implements ICommandExecutor<Player> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{NucleusParameters.OPTIONAL_ONE_TRUE_FALSE};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        IUserPreferenceService userPreferenceService = context.getServiceCollection().userPreferenceService();
        UUID uuid = context.getUniqueId().orElseThrow(() -> new CommandException((Text)Text.of((String)"No UUID was found")));
        boolean to = context.getOne("true|false", Boolean.class).orElseGet(() -> userPreferenceService.getUnwrapped(uuid, NucleusKeysProvider.COMMAND_SPY) == false);
        userPreferenceService.set(uuid, NucleusKeysProvider.COMMAND_SPY, Boolean.valueOf(to));
        context.sendMessage("command.commandspy.success", to ? "loc:standard.enabled" : "loc:standard.disabled");
        return context.successResult();
    }
}

