/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.core.commands.nucleus;

import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import io.github.nucleuspowered.nucleus.guice.DataDirectory;
import io.github.nucleuspowered.nucleus.modules.core.commands.NucleusCommand;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Supplier;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Command(aliases={"docgen"}, basePermission={"nucleus.nucleus.docgen.base"}, commandDescriptionKey="docgen", parentCommand=NucleusCommand.class)
@NonnullByDefault
public class DocGenCommand
implements ICommandExecutor<CommandSource> {
    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        context.sendMessage("command.nucleus.docgen.start", new Object[0]);
        INucleusServiceCollection serviceCollection = context.getServiceCollection();
        Path dataPath = (Path)((Supplier)serviceCollection.injector().getInstance(Key.get((TypeLiteral)new TypeLiteral<Supplier<Path>>(){}, DataDirectory.class))).get();
        try {
            serviceCollection.documentationGenerationService().generate(dataPath);
        }
        catch (IOException | ObjectMappingException e) {
            throw new CommandException((Text)Text.of((String)"Could not generate docs"), e);
        }
        context.sendMessage("command.nucleus.docgen.complete", new Object[0]);
        return context.successResult();
    }
}

