/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.info.listeners;

import io.github.nucleuspowered.nucleus.modules.info.config.InfoConfig;
import io.github.nucleuspowered.nucleus.scaffold.listener.ListenerBase;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IPermissionService;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import io.github.nucleuspowered.nucleus.services.interfaces.ITextFileControllerCollection;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;

public class InfoListener
implements IReloadableService.Reloadable,
ListenerBase.Conditional {
    private final IPermissionService permissionService;
    private final ITextFileControllerCollection textFileControllerCollection;
    private final PluginContainer pluginContainer;
    private boolean usePagination = true;
    private Text title = Text.EMPTY;
    private int delay = 500;

    @Inject
    public InfoListener(INucleusServiceCollection serviceCollection) {
        this.permissionService = serviceCollection.permissionService();
        this.textFileControllerCollection = serviceCollection.textFileControllerCollection();
        this.pluginContainer = serviceCollection.pluginContainer();
    }

    @Listener
    public void playerJoin(ClientConnectionEvent.Join event, @Getter(value="getTargetEntity") Player player) {
        Sponge.getScheduler().createAsyncExecutor((Object)this.pluginContainer).schedule(() -> {
            if (this.permissionService.hasPermission((Subject)player, "nucleus.motd.login")) {
                this.textFileControllerCollection.get("motd").ifPresent(x -> {
                    if (this.usePagination) {
                        x.sendToPlayer((CommandSource)player, this.title);
                    } else {
                        x.getTextFromNucleusTextTemplates((CommandSource)player).forEach(arg_0 -> ((Player)player).sendMessage(arg_0));
                    }
                });
            }
        }, (long)this.delay, TimeUnit.MILLISECONDS);
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        InfoConfig config = serviceCollection.moduleDataProvider().getModuleConfig(InfoConfig.class);
        this.delay = (int)(config.getMotdDelay() * 1000.0f);
        this.usePagination = config.isMotdUsePagination();
        String title = config.getMotdTitle();
        this.title = title.isEmpty() ? Text.EMPTY : TextSerializers.FORMATTING_CODE.deserialize(title);
    }

    @Override
    public boolean shouldEnable(INucleusServiceCollection serviceCollection) {
        return serviceCollection.moduleDataProvider().getModuleConfig(InfoConfig.class).isShowMotdOnJoin();
    }
}

