/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.item.commands.lore;

import io.github.nucleuspowered.nucleus.modules.item.commands.lore.LoreCommand;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.PositiveIntegerArgument;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.util.List;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.mutable.item.LoreData;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"delete"}, basePermission={"nucleus.lore.set.base"}, commandDescriptionKey="lore.delete", parentCommand=LoreCommand.class, modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.lore.set.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.lore.set.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.lore.set.exempt.cost")})
public class LoreDeleteCommand
implements ICommandExecutor<Player> {
    private final String loreLine = "line";

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{new PositiveIntegerArgument((Text)Text.of((String)this.loreLine), false, serviceCollection)};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        Player src = context.getIfPlayer();
        int line = context.requireOne(this.loreLine, Integer.class) - 1;
        ItemStack stack = (ItemStack)src.getItemInHand(HandTypes.MAIN_HAND).orElseThrow(() -> context.createException("command.lore.clear.noitem", new Object[0]));
        LoreData loreData = (LoreData)stack.getOrCreate(LoreData.class).get();
        List loreList = (List)loreData.lore().get();
        if (loreList.size() < line) {
            return context.errorResult("command.lore.set.invalidLine", new Object[0]);
        }
        loreList.remove(line);
        if (stack.offer(Keys.ITEM_LORE, (Object)loreList).isSuccessful()) {
            src.setItemInHand(HandTypes.MAIN_HAND, stack);
            context.sendMessage("command.lore.set.success", new Object[0]);
            return context.successResult();
        }
        return context.errorResult("command.lore.set.fail", new Object[0]);
    }
}

