/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.kick.commands;

import io.github.nucleuspowered.nucleus.configurate.config.CommonPermissionLevelConfig;
import io.github.nucleuspowered.nucleus.modules.kick.config.KickConfig;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import io.github.nucleuspowered.nucleus.util.PermissionMessageChannel;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@EssentialsEquivalent(value={"kick"})
@NonnullByDefault
@Command(aliases={"kick"}, basePermission={"nucleus.kick.base"}, commandDescriptionKey="kick", associatedPermissionLevelKeys={"nucleus.kick.level"}, associatedPermissions={"nucleus.kick.exempt.target", "nucleus.kick.notify"})
public class KickCommand
implements ICommandExecutor<CommandSource>,
IReloadableService.Reloadable {
    private CommonPermissionLevelConfig levelConfig = new CommonPermissionLevelConfig();

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{NucleusParameters.ONE_PLAYER.get(serviceCollection), NucleusParameters.OPTIONAL_REASON};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        Player pl = context.requireOne("player", Player.class);
        String r = context.getOne("reason", String.class).orElseGet(() -> context.getMessageString("command.kick.defaultreason", new Object[0]));
        if (!context.isConsoleAndBypass() && context.testPermissionFor((Subject)pl, "nucleus.kick.exempt.target")) {
            return context.errorResult("command.kick.exempt", pl.getName());
        }
        if (this.levelConfig.isUseLevels() && !context.isPermissionLevelOkay((Subject)pl, "nucleus.kick.level", "nucleus.kick.base", this.levelConfig.isCanAffectSameLevel())) {
            return context.errorResult("command.modifiers.level.insufficient", pl.getName());
        }
        pl.kick(TextSerializers.FORMATTING_CODE.deserialize(r));
        PermissionMessageChannel messageChannel = context.getServiceCollection().permissionService().permissionMessageChannel("nucleus.kick.notify");
        messageChannel.send(context.getCommandSource(), context.getMessage("command.kick.message", pl.getName(), context.getName()));
        messageChannel.send(context.getCommandSource(), context.getMessage("command.reason", r));
        return context.successResult();
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.levelConfig = serviceCollection.moduleDataProvider().getModuleConfig(KickConfig.class).getLevelConfig();
    }
}

