/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.message.infoprovider;

import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.modules.message.services.MessageHandler;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.playerinformation.NucleusProvider;
import io.github.nucleuspowered.nucleus.services.impl.userprefs.NucleusKeysProvider;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import java.util.ArrayList;
import java.util.Optional;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;

public class MessageInfoProvider
implements NucleusProvider {
    @Override
    public String getCategory() {
        return "message";
    }

    @Override
    public Optional<Text> get(User user, CommandSource source, INucleusServiceCollection serviceCollection) {
        if (serviceCollection.permissionService().hasPermission((Subject)source, "nucleus.socialspy.base")) {
            MessageHandler handler = serviceCollection.getServiceUnchecked(MessageHandler.class);
            boolean socialSpy = handler.isSocialSpy(user);
            boolean msgToggle = serviceCollection.userPreferenceService().getUnwrapped(user.getUniqueId(), NucleusKeysProvider.RECEIVING_MESSAGES);
            IMessageProviderService mp = serviceCollection.messageProvider();
            ArrayList lt = Lists.newArrayList((Object[])new Text[]{mp.getMessageFor(source, "seen.socialspy", mp.getMessageFor(source, "standard.yesno." + Boolean.toString(socialSpy).toLowerCase()))});
            lt.add(mp.getMessageFor(source, "seen.socialspylevel", serviceCollection.permissionService().getPositiveIntOptionFromSubject((Subject)user, "nucleus.socialspy.level").orElse(0)));
            lt.add(mp.getMessageFor(source, "seen.msgtoggle", mp.getMessageFor(source, "standard.yesno." + Boolean.toString(msgToggle).toLowerCase())));
            return Optional.of(Text.joinWith((Text)Text.NEW_LINE, (Iterable)lt));
        }
        return Optional.empty();
    }
}

