/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.mute.listeners;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.module.message.event.NucleusMessageEvent;
import io.github.nucleuspowered.nucleus.datatypes.EndTimestamp;
import io.github.nucleuspowered.nucleus.modules.message.events.InternalNucleusHelpOpEvent;
import io.github.nucleuspowered.nucleus.modules.mute.config.MuteConfig;
import io.github.nucleuspowered.nucleus.modules.mute.data.MuteData;
import io.github.nucleuspowered.nucleus.modules.mute.services.MuteHandler;
import io.github.nucleuspowered.nucleus.scaffold.listener.ListenerBase;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import io.github.nucleuspowered.nucleus.services.interfaces.IPermissionService;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.message.MessageChannelEvent;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextRepresentable;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.chat.ChatTypes;
import org.spongepowered.api.text.serializer.TextSerializers;

public class MuteListener
implements IReloadableService.Reloadable,
ListenerBase {
    private final MuteHandler handler;
    private final IMessageProviderService messageProvider;
    private final IPermissionService permissionService;
    private MuteConfig muteConfig = new MuteConfig();
    private final PluginContainer pluginContainer;

    @Inject
    public MuteListener(INucleusServiceCollection serviceCollection) {
        this.handler = serviceCollection.getServiceUnchecked(MuteHandler.class);
        this.messageProvider = serviceCollection.messageProvider();
        this.permissionService = serviceCollection.permissionService();
        this.pluginContainer = serviceCollection.pluginContainer();
    }

    @Listener
    public void onPlayerLogin(ClientConnectionEvent.Join event) {
        Sponge.getScheduler().createTaskBuilder().async().delay(500L, TimeUnit.MILLISECONDS).execute(() -> {
            Player user = event.getTargetEntity();
            Optional<MuteData> omd = this.handler.getPlayerMuteData((User)user);
            if (omd.isPresent()) {
                MuteData md = omd.get();
                md.nextLoginToTimestamp();
                if (this.isMuted(user)) {
                    this.handler.onMute(md, event.getTargetEntity());
                }
            }
        }).submit((Object)this.pluginContainer);
    }

    @Listener(order=Order.LATE)
    public void onChat(MessageChannelEvent.Chat event) {
        Util.onPlayerSimulatedOrPlayer(event, this::onChat);
    }

    private void onChat(MessageChannelEvent.Chat event, Player player) {
        boolean cancel = false;
        if (this.isMuted(player)) {
            this.handler.onMute(player);
            MessageChannel.TO_CONSOLE.send(Text.builder().append(new Text[]{Text.of((String)(player.getName() + " ("))}).append(new Text[]{this.messageProvider.getMessageFor((CommandSource)Sponge.getServer().getConsole(), "standard.muted")}).append(new Text[]{Text.of((String)"): ")}).append(new Text[]{event.getRawMessage()}).build());
            cancel = true;
        }
        if (this.cancelOnGlobalMute(player, false)) {
            cancel = true;
        }
        if (cancel) {
            if (this.muteConfig.isShowMutedChat()) {
                String m = this.muteConfig.getCancelledTag();
                if (!m.isEmpty()) {
                    event.getFormatter().setHeader((TextRepresentable)Text.join((Text[])new Text[]{TextSerializers.FORMATTING_CODE.deserialize(m), event.getFormatter().getHeader().toText()}));
                }
                this.permissionService.permissionMessageChannel("nucleus.mute.seemutedchat").send(player, event.getMessage(), ChatTypes.SYSTEM);
            }
            event.setCancelled(true);
        }
    }

    @Listener
    public void onPlayerMessage(NucleusMessageEvent event, @Getter(value="getSender") Player source) {
        boolean isCancelled = false;
        if (this.isMuted(source)) {
            if (source.isOnline()) {
                this.handler.onMute(source);
            }
            isCancelled = true;
        }
        if (this.cancelOnGlobalMute(source, isCancelled)) {
            isCancelled = true;
        }
        event.setCancelled(isCancelled);
    }

    @Listener
    public void onPlayerHelpOp(InternalNucleusHelpOpEvent event, @Root Player source) {
        if (this.isMuted(source)) {
            if (source.isOnline()) {
                this.handler.onMute(source);
            }
            event.setCancelled(true);
        }
        if (this.cancelOnGlobalMute(source, event.isCancelled())) {
            event.setCancelled(true);
        }
    }

    private boolean cancelOnGlobalMute(Player player, boolean isCancelled) {
        if (isCancelled || !this.handler.isGlobalMuteEnabled() || this.permissionService.hasPermission((Subject)player, "nucleus.globalmute.voice.auto")) {
            return false;
        }
        if (this.handler.isVoiced(player.getUniqueId())) {
            return false;
        }
        this.messageProvider.sendMessageTo((CommandSource)player, "globalmute.novoice");
        return true;
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.muteConfig = serviceCollection.moduleDataProvider().getModuleConfig(MuteConfig.class);
    }

    private boolean isMuted(Player player) {
        if (!this.handler.isMutedCached((User)player)) {
            return false;
        }
        if (this.handler.getPlayerMuteData((User)player).map(EndTimestamp::expired).orElse(true).booleanValue()) {
            this.handler.unmutePlayer((User)player);
            return false;
        }
        return true;
    }
}

