/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.playerinfo.commands;

import com.flowpowered.math.vector.Vector3i;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;

@NonnullByDefault
@Command(aliases={"getpos", "coords", "position", "whereami", "getlocation", "getloc"}, basePermission={"nucleus.getpos.base"}, commandDescriptionKey="getpos", modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.getpos.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.getpos.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.getpos.exempt.cost")}, associatedPermissions={"nucleus.getpos.others"})
public class GetPosCommand
implements ICommandExecutor<CommandSource> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{serviceCollection.commandElementSupplier().createOnlyOtherUserPermissionElement(false, "nucleus.getpos.others")};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        Location location;
        User user = context.getUserFromArgs();
        if (user.isOnline()) {
            location = ((Player)user.getPlayer().get()).getLocation();
        } else {
            World w = (World)user.getWorldUniqueId().flatMap(x -> Sponge.getServer().getWorld(x)).orElseThrow(() -> context.createException("command.getpos.location.nolocation", user.getName()));
            location = new Location((Extent)w, user.getPosition());
        }
        boolean isSelf = context.is(user);
        Vector3i blockPos = location.getBlockPosition();
        if (isSelf) {
            context.sendMessage("command.getpos.location.self", ((World)location.getExtent()).getName(), String.valueOf(blockPos.getX()), String.valueOf(blockPos.getY()), String.valueOf(blockPos.getZ()));
        } else {
            context.sendMessageText(context.getMessage("command.getpos.location.other", context.getDisplayName(user.getUniqueId()), ((World)location.getExtent()).getName(), String.valueOf(blockPos.getX()), String.valueOf(blockPos.getY()), String.valueOf(blockPos.getZ())).toBuilder().onClick((ClickAction)TextActions.runCommand((String)String.join((CharSequence)" ", "/nucleus:tppos", ((World)location.getExtent()).getName(), String.valueOf(blockPos.getX()), String.valueOf(blockPos.getY()), String.valueOf(blockPos.getZ())))).onHover((HoverAction)TextActions.showText((Text)context.getMessage("command.getpos.hover", new Object[0]))).build());
        }
        return context.successResult();
    }
}

