/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.powertool.commands;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.modules.powertool.commands.PowertoolCommand;
import io.github.nucleuspowered.nucleus.modules.powertool.services.PowertoolService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.impl.userprefs.NucleusKeysProvider;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"list", "ls"}, basePermission={"nucleus.powertool.base"}, commandDescriptionKey="powertool.list", parentCommand=PowertoolCommand.class)
public class ListPowertoolCommand
implements ICommandExecutor<Player> {
    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        UUID uuid = context.getUniqueId().get();
        boolean toggle = context.getServiceCollection().userPreferenceService().getUnwrapped(uuid, NucleusKeysProvider.POWERTOOL_ENABLED);
        PowertoolService service = context.getServiceCollection().getServiceUnchecked(PowertoolService.class);
        Map<String, List<String>> powertools = service.getPowertools(uuid);
        if (powertools.isEmpty()) {
            return context.errorResult("command.powertool.list.none", new Object[0]);
        }
        List mesl = powertools.entrySet().stream().sorted((a, b) -> ((String)a.getKey()).compareToIgnoreCase((String)b.getKey())).map(k -> this.from(service, context, (String)k.getKey(), (List)k.getValue())).collect(Collectors.toList());
        Util.getPaginationBuilder((CommandSource)context.getCommandSource()).title(context.getMessage("command.powertool.list.header", toggle ? "&aenabled" : "&cdisabled")).padding(Text.of((Object[])new Object[]{TextColors.YELLOW, "-"})).contents(mesl).sendTo((MessageReceiver)context.getCommandSource());
        return context.successResult();
    }

    private Text from(PowertoolService service, ICommandContext<? extends Player> context, String powertool, List<String> commands) {
        Optional oit = Sponge.getRegistry().getType(ItemType.class, powertool);
        Player src = context.getCommandSourceUnchecked();
        UUID uuid = src.getUniqueId();
        ClickAction.ExecuteCallback viewAction = TextActions.executeCallback(pl -> Util.getPaginationBuilder((CommandSource)src).title(context.getMessage("command.powertool.ind.header", powertool)).padding(Text.of((Object[])new Object[]{TextColors.GREEN, "-"})).contents((Iterable)commands.stream().map(x -> Text.of((Object[])new Object[]{TextColors.YELLOW, x})).collect(Collectors.toList())).sendTo((MessageReceiver)src));
        ClickAction.ExecuteCallback deleteAction = TextActions.executeCallback(pl -> {
            service.clearPowertool(uuid, powertool);
            context.sendMessage("command.powertool.removed", powertool);
        });
        TextColor tc = oit.map(itemType -> TextColors.YELLOW).orElse(TextColors.GRAY);
        return Text.builder().append(new Text[]{Text.of((Object[])new Object[]{tc, powertool})}).append(new Text[]{Text.of((String)" - ")}).append(new Text[]{context.getMessage("standard.view", new Object[0]).toBuilder().color(TextColors.YELLOW).onClick((ClickAction)viewAction).build()}).append(new Text[]{Text.of((String)" - ")}).append(new Text[]{context.getMessage("standard.delete", new Object[0]).toBuilder().color(TextColors.DARK_RED).onClick((ClickAction)deleteAction).build()}).build();
    }
}

