/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.powertool.commands;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.modules.powertool.services.PowertoolService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.translation.Translatable;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@EssentialsEquivalent(value={"powertool", "pt"})
@NonnullByDefault
@Command(aliases={"powertool", "pt"}, basePermission={"nucleus.powertool.base"}, commandDescriptionKey="powertool")
public class PowertoolCommand
implements ICommandExecutor<Player> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{NucleusParameters.OPTIONAL_COMMAND};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        Player src = context.getCommandSource();
        ItemStack itemStack = (ItemStack)src.getItemInHand(HandTypes.MAIN_HAND).orElseThrow(() -> context.createException("command.powertool.noitem", new Object[0]));
        Optional<String> command = context.getOne("command", String.class);
        return command.map(s -> this.setPowertool(context, src, itemStack.getType(), (String)s)).orElseGet(() -> this.viewPowertool(context, src, itemStack));
    }

    private ICommandResult viewPowertool(ICommandContext<? extends Player> context, Player src, ItemStack item) {
        Optional<List<String>> cmds = context.getServiceCollection().getServiceUnchecked(PowertoolService.class).getPowertoolForItem(src.getUniqueId(), item.getType());
        if (cmds.isPresent() && !cmds.get().isEmpty()) {
            Util.getPaginationBuilder((CommandSource)src).contents((Iterable)cmds.get().stream().map(f -> Text.of((Object[])new Object[]{TextColors.YELLOW, f})).collect(Collectors.toList())).title(context.getMessage("command.powertool.viewcmdstitle", Text.of((Translatable)item, (Object[])new Object[0]), Text.of((String)item.getType().getId()))).sendTo((MessageReceiver)src);
        } else {
            src.sendMessage(context.getMessage("command.powertool.nocmds", Text.of((Translatable)item, (Object[])new Object[0])));
        }
        return context.successResult();
    }

    private ICommandResult setPowertool(ICommandContext<? extends Player> context, Player src, ItemType item, String command) {
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        context.getServiceCollection().getServiceUnchecked(PowertoolService.class).setPowertool(src.getUniqueId(), item, Collections.singletonList(command));
        context.sendMessage("command.powertool.set", item.getId(), command);
        return context.successResult();
    }
}

