/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.services.impl;

import com.google.inject.Injector;
import io.github.nucleuspowered.nucleus.guice.ConfigDirectory;
import io.github.nucleuspowered.nucleus.guice.DataDirectory;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IChatMessageFormatterService;
import io.github.nucleuspowered.nucleus.services.interfaces.ICommandElementSupplier;
import io.github.nucleuspowered.nucleus.services.interfaces.ICommandMetadataService;
import io.github.nucleuspowered.nucleus.services.interfaces.ICompatibilityService;
import io.github.nucleuspowered.nucleus.services.interfaces.IConfigurateHelper;
import io.github.nucleuspowered.nucleus.services.interfaces.ICooldownService;
import io.github.nucleuspowered.nucleus.services.interfaces.IDocumentationGenerationService;
import io.github.nucleuspowered.nucleus.services.interfaces.IEconomyServiceProvider;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import io.github.nucleuspowered.nucleus.services.interfaces.IModuleDataProvider;
import io.github.nucleuspowered.nucleus.services.interfaces.INucleusTeleportService;
import io.github.nucleuspowered.nucleus.services.interfaces.INucleusTextTemplateFactory;
import io.github.nucleuspowered.nucleus.services.interfaces.IPermissionService;
import io.github.nucleuspowered.nucleus.services.interfaces.IPlaceholderService;
import io.github.nucleuspowered.nucleus.services.interfaces.IPlatformService;
import io.github.nucleuspowered.nucleus.services.interfaces.IPlayerDisplayNameService;
import io.github.nucleuspowered.nucleus.services.interfaces.IPlayerInformationService;
import io.github.nucleuspowered.nucleus.services.interfaces.IPlayerOnlineService;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import io.github.nucleuspowered.nucleus.services.interfaces.IStorageManager;
import io.github.nucleuspowered.nucleus.services.interfaces.ITextFileControllerCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.ITextStyleService;
import io.github.nucleuspowered.nucleus.services.interfaces.IUserCacheService;
import io.github.nucleuspowered.nucleus.services.interfaces.IUserPreferenceService;
import io.github.nucleuspowered.nucleus.services.interfaces.IWarmupService;
import io.github.nucleuspowered.nucleus.util.LazyLoad;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.spongepowered.api.plugin.PluginContainer;

@Singleton
public class NucleusServiceCollection
implements INucleusServiceCollection {
    private final Map<Class<?>, Object> instances = new HashMap();
    private final Map<Class<?>, Supplier<?>> suppliers = new HashMap();
    private final Provider<IMessageProviderService> messageProviderService;
    private final Provider<IEconomyServiceProvider> economyServiceProvider;
    private final Provider<IWarmupService> warmupService;
    private final Provider<ICooldownService> cooldownService;
    private final Provider<IPermissionService> permissionCheckService;
    private final Provider<IReloadableService> reloadableService;
    private final Provider<IPlayerOnlineService> playerOnlineService;
    private final Provider<IStorageManager> storageManager;
    private final Provider<IUserPreferenceService> userPreferenceService;
    private final Provider<ICommandMetadataService> commandMetadataService;
    private final Provider<IPlayerDisplayNameService> playerDisplayNameService;
    private final Provider<IModuleDataProvider> moduleConfigProvider;
    private final Provider<INucleusTeleportService> nucleusTeleportServiceProvider;
    private final Provider<ICommandElementSupplier> commandElementSupplierProvider;
    private final Provider<INucleusTextTemplateFactory> nucleusTextTemplateFactoryProvider;
    private final Provider<ITextFileControllerCollection> textFileControllerCollectionProvider;
    private final Provider<IUserCacheService> userCacheServiceProvider;
    private final Provider<IPlayerInformationService> playerInformationServiceProvider;
    private final Provider<IConfigurateHelper> configurateHelperProvider;
    private final Provider<IPlatformService> platformServiceProvider;
    private final Provider<ICompatibilityService> compatibilityServiceProvider;
    private final Provider<IChatMessageFormatterService> chatMessageFormatterProvider;
    private final Provider<IPlaceholderService> placeholderServiceProvider;
    private final Provider<IDocumentationGenerationService> documentationGenerationServiceProvider;
    private final Injector injector;
    private final PluginContainer pluginContainer;
    private final Logger logger;
    private final Provider<ITextStyleService> textStyleServiceProvider;
    private final Supplier<Path> dataDir;
    private final Path configPath;

    @Inject
    public NucleusServiceCollection(Injector injector, PluginContainer pluginContainer, Logger logger, @DataDirectory Supplier<Path> dataPath, @ConfigDirectory Path configPath) {
        this.messageProviderService = new LazyLoad<IMessageProviderService>(this, injector, IMessageProviderService.class);
        this.economyServiceProvider = new LazyLoad<IEconomyServiceProvider>(this, injector, IEconomyServiceProvider.class);
        this.warmupService = new LazyLoad<IWarmupService>(this, injector, IWarmupService.class);
        this.cooldownService = new LazyLoad<ICooldownService>(this, injector, ICooldownService.class);
        this.userPreferenceService = new LazyLoad<IUserPreferenceService>(this, injector, IUserPreferenceService.class);
        this.permissionCheckService = new LazyLoad<IPermissionService>(this, injector, IPermissionService.class);
        this.reloadableService = new LazyLoad<IReloadableService>(this, injector, IReloadableService.class);
        this.playerOnlineService = new LazyLoad<IPlayerOnlineService>(this, injector, IPlayerOnlineService.class);
        this.storageManager = new LazyLoad<IStorageManager>(this, injector, IStorageManager.class);
        this.commandMetadataService = new LazyLoad<ICommandMetadataService>(this, injector, ICommandMetadataService.class);
        this.playerDisplayNameService = new LazyLoad<IPlayerDisplayNameService>(this, injector, IPlayerDisplayNameService.class);
        this.moduleConfigProvider = new LazyLoad<IModuleDataProvider>(this, injector, IModuleDataProvider.class);
        this.nucleusTeleportServiceProvider = new LazyLoad<INucleusTeleportService>(this, injector, INucleusTeleportService.class);
        this.textStyleServiceProvider = new LazyLoad<ITextStyleService>(this, injector, ITextStyleService.class);
        this.commandElementSupplierProvider = new LazyLoad<ICommandElementSupplier>(this, injector, ICommandElementSupplier.class);
        this.nucleusTextTemplateFactoryProvider = new LazyLoad<INucleusTextTemplateFactory>(this, injector, INucleusTextTemplateFactory.class);
        this.textFileControllerCollectionProvider = new LazyLoad<ITextFileControllerCollection>(this, injector, ITextFileControllerCollection.class);
        this.userCacheServiceProvider = new LazyLoad<IUserCacheService>(this, injector, IUserCacheService.class);
        this.playerInformationServiceProvider = new LazyLoad<IPlayerInformationService>(this, injector, IPlayerInformationService.class);
        this.configurateHelperProvider = new LazyLoad<IConfigurateHelper>(this, injector, IConfigurateHelper.class);
        this.platformServiceProvider = new LazyLoad<IPlatformService>(this, injector, IPlatformService.class);
        this.compatibilityServiceProvider = new LazyLoad<ICompatibilityService>(this, injector, ICompatibilityService.class);
        this.chatMessageFormatterProvider = new LazyLoad<IChatMessageFormatterService>(this, injector, IChatMessageFormatterService.class);
        this.placeholderServiceProvider = new LazyLoad<IPlaceholderService>(this, injector, IPlaceholderService.class);
        this.documentationGenerationServiceProvider = new LazyLoad<IDocumentationGenerationService>(this, injector, IDocumentationGenerationService.class);
        this.injector = injector;
        this.pluginContainer = pluginContainer;
        this.logger = logger;
        this.dataDir = dataPath;
        this.configPath = configPath;
    }

    @Override
    public IMessageProviderService messageProvider() {
        return (IMessageProviderService)this.messageProviderService.get();
    }

    @Override
    public IPermissionService permissionService() {
        return (IPermissionService)this.permissionCheckService.get();
    }

    @Override
    public IEconomyServiceProvider economyServiceProvider() {
        return (IEconomyServiceProvider)this.economyServiceProvider.get();
    }

    @Override
    public IWarmupService warmupService() {
        return (IWarmupService)this.warmupService.get();
    }

    @Override
    public ICooldownService cooldownService() {
        return (ICooldownService)this.cooldownService.get();
    }

    @Override
    public IUserPreferenceService userPreferenceService() {
        return (IUserPreferenceService)this.userPreferenceService.get();
    }

    @Override
    public IReloadableService reloadableService() {
        return (IReloadableService)this.reloadableService.get();
    }

    @Override
    public IPlayerOnlineService playerOnlineService() {
        return (IPlayerOnlineService)this.playerOnlineService.get();
    }

    @Override
    public IStorageManager storageManager() {
        return (IStorageManager)this.storageManager.get();
    }

    @Override
    public ICommandMetadataService commandMetadataService() {
        return (ICommandMetadataService)this.commandMetadataService.get();
    }

    @Override
    public IPlayerDisplayNameService playerDisplayNameService() {
        return (IPlayerDisplayNameService)this.playerDisplayNameService.get();
    }

    @Override
    public IModuleDataProvider moduleDataProvider() {
        return (IModuleDataProvider)this.moduleConfigProvider.get();
    }

    @Override
    public INucleusTeleportService teleportService() {
        return (INucleusTeleportService)this.nucleusTeleportServiceProvider.get();
    }

    @Override
    public ICommandElementSupplier commandElementSupplier() {
        return (ICommandElementSupplier)this.commandElementSupplierProvider.get();
    }

    @Override
    public INucleusTextTemplateFactory textTemplateFactory() {
        return (INucleusTextTemplateFactory)this.nucleusTextTemplateFactoryProvider.get();
    }

    @Override
    public ITextFileControllerCollection textFileControllerCollection() {
        return (ITextFileControllerCollection)this.textFileControllerCollectionProvider.get();
    }

    @Override
    public ITextStyleService textStyleService() {
        return (ITextStyleService)this.textStyleServiceProvider.get();
    }

    @Override
    public IPlayerInformationService playerInformationService() {
        return (IPlayerInformationService)this.playerInformationServiceProvider.get();
    }

    @Override
    public IConfigurateHelper configurateHelper() {
        return (IConfigurateHelper)this.configurateHelperProvider.get();
    }

    @Override
    public ICompatibilityService compatibilityService() {
        return (ICompatibilityService)this.compatibilityServiceProvider.get();
    }

    @Override
    public IPlaceholderService placeholderService() {
        return (IPlaceholderService)this.placeholderServiceProvider.get();
    }

    @Override
    public IUserCacheService userCacheService() {
        return (IUserCacheService)this.userCacheServiceProvider.get();
    }

    @Override
    public IPlatformService platformService() {
        return (IPlatformService)this.platformServiceProvider.get();
    }

    @Override
    public IChatMessageFormatterService chatMessageFormatter() {
        return (IChatMessageFormatterService)this.chatMessageFormatterProvider.get();
    }

    @Override
    public IDocumentationGenerationService documentationGenerationService() {
        return (IDocumentationGenerationService)this.documentationGenerationServiceProvider.get();
    }

    @Override
    public Injector injector() {
        return this.injector;
    }

    @Override
    public PluginContainer pluginContainer() {
        return this.pluginContainer;
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public <I, C extends I> void registerService(Class<I> key, C service, boolean rereg) {
        if (!rereg && (this.instances.containsKey(key) || this.suppliers.containsKey(key))) {
            return;
        }
        this.suppliers.remove(key);
        this.instances.put(key, service);
    }

    @Override
    public <I> Optional<I> getService(Class<I> key) {
        if (this.instances.containsKey(key)) {
            return Optional.of(this.instances.get(key));
        }
        if (this.suppliers.containsKey(key)) {
            return Optional.of(this.suppliers.get(key).get());
        }
        return Optional.empty();
    }

    @Override
    public <I> I getServiceUnchecked(Class<I> key) {
        if (this.instances.containsKey(key)) {
            return (I)this.instances.get(key);
        }
        if (this.suppliers.containsKey(key)) {
            return (I)this.suppliers.get(key).get();
        }
        throw new NoSuchElementException(key.getName());
    }

    @Override
    public Path configDir() {
        return this.configPath;
    }

    @Override
    public Supplier<Path> dataDir() {
        return this.dataDir;
    }
}

