/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.services.impl.texttemplatefactory;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import io.github.nucleuspowered.nucleus.api.text.NucleusTextTemplate;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import io.github.nucleuspowered.nucleus.services.interfaces.ITextStyleService;
import io.github.nucleuspowered.nucleus.util.JsonConfigurateStringHelper;
import io.github.nucleuspowered.nucleus.util.Tuples;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextRepresentable;
import org.spongepowered.api.text.TextTemplate;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
public abstract class NucleusTextTemplateImpl
implements NucleusTextTemplate {
    @javax.annotation.Nullable
    private final Text prefix;
    @javax.annotation.Nullable
    private final Text suffix;
    private final String representation;
    private final TextTemplate textTemplate;
    private final Map<String, Function<CommandSource, Text>> tokenMap = Maps.newHashMap();
    final INucleusServiceCollection serviceCollection;
    private final Pattern enhancedUrlParser = Pattern.compile("(?<first>(^|\\s))(?<reset>&r)?(?<colour>(&[0-9a-flmnrok])+)?((?<options>\\{[a-z]+?})?(?<url>(http(s)?://)?([A-Za-z0-9]+\\.)+[A-Za-z0-9-]{2,}\\S*)|(?<specialUrl>(\\[(?<msg>.+?)](?<optionssurl>\\{[a-z]+})?\\((?<sUrl>(http(s)?://)?([A-Za-z0-9-]+\\.)+[A-Za-z0-9]{2,}[^\\s)]*)\\)))|(?<specialCmd>(\\[(?<sMsg>.+?)](?<optionsscmd>\\{[a-z]+})?\\((?<sCmd>/.+?)\\))))", 2);

    public NucleusTextTemplateImpl(String representation, @javax.annotation.Nullable Text prefix, @javax.annotation.Nullable Text suffix, INucleusServiceCollection serviceCollection) {
        this.serviceCollection = serviceCollection;
        this.representation = representation;
        Tuple<TextTemplate, Map<String, Function<CommandSource, Text>>> t = this.parse(representation);
        this.textTemplate = (TextTemplate)t.getFirst();
        this.tokenMap.putAll((Map)t.getSecond());
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public NucleusTextTemplateImpl(String representation, INucleusServiceCollection serviceCollection) {
        this(representation, null, null, serviceCollection);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Optional<Text> getPrefix() {
        return Optional.ofNullable(this.prefix);
    }

    @Override
    public Optional<Text> getSuffix() {
        return Optional.ofNullable(this.suffix);
    }

    @Override
    public Text getBody(CommandSource source) {
        return this.getBody(source, Collections.emptyMap());
    }

    @Override
    public Text getBody(CommandSource source, CommandSource sender) {
        Optional<Text> s = Optional.of(this.serviceCollection.placeholderService().parse(sender, "displayname").toText());
        return this.getBody(source, Collections.singletonMap("sender", se -> s));
    }

    @Override
    public Text getBody(CommandSource source, @javax.annotation.Nullable Map<String, Function<CommandSource, Optional<Text>>> tokensArray) {
        Map tokens = this.textTemplate.getArguments();
        HashMap finalArgs = Maps.newHashMap();
        tokens.forEach((k, v) -> {
            String key = k.toLowerCase();
            TextRepresentable t = this.tokenMap.containsKey(key) ? (TextRepresentable)this.tokenMap.get(key).apply(source) : (tokensArray != null && tokensArray.containsKey(key) ? (TextRepresentable)((Optional)((Function)tokensArray.get(key)).apply(source)).orElse(null) : this.serviceCollection.placeholderService().parse(source, key));
            if (t != null) {
                finalArgs.put(k, t);
            }
        });
        return this.textTemplate.apply((Map)finalArgs).build();
    }

    public String getRepresentation() {
        return this.representation;
    }

    @Override
    public TextTemplate getTextTemplate() {
        return this.textTemplate;
    }

    abstract Tuple<TextTemplate, Map<String, Function<CommandSource, Text>>> parse(String var1);

    @Override
    public boolean containsTokens() {
        return !this.textTemplate.getArguments().isEmpty();
    }

    @Override
    public Text getForCommandSource(CommandSource source) {
        return this.getForCommandSource(source, Collections.emptyMap());
    }

    @Override
    public Text getForCommandSource(CommandSource source, CommandSource sender) {
        return this.applyPrefixSuffix(this.getBody(source, sender));
    }

    @Override
    public Text getForCommandSource(CommandSource source, @javax.annotation.Nullable Map<String, Function<CommandSource, Optional<Text>>> tokensArray) {
        return this.applyPrefixSuffix(this.getBody(source, tokensArray));
    }

    public Text toText() {
        return this.textTemplate.toText();
    }

    Tuples.NullableTuple<List<TextRepresentable>, Map<String, Function<CommandSource, Text>>> createTextTemplateFragmentWithLinks(String message) {
        Preconditions.checkNotNull((Object)message, (Object)"message");
        if (message.isEmpty()) {
            return new Tuples.NullableTuple<ArrayList, Object>(Lists.newArrayList((Object[])new TextRepresentable[]{Text.EMPTY}), null);
        }
        Matcher m = this.enhancedUrlParser.matcher(message);
        ITextStyleService textStyleService = this.serviceCollection.textStyleService();
        if (!m.find()) {
            return new Tuples.NullableTuple<ArrayList, Object>(Lists.newArrayList((Object[])new TextRepresentable[]{textStyleService.oldLegacy(message)}), null);
        }
        HashMap args = Maps.newHashMap();
        ArrayList texts = Lists.newArrayList();
        String remaining = message;
        ITextStyleService.TextFormat st = ITextStyleService.EMPTY;
        do {
            String msg;
            String url;
            String[] textArray = remaining.split(this.enhancedUrlParser.pattern(), 2);
            Text first = Text.builder().color(st.colour()).style(new TextStyle[]{st.style()}).append(new Text[]{textStyleService.oldLegacy(textArray[0])}).build();
            texts.add(first);
            remaining = textArray.length == 2 ? textArray[1] : null;
            String colourMatch = m.group("colour");
            if (colourMatch != null && !colourMatch.isEmpty()) {
                TextStyle reset = TextStyles.NONE;
                if (m.group("reset") != null) {
                    reset = TextStyles.RESET;
                }
                first = Text.of((Object[])new Object[]{reset, textStyleService.oldLegacy(m.group("colour"))});
            }
            st = textStyleService.getLastColourAndStyle((TextRepresentable)first, st);
            String whiteSpace = m.group("first");
            if (m.group("url") != null) {
                url = m.group("url");
                texts.add(this.getTextForUrl(url, url, whiteSpace, st, m.group("options")));
                continue;
            }
            if (m.group("specialUrl") != null) {
                url = m.group("sUrl");
                msg = m.group("msg");
                texts.add(this.getTextForUrl(url, msg, whiteSpace, st, m.group("optionssurl")));
                continue;
            }
            String cmd = m.group("sCmd");
            msg = m.group("sMsg");
            String optionList = m.group("optionsscmd");
            if (cmd.contains("{{subject}}")) {
                String arg = UUID.randomUUID().toString();
                args.put(arg, cs -> {
                    String command = cmd.replace("{{subject}}", cs.getName());
                    return this.getCmd(msg, command, optionList, whiteSpace);
                });
                texts.add(TextTemplate.arg((String)arg).color(st.colour()).style(st.style()).build());
                continue;
            }
            texts.add(Text.of((Object[])new Object[]{st.colour(), st.style(), this.getCmd(msg, cmd, optionList, whiteSpace)}));
        } while (remaining != null && m.find());
        if (remaining != null) {
            Text.Builder tb = Text.builder().color(st.colour()).style(new TextStyle[]{st.style()}).append(new Text[]{TextSerializers.FORMATTING_CODE.deserialize(remaining)});
            if (remaining.matches("^\\s+&r.*")) {
                tb.style(new TextStyle[]{TextStyles.RESET});
            }
            texts.add(tb.build());
        }
        return new Tuples.NullableTuple<List<TextRepresentable>, Map<String, Function<CommandSource, Text>>>(texts, args);
    }

    private Text applyPrefixSuffix(Text body) {
        Text.Builder builder = Text.builder();
        ITextStyleService.TextFormat st = null;
        if (this.prefix != null) {
            builder.append(new Text[]{this.prefix});
            st = this.serviceCollection.textStyleService().getLastColourAndStyle((TextRepresentable)this.prefix, null);
        }
        if (!body.isEmpty()) {
            if (st == null) {
                builder.append(new Text[]{body});
            } else {
                builder.append(new Text[]{Text.builder().color(st.colour()).style(new TextStyle[]{st.style()}).append(new Text[]{body}).build()});
            }
        }
        if (this.suffix != null) {
            builder.append(new Text[]{this.suffix});
        }
        return builder.build();
    }

    private Text getCmd(String msg, String cmd, @Nullable String optionList, String whiteSpace) {
        LiteralText.Builder textBuilder = Text.builder((String)msg).onClick((ClickAction)TextActions.runCommand((String)cmd)).onHover(this.setupHoverOnCmd(cmd, optionList));
        if (optionList != null && optionList.contains("s")) {
            textBuilder.onClick((ClickAction)TextActions.suggestCommand((String)cmd));
        }
        Text toAdd = textBuilder.build();
        if (!whiteSpace.isEmpty()) {
            toAdd = Text.join((Text[])new Text[]{Text.of((String)whiteSpace), toAdd});
        }
        return toAdd;
    }

    @javax.annotation.Nullable
    private HoverAction<?> setupHoverOnCmd(String cmd, @javax.annotation.Nullable String optionList) {
        if (optionList != null) {
            if (optionList.contains("h")) {
                return null;
            }
            if (optionList.contains("s")) {
                return TextActions.showText((Text)this.serviceCollection.messageProvider().getMessage("chat.command.clicksuggest", cmd));
            }
        }
        return TextActions.showText((Text)this.serviceCollection.messageProvider().getMessage("chat.command.click", cmd));
    }

    private Text getTextForUrl(String url, String msg, String whiteSpace, ITextStyleService.TextFormat st, @javax.annotation.Nullable String optionString) {
        String toParse = TextSerializers.FORMATTING_CODE.stripCodes(url);
        IMessageProviderService messageProviderService = this.serviceCollection.messageProvider();
        try {
            URL urlObj = !toParse.startsWith("http://") && !toParse.startsWith("https://") ? new URL("http://" + toParse) : new URL(toParse);
            LiteralText.Builder textBuilder = Text.builder((String)msg).color(st.colour()).style(new TextStyle[]{st.style()}).onClick((ClickAction)TextActions.openUrl((URL)urlObj));
            if (optionString == null || !optionString.contains("h")) {
                textBuilder.onHover((HoverAction)TextActions.showText((Text)messageProviderService.getMessage("chat.url.click", url)));
            }
            if (!whiteSpace.isEmpty()) {
                return Text.builder((String)whiteSpace).append(new Text[]{textBuilder.build()}).build();
            }
            return textBuilder.build();
        }
        catch (MalformedURLException e) {
            this.serviceCollection.logger().warn(messageProviderService.getMessageString("chat.url.malformed", url));
            e.printStackTrace();
            LiteralText ret = Text.builder((String)url).color(st.colour()).style(new TextStyle[]{st.style()}).build();
            if (!whiteSpace.isEmpty()) {
                return Text.builder((String)whiteSpace).append(new Text[]{ret}).build();
            }
            return ret;
        }
    }

    public static class Empty
    extends NucleusTextTemplateImpl {
        public static NucleusTextTemplateImpl INSTANCE;

        Empty(INucleusServiceCollection serviceCollection) {
            super("", serviceCollection);
            INSTANCE = this;
        }

        @Override
        Tuple<TextTemplate, Map<String, Function<CommandSource, Text>>> parse(String parser) {
            return Tuple.of((Object)TextTemplate.EMPTY, new HashMap());
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    }

    static class Json
    extends NucleusTextTemplateImpl {
        @javax.annotation.Nullable
        private static TypeSerializer<TextTemplate> textTemplateTypeSerializer = null;

        private static @NonNull TypeSerializer<TextTemplate> getSerialiser() {
            if (textTemplateTypeSerializer == null) {
                textTemplateTypeSerializer = ConfigurationOptions.defaults().getSerializers().get(TypeToken.of(TextTemplate.class));
            }
            return textTemplateTypeSerializer;
        }

        Json(String representation, INucleusServiceCollection serviceCollection) {
            super(representation, serviceCollection);
        }

        @Override
        Tuple<TextTemplate, Map<String, Function<CommandSource, Text>>> parse(String parser) {
            try {
                TextTemplate t = (TextTemplate)Json.getSerialiser().deserialize(TypeToken.of(TextTemplate.class), JsonConfigurateStringHelper.getNodeFromJson(parser).orElseGet(() -> ConfigurationNode.root().setValue((Object)parser)));
                return Tuple.of((Object)(t == null ? TextTemplate.EMPTY : t), new HashMap());
            }
            catch (ObjectMappingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class Ampersand
    extends NucleusTextTemplateImpl {
        private static final Pattern pattern = Pattern.compile("(?<url>\\[[^\\[]+]\\(/[^)]*?)?(?<match>\\{\\{(?!subject)(?<name>[^\\s{}]+)}})(?<urltwo>[^(]*?\\))?");

        Ampersand(String representation, INucleusServiceCollection serviceCollection) {
            super(representation, serviceCollection);
        }

        Ampersand(String representation, @javax.annotation.Nullable Text prefix, @javax.annotation.Nullable Text suffix, INucleusServiceCollection serviceCollection) {
            super(representation, prefix, suffix, serviceCollection);
        }

        @Override
        Tuple<TextTemplate, Map<String, Function<CommandSource, Text>>> parse(String string) {
            Matcher mat = pattern.matcher(string);
            ArrayList map = Lists.newArrayList();
            ArrayList s = Lists.newArrayList((Object[])pattern.split(string));
            int index = 0;
            while (mat.find()) {
                if (mat.group("url") != null && mat.group("urltwo") != null) {
                    String toUpdate = (String)s.get(index);
                    toUpdate = toUpdate + mat.group();
                    if (s.size() >= index + 1) continue;
                    toUpdate = toUpdate + (String)s.get(index + 1);
                    s.remove(index + 1);
                    s.set(index, toUpdate);
                    continue;
                }
                String out = mat.group("url");
                if (out != null) {
                    if (s.isEmpty()) {
                        s.add(out);
                    } else {
                        s.set(index, (String)s.get(index) + out);
                    }
                }
                ++index;
                out = mat.group("urltwo");
                if (out != null) {
                    if (s.size() <= index) {
                        s.add(out);
                    } else {
                        s.set(index, out + (String)s.get(index));
                    }
                }
                map.add(mat.group("name").toLowerCase());
            }
            ArrayDeque<Object> texts = new ArrayDeque<Object>();
            HashMap tokens = Maps.newHashMap();
            if (s.size() > 0) {
                this.createTextTemplateFragmentWithLinks((String)s.get(0)).mapIfPresent(texts::addAll, tokens::putAll);
            }
            for (int i = 0; i < map.size(); ++i) {
                TextTemplate.Arg.Builder arg = TextTemplate.arg((String)((String)map.get(i))).optional();
                TextRepresentable r = (TextRepresentable)texts.peekLast();
                ITextStyleService.TextFormat style = null;
                if (r != null) {
                    style = this.serviceCollection.textStyleService().getLastColourAndStyle(r, null);
                    arg.color(style.colour()).style(style.style());
                }
                texts.add(arg.build());
                if (s.size() <= i + 1) continue;
                Tuples.NullableTuple<List<TextRepresentable>, Map<String, Function<CommandSource, Text>>> tt = this.createTextTemplateFragmentWithLinks((String)s.get(i + 1));
                if (style != null && tt.getFirst().isPresent()) {
                    texts.push(style.textOf());
                }
                this.createTextTemplateFragmentWithLinks((String)s.get(i + 1)).mapIfPresent(texts::addAll, tokens::putAll);
            }
            return Tuple.of((Object)TextTemplate.of((Object[])texts.toArray(new Object[0])), (Object)tokens);
        }
    }
}

