/*
 * Decompiled with CFR 0.152.
 */
package org.dave.ocsensors.integration.forge;

import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.dave.ocsensors.integration.AbstractCapabilityIntegration;
import org.dave.ocsensors.integration.Integrate;
import org.dave.ocsensors.integration.PrefixRegistry;
import org.dave.ocsensors.integration.ScanDataList;

@Integrate(name="fluid")
public class FluidHandlerIntegration
extends AbstractCapabilityIntegration {
    @Override
    protected Capability getCompatibleCapability() {
        return CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public void init() {
        PrefixRegistry.addSupportedPrefix(FluidHandlerIntegration.class, "fluid");
    }

    @Override
    public void addScanData(ScanDataList data, TileEntity entity, @Nullable EnumFacing side) {
        IFluidHandler fluidHandler = (IFluidHandler)entity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
        ArrayList result = new ArrayList();
        for (IFluidTankProperties tank : fluidHandler.getTankProperties()) {
            HashMap<String, Integer> tankMap = new HashMap<String, Integer>();
            tankMap.put("capacity", tank.getCapacity());
            tankMap.put("contents", (Integer)tank.getContents());
            result.add(tankMap);
        }
        data.add("fluid", result);
    }
}

