/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.sound;

import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.util.ShadyPines;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class SoundImpl
implements Sound {
    private final Sound.Source source;
    private final float volume;
    private final float pitch;

    SoundImpl(@NonNull Sound.Source source, float volume, float pitch) {
        this.source = source;
        this.volume = volume;
        this.pitch = pitch;
    }

    @Override
    public @NonNull Sound.Source source() {
        return this.source;
    }

    @Override
    public float volume() {
        return this.volume;
    }

    @Override
    public float pitch() {
        return this.pitch;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SoundImpl)) {
            return false;
        }
        SoundImpl that = (SoundImpl)other;
        return this.name().equals(that.name()) && this.source == that.source && ShadyPines.equals(this.volume, that.volume) && ShadyPines.equals(this.pitch, that.pitch);
    }

    public int hashCode() {
        int result = this.name().hashCode();
        result = 31 * result + this.source.hashCode();
        result = 31 * result + Float.hashCode(this.volume);
        result = 31 * result + Float.hashCode(this.pitch);
        return result;
    }

    public @NonNull String toString() {
        return "SoundImpl{name=" + this.name() + ", source=" + (Object)((Object)this.source) + ", volume=" + this.volume + ", pitch=" + this.pitch + '}';
    }
}

