/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Logger;
import wile.rsgauges.ModContent;
import wile.rsgauges.blocks.IRsNeighbourInteractionSensitive;
import wile.rsgauges.detail.DataFixing;
import wile.rsgauges.detail.ModAuxiliaries;
import wile.rsgauges.detail.ModConfig;

@Mod(modid="rsgauges", name="Gauges and Switches", version="1.2.8", dependencies="required-after:forge@[14.23.5.2768,)", useMetadata=true, updateJSON="https://raw.githubusercontent.com/stfwi/rsgauges/develop/meta/update.json", certificateFingerprint="ed58ed655893ced6280650866985abcae2bf7559", acceptedMinecraftVersions="[1.12.2]")
public class ModRsGauges {
    public static final String MODID = "rsgauges";
    public static final String MODNAME = "Gauges and Switches";
    public static final String MODVERSION = "1.2.8";
    public static final String MODMCVERSION = "1.12.2";
    public static final String MODFINGERPRINT = "ed58ed655893ced6280650866985abcae2bf7559";
    public static final String MODBUILDID = "#c6af2dc";
    public static Logger logger;
    @Mod.Instance
    public static ModRsGauges instance;
    @SidedProxy(clientSide="wile.rsgauges.detail.ClientProxy", serverSide="wile.rsgauges.detail.ServerProxy")
    public static IProxy proxy;
    public static final CreativeTabs CREATIVE_TAB_RSGAUGES;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        logger.info("Gauges and Switches: Version 1.12.2-1.2.8" + (MODBUILDID.equals("@MOD_BUILDID@") ? "" : " #c6af2dc") + ".");
        if (MODFINGERPRINT.equals("@MOD_SIGNSHA1@")) {
            logger.warn("Gauges and Switches: Mod is NOT signed.");
        } else {
            logger.info("Gauges and Switches: Found fingerprint ed58ed655893ced6280650866985abcae2bf7559.");
        }
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        DataFixing.registerDataFixers();
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ModConfig.onPostInit(event);
        proxy.postInit(event);
        ModAuxiliaries.BlockCategories.compose();
    }

    static {
        CREATIVE_TAB_RSGAUGES = new CreativeTabs("tabrsgauges"){

            @SideOnly(value=Side.CLIENT)
            @Nonnull
            public ItemStack func_78016_d() {
                return new ItemStack((Block)(ModContent.ITEMGROUP_BLOCK != null ? ModContent.ITEMGROUP_BLOCK : Blocks.field_150442_at));
            }
        };
    }

    @Mod.EventBusSubscriber
    public static final class RegistrationSubscriptions {
        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            ModContent.registerBlocks(event);
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            ModContent.registerItemBlocks(event);
            ModContent.registerItems(event);
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public static void registerModels(ModelRegistryEvent event) {
            ModContent.initModels();
        }

        @SubscribeEvent
        public static void playerInteract(PlayerInteractEvent event) {
            boolean is_lclick;
            World world = event.getWorld();
            if (world.field_72995_K) {
                return;
            }
            boolean is_rclick = event instanceof PlayerInteractEvent.LeftClickBlock && event.getHand() == EnumHand.MAIN_HAND;
            boolean bl = is_lclick = event instanceof PlayerInteractEvent.RightClickBlock && event.getHand() == EnumHand.MAIN_HAND;
            if (!is_rclick && !is_lclick) {
                return;
            }
            BlockPos fromPos = event.getPos();
            for (EnumFacing facing : EnumFacing.values()) {
                BlockPos pos = fromPos.func_177972_a(facing);
                IBlockState state = event.getWorld().func_180495_p(pos);
                if (!(state.func_177230_c() instanceof IRsNeighbourInteractionSensitive) || !((IRsNeighbourInteractionSensitive)state.func_177230_c()).onNeighborBlockPlayerInteraction(world, pos, state, fromPos, event.getEntityLiving(), event.getHand(), is_lclick)) continue;
                event.setCancellationResult(EnumActionResult.SUCCESS);
            }
        }
    }

    public static interface IProxy {
        public void preInit(FMLPreInitializationEvent var1);

        public void init(FMLInitializationEvent var1);

        public void postInit(FMLPostInitializationEvent var1);
    }
}

